/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sirius.query.legacy.tools.AcceleoToolsPlugin;
import org.eclipse.sirius.query.legacy.tools.resources.UnicodeBOMInputStream;

public class Resources {
    private static final String INSTALL_LOCATION_TAG = "INSTALL_LOCATION";
    private static final String WORKSPACE_LOCATION_TAG = "WORKSPACE_LOCATION";
    private static final int BOM_SIZE = 3;
    private static Map fileTimestamp = new HashMap();
    private static Map fileRequired = new HashMap();
    private static final String ENCODING_START = "encoding=";

    public static StringBuffer getFileContent(IFile file) {
        return Resources.getFileContent(file, true);
    }

    public static StringBuffer getFileContent(IFile file, boolean report) {
        StringBuffer buffer = Resources.doGetFileContent(file, report);
        if (file != null && Resources.isTemplateFile(file.getName()) && Resources.getEncoding(buffer) != null) {
            buffer = Resources.getEncodedFileContent(file, report, Resources.getEncoding(buffer));
        }
        return buffer;
    }

    private static StringBuffer doGetFileContent(IFile file, boolean report) {
        StringBuffer buffer;
        block24: {
            buffer = new StringBuffer();
            if (file != null) {
                UnicodeBOMInputStream ubis = null;
                InputStream content = null;
                try {
                    try {
                        content = file.getContents(false);
                        ubis = new UnicodeBOMInputStream(content);
                        ubis.skipBOM();
                        byte[] readBuffer = new byte[ubis.available()];
                        int n = ubis.read(readBuffer);
                        while (n > 0) {
                            buffer.append(new String(readBuffer));
                            n = ubis.read(readBuffer);
                        }
                    }
                    catch (Exception e) {
                        block25: {
                            if (report) {
                                AcceleoToolsPlugin.getDefault().log(e, true);
                            }
                            if (ubis != null) {
                                try {
                                    ubis.close();
                                }
                                catch (IOException e2) {
                                    if (!report) break block25;
                                    AcceleoToolsPlugin.getDefault().log(e2, true);
                                }
                            }
                        }
                        if (content == null) break block24;
                        try {
                            content.close();
                        }
                        catch (IOException e3) {
                            if (report) {
                                AcceleoToolsPlugin.getDefault().log(e3, true);
                            }
                        }
                    }
                }
                finally {
                    block27: {
                        block26: {
                            if (ubis != null) {
                                try {
                                    ubis.close();
                                }
                                catch (IOException e) {
                                    if (!report) break block26;
                                    AcceleoToolsPlugin.getDefault().log(e, true);
                                }
                            }
                        }
                        if (content != null) {
                            try {
                                content.close();
                            }
                            catch (IOException e) {
                                if (!report) break block27;
                                AcceleoToolsPlugin.getDefault().log(e, true);
                            }
                        }
                    }
                }
            }
        }
        return buffer;
    }

    public static StringBuffer getFileContent(File file) {
        return Resources.getFileContent(file, true);
    }

    public static StringBuffer getFileContent(File file, boolean report) {
        StringBuffer buffer = Resources.doGetFileContent(file, report);
        String encoding = Resources.getEncoding(buffer);
        if (file != null && Resources.isTemplateFile(file.getName()) && encoding != null) {
            buffer = Resources.getEncodedFileContent(file, report, encoding);
        }
        return buffer;
    }

    private static boolean isTemplateFile(String filename) {
        if (filename != null) {
            if (filename.toLowerCase().endsWith("mt")) {
                return true;
            }
            if (filename.toLowerCase().endsWith("tr")) {
                return true;
            }
        }
        return false;
    }

    public static StringBuffer getEncodedFileContent(File file, boolean report, String encodingCode) {
        StringBuffer buffer;
        block9: {
            buffer = new StringBuffer();
            try {
                FileInputStream fiss = new FileInputStream(file);
                UnicodeBOMInputStream fis = new UnicodeBOMInputStream(fiss);
                fis.skipBOM();
                InputStreamReader in = new InputStreamReader((InputStream)fis, encodingCode);
                try {
                    char[] buff = new char[512];
                    int size = in.read(buff);
                    while (size > 0) {
                        buffer.append(buff, 0, size);
                        size = in.read(buff);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (fiss != null) {
                        fiss.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (IOException e) {
                if (!report || e instanceof UnsupportedEncodingException) break block9;
                AcceleoToolsPlugin.getDefault().log(e, true);
            }
        }
        return buffer;
    }

    public static StringBuffer getEncodedFileContent(IFile file, boolean report, String encodingCode) {
        StringBuffer buffer;
        block20: {
            buffer = new StringBuffer();
            if (file != null) {
                UnicodeBOMInputStream content = null;
                try {
                    try {
                        content = new UnicodeBOMInputStream(file.getContents(false));
                        content.skipBOM();
                        InputStreamReader in = new InputStreamReader((InputStream)content, encodingCode);
                        try {
                            char[] buff = new char[content.available()];
                            int size = in.read(buff);
                            while (size > 0) {
                                buffer.append(buff, 0, size);
                                size = in.read(buff);
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        if (report) {
                            AcceleoToolsPlugin.getDefault().log(e, true);
                        }
                        if (content == null) break block20;
                        try {
                            content.close();
                        }
                        catch (IOException e2) {
                            if (report && !(e2 instanceof UnsupportedEncodingException)) {
                                AcceleoToolsPlugin.getDefault().log(e2, true);
                            }
                        }
                    }
                }
                finally {
                    block21: {
                        if (content != null) {
                            try {
                                content.close();
                            }
                            catch (IOException e) {
                                if (!report || e instanceof UnsupportedEncodingException) break block21;
                                AcceleoToolsPlugin.getDefault().log(e, true);
                            }
                        }
                    }
                }
            }
        }
        return buffer;
    }

    private static StringBuffer doGetFileContent(File file, boolean report) {
        StringBuffer buffer;
        block9: {
            buffer = new StringBuffer();
            try {
                FileInputStream fis = new FileInputStream(file);
                UnicodeBOMInputStream ubis = new UnicodeBOMInputStream(fis);
                ubis.skipBOM();
                BufferedReader in = new BufferedReader(new InputStreamReader(ubis));
                try {
                    char[] buff = new char[512];
                    int size = in.read(buff);
                    while (size > 0) {
                        buffer.append(buff, 0, size);
                        size = in.read(buff);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                    if (ubis != null) {
                        ubis.close();
                    }
                }
            }
            catch (IOException e) {
                if (!report) break block9;
                AcceleoToolsPlugin.getDefault().log(e, true);
            }
        }
        return buffer;
    }

    public static IFolder getOutputFolder(IProject project) {
        IJavaProject projet = JavaCore.create((IProject)project);
        try {
            IPath output = projet.getOutputLocation();
            if (output != null && output.segmentCount() > 1) {
                IFolder folder = project.getWorkspace().getRoot().getFolder(output);
                if (folder.exists()) {
                    return folder;
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public static Resource getResource(IResource resource, boolean load) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource result = resourceSet.getResource(Resources.createPlatformResourceURI(resource.getFullPath().toString()), load);
        return result;
    }

    public static IFile getIFile(Resource resource) {
        URI uri = resource.getURI();
        if ("cdo".equals(uri.scheme())) {
            if (resource.getURI().path() != null && resource.getURI().path() != null) {
                IPath path = Path.fromPortableString((String)resource.getURI().path());
                IContainer folder = (IContainer)ResourcesPlugin.getWorkspace().getRoot().findMember(path.removeLastSegments(1));
                if (folder != null) {
                    if ("system".equals((path = path.removeFirstSegments(path.segmentCount() - 1)).getFileExtension())) {
                        path = path.removeFileExtension().removeFileExtension().addFileExtension("system").addFileExtension("ost");
                    } else if ("xmi".equals(path.getFileExtension())) {
                        path = path.removeFileExtension().addFileExtension("ost");
                    }
                    return folder.getFile(path);
                }
            }
        } else {
            String path = uri.path();
            if (path != null) {
                IResource member;
                if (path.startsWith("/resource")) {
                    path = path.substring("/resource".length());
                }
                if ((member = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) instanceof IFile) {
                    return (IFile)member;
                }
            }
        }
        return null;
    }

    public static IResource findResource(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().exists(path)) {
            return workspace.getRoot().findMember(path);
        }
        return null;
    }

    public static IFile findFile(IPath path) {
        IResource resource = Resources.findResource(path);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public static URI createPlatformResourceURI(String path) {
        if (path.startsWith("platform:/plugin")) {
            return URI.createURI((String)path, (boolean)true);
        }
        return URI.createPlatformResourceURI((String)path, (boolean)true);
    }

    public static String makeWorkspaceRelativePath(String absolutePath) {
        return Resources.makeRelativePath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), absolutePath);
    }

    public static String makeRelativePath(String parentPath, String absolutePath) {
        String relativePath = null;
        if (parentPath != null && absolutePath != null && parentPath.length() < absolutePath.length()) {
            File absoluteFile = new File(absolutePath);
            if (absoluteFile.isAbsolute()) {
                File parentFile = new File(parentPath);
                if (parentFile.isAbsolute()) {
                    int dirLength;
                    String dirPath = parentFile.getAbsolutePath().replace('\\', '/');
                    if ((absolutePath = absolutePath.replace('\\', '/')).substring(0, dirLength = dirPath.length()).equalsIgnoreCase(dirPath) && (relativePath = absolutePath.substring(dirLength)).startsWith("/")) {
                        relativePath = relativePath.substring(1);
                    }
                } else {
                    relativePath = absoluteFile.getPath().replace('\\', '/');
                }
            } else {
                relativePath = absoluteFile.getPath().replace('\\', '/');
            }
        } else if (absolutePath != null) {
            relativePath = absolutePath.replace('\\', '/');
        }
        return relativePath;
    }

    public static String transformToAbsolutePath(URL url) {
        String absolutePath;
        try {
            URL transformedUrl = FileLocator.toFileURL((URL)url);
            File file = new File(transformedUrl.getFile());
            absolutePath = file.getAbsolutePath();
        }
        catch (IOException e) {
            absolutePath = "";
            AcceleoToolsPlugin.getDefault().log(e, true);
        }
        return absolutePath;
    }

    public static IFile getIFile(URI uri) {
        IProject project = Resources.getProject(uri);
        if (project != null) {
            IPath path = Resources.isPlatformResourceURI(uri) ? new Path(URI.decode((String)uri.path())).removeFirstSegments(2) : new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
            return project.getFile(path);
        }
        return null;
    }

    private static IProject getProject(URI uri) {
        String projectName;
        if (Resources.isPlatformResourceURI(uri)) {
            projectName = uri.segment(1);
        } else if (uri.scheme() == null) {
            projectName = new Path(uri.path()).segment(0);
        } else {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(URI.decode((String)projectName));
        if (project != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    private static boolean isPlatformResourceURI(URI uri) {
        return "platform".equals(uri.scheme()) && "resource".equals(uri.segment(0));
    }

    public static String[] getRequiredPluginIDs(IProject project) {
        List<String> IDs = new ArrayList();
        IFile file = project.getFile("META-INF/MANIFEST.MF");
        Double cachedTimestamp = (Double)fileTimestamp.get(file);
        if (cachedTimestamp != null && file.getModificationStamp() + file.getLocalTimeStamp() == cachedTimestamp.longValue()) {
            IDs = (List)fileRequired.get(file);
        } else {
            block24: {
                if (file.exists()) {
                    InputStream manifestStream = null;
                    try {
                        manifestStream = new FileInputStream(file.getLocation().toFile());
                        Manifest manifest = new Manifest(manifestStream);
                        Properties prop = Resources.manifestToProperties(manifest.getMainAttributes());
                        String requiredBundles = (String)prop.get("Require-Bundle");
                        if (requiredBundles != null) {
                            StringTokenizer st = new StringTokenizer(requiredBundles, ",");
                            while (st.hasMoreTokens()) {
                                String id = st.nextToken().trim();
                                int iDot = id.indexOf(59);
                                if (iDot > -1) {
                                    id = id.substring(0, iDot).trim();
                                }
                                if (id.length() <= 0) continue;
                                IDs.add(id);
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        try {
                            if (manifestStream != null) {
                                manifestStream.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException) {}
                        break block24;
                    }
                    catch (IOException iOException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (manifestStream != null) {
                                    manifestStream.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            throw throwable;
                        }
                        try {
                            if (manifestStream != null) {
                                manifestStream.close();
                            }
                            break block24;
                        }
                        catch (IOException iOException3) {}
                        break block24;
                    }
                    try {
                        if (manifestStream != null) {
                            manifestStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            fileTimestamp.put(file, new Double(file.getModificationStamp() + file.getLocalTimeStamp()));
            fileRequired.put(file, IDs);
        }
        return IDs.toArray(new String[IDs.size()]);
    }

    private static Properties manifestToProperties(Attributes d) {
        Iterator<Object> iter = d.keySet().iterator();
        Properties result = new Properties();
        while (iter.hasNext()) {
            Attributes.Name key = (Attributes.Name)iter.next();
            result.put(key.toString(), d.get(key));
        }
        return result;
    }

    public static String decodeAcceleoAbsolutePath(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith(WORKSPACE_LOCATION_TAG)) {
            String workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation() != null ? ResourcesPlugin.getWorkspace().getRoot().getLocation().toString() : "";
            return String.valueOf(workspaceLocation) + path.substring(WORKSPACE_LOCATION_TAG.length());
        }
        if (path.startsWith(INSTALL_LOCATION_TAG)) {
            String installLocation = Platform.getInstallLocation() != null ? new Path(Resources.transformToAbsolutePath(Platform.getInstallLocation().getURL())).toString() : "";
            return String.valueOf(installLocation) + path.substring(INSTALL_LOCATION_TAG.length());
        }
        return path;
    }

    public static String encodeAcceleoAbsolutePath(String path) {
        if (path == null) {
            return path;
        }
        path = new Path(path).toString();
        String workspaceLocation = null;
        if (ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
            workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        if (workspaceLocation != null && path.startsWith(workspaceLocation)) {
            return WORKSPACE_LOCATION_TAG + path.substring(workspaceLocation.length());
        }
        String installLocation = null;
        if (Platform.getInstallLocation() != null) {
            installLocation = new Path(Resources.transformToAbsolutePath(Platform.getInstallLocation().getURL())).toString();
        }
        if (installLocation != null && path.startsWith(installLocation)) {
            return INSTALL_LOCATION_TAG + path.substring(installLocation.length());
        }
        return path;
    }

    public static String getEncoding(StringBuffer buffer) {
        String startMarker = "<%--";
        String endMarker = "--%>";
        String result = Resources.doGetEncoding(buffer, startMarker, endMarker);
        if (result == null) {
            startMarker = "[%--";
            endMarker = "--%]";
            result = Resources.doGetEncoding(buffer, startMarker, endMarker);
        }
        return result;
    }

    private static String doGetEncoding(StringBuffer buffer, String startMarker, String endMarker) {
        int end;
        int start = buffer.indexOf(String.valueOf(startMarker) + ENCODING_START);
        if (start != -1 && (end = buffer.indexOf(endMarker, start)) != -1) {
            String encoding = buffer.substring(start + (String.valueOf(startMarker) + ENCODING_START).length(), end);
            return encoding.trim().toUpperCase();
        }
        return null;
    }
}

