/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.builder.MethodLeakDetector;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class LeakReturnTypeDetector
extends MethodLeakDetector {
    public LeakReturnTypeDetector(Set<String> nonApiPackageNames) {
        super(nonApiPackageNames);
    }

    @Override
    protected String getSeverityKey() {
        return "LEAK_METHOD_RETURN_TYPE";
    }

    @Override
    public int getReferenceKinds() {
        return 8;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean isProblem(IReference reference, IProgressMonitor monitor) {
        if (super.isProblem(reference, monitor)) {
            return true;
        }
        IApiType type = (IApiType)reference.getResolvedReference();
        int modifiers = type.getModifiers();
        if (Flags.isPackageDefault((int)modifiers)) return Flags.isPackageDefault((int)modifiers);
        if (!(reference instanceof Reference)) return Flags.isPackageDefault((int)modifiers);
        try {
            IApiType iApiType;
            List<IApiType> parameterList = ((Reference)reference).getParameterList();
            Iterator<IApiType> iterator = parameterList.iterator();
            do {
                if (iterator.hasNext()) continue;
                return Flags.isPackageDefault((int)modifiers);
            } while (!Flags.isPackageDefault((int)(iApiType = iterator.next()).getModifiers()));
            return true;
        }
        catch (CoreException coreException) {
            LeakReturnTypeDetector.checkIfDisposed(reference.getMember().getApiComponent(), monitor);
        }
        return Flags.isPackageDefault((int)modifiers);
    }
}

