/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.actions;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.metric.MetricActivator;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.actions.ProgressMonitoringActionsHelper;
import org.polarsys.capella.core.ui.metric.core.DefaultFilter;
import org.polarsys.capella.core.ui.metric.core.Metric;
import org.polarsys.capella.core.ui.metric.core.MetricTree;
import org.polarsys.capella.core.ui.metric.dialog.MetricDialog;

public class MetricAction
extends BaseSelectionListenerAction {
    private ExecutionManager exeManager = ExecutionManagerRegistry.getInstance().addNewManager();
    private TransactionalEditingDomain editingDomain = this.exeManager.getEditingDomain();
    private Resource res = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)this.editingDomain);

    public MetricAction() {
        super(MetricMessages.metricAction_lbl);
        this.setImageDescriptor(MetricActivator.getDefault().getImageDescriptor("chart_16.gif"));
    }

    public void run() {
        EObject rootSemanticObject = ProgressMonitoringActionsHelper.getSelectedEObject(this.getStructuredSelection());
        MetricTree<EObject> metricTree = this.computeMetricTree(rootSemanticObject);
        this.openMetricsDialog(rootSemanticObject, metricTree);
    }

    public MetricTree<EObject> computeMetricTree(EObject rootSemanticObject) {
        MetricTree<EObject> metricTree = null;
        if (rootSemanticObject instanceof Project) {
            Project project = (Project)rootSemanticObject;
            metricTree = this.createMetricTreeForProject(project, null);
        } else if (rootSemanticObject instanceof SystemEngineering) {
            SystemEngineering se = (SystemEngineering)rootSemanticObject;
            metricTree = this.createMetricTreeForSystemEngineering(se, null);
        } else if (rootSemanticObject instanceof ModellingArchitecture) {
            ModellingArchitecture arch = (ModellingArchitecture)rootSemanticObject;
            metricTree = this.createMetricTreeForArchitecture(arch, null);
        }
        if (metricTree != null) {
            for (MetricTree<EObject> leaf : metricTree.getLeafs()) {
                EObject container = leaf.getElement();
                Map<EClass, Integer> classToCount = this.countObjectByClass(container);
                for (Map.Entry<EClass, Integer> entry : classToCount.entrySet()) {
                    EClass eClass = entry.getKey();
                    int countOfClass = entry.getValue();
                    EObject tempEObject = this.createTemproraryEObject(container, eClass);
                    MetricTree<EObject> newTreeNode = new MetricTree<EObject>(tempEObject, leaf);
                    newTreeNode.increaseCount(countOfClass);
                }
                leaf.sortChildren();
            }
        }
        return metricTree;
    }

    private EObject createTemproraryEObject(EObject container, EClass eclass) {
        EFactory factory = eclass.getEPackage().getEFactoryInstance();
        final EObject tempEObject = factory.create(eclass);
        if (tempEObject instanceof FunctionalExchange && container instanceof OperationalAnalysis) {
            OaFactory oaFactory = OaFactory.eINSTANCE;
            OperationalActivity operationalActivity = oaFactory.createOperationalActivity();
            FunctionalExchange interaction = (FunctionalExchange)tempEObject;
            interaction.setSource((ActivityNode)operationalActivity);
            interaction.setTarget((ActivityNode)operationalActivity);
            interaction.setName("Interaction");
        }
        this.editingDomain.getCommandStack().execute((Command)new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                MetricAction.this.res.getContents().add((Object)tempEObject);
            }
        });
        return tempEObject;
    }

    private Map<EClass, Integer> countObjectByClass(EObject container) {
        Metric<EClass> metric = new Metric<EClass>();
        metric.addFilter(new DefaultFilter());
        TreeIterator iterator = container.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!metric.accept(eObject)) continue;
            metric.update(eObject.eClass());
        }
        return metric.getResult();
    }

    private MetricTree<EObject> createMetricTreeForProject(Project project, MetricTree<EObject> parent) {
        MetricTree<EObject> tree = new MetricTree<EObject>((EObject)project, parent);
        for (ModelRoot mr : project.getOwnedModelRoots()) {
            if (!(mr instanceof SystemEngineering)) continue;
            SystemEngineering se = (SystemEngineering)mr;
            this.createMetricTreeForSystemEngineering(se, tree);
        }
        return tree;
    }

    private MetricTree<EObject> createMetricTreeForSystemEngineering(SystemEngineering se, MetricTree<EObject> parent) {
        MetricTree<EObject> tree = new MetricTree<EObject>((EObject)se, parent);
        for (ModellingArchitecture arch : se.getOwnedArchitectures()) {
            this.createMetricTreeForArchitecture(arch, tree);
        }
        return tree;
    }

    private MetricTree<EObject> createMetricTreeForArchitecture(ModellingArchitecture arch, MetricTree<EObject> parent) {
        return new MetricTree<EObject>((EObject)arch, parent);
    }

    private void openMetricsDialog(EObject rootSemanticObject, MetricTree<EObject> metricTree) {
        if (metricTree != null) {
            String title = MetricMessages.metricDialogDefaultTitle;
            String resourceName = "";
            Object selectedObject = this.getStructuredSelection().getFirstElement();
            if (selectedObject instanceof IFile) {
                title = NLS.bind((String)MetricMessages.metricDialogTitleFromFile, (Object)((IFile)selectedObject).getName());
                resourceName = ((IFile)selectedObject).getName();
            } else if (selectedObject instanceof EObject) {
                String objectName = selectedObject instanceof NamedElement ? ((NamedElement)selectedObject).getName() : rootSemanticObject.eClass().getName();
                resourceName = rootSemanticObject.eResource().getURI().lastSegment();
                title = NLS.bind((String)MetricMessages.metricDialogTitleFromEObj, (Object[])new Object[]{objectName, resourceName.replace("capella", "aird")});
            }
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MetricDialog dialog = new MetricDialog(shell, title, "", MetricMessages.metricDialogShellTitle);
            dialog.setData(metricTree);
            dialog.setResourceName(resourceName);
            dialog.open();
            metricTree.clear();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            Object selectedObj = selection.getFirstElement();
            if (selectedObj instanceof IFile) {
                Session session = SessionHelper.getSession((IFile)((IFile)selectedObj));
                return session != null && session.isOpen();
            }
            if (selectedObj instanceof EObject) {
                return selectedObj instanceof SystemEngineering || selectedObj instanceof BlockArchitecture;
            }
        }
        return false;
    }
}

