/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SortContentAction;

public class SortSelectionAction
extends SortContentAction {
    public SortSelectionAction() {
        super(Messages.SortSelectionAction_Label);
    }

    private EReference getCommonContainmentReference(List objs) {
        EObject parent = null;
        EReference childContainmentReference = null;
        for (Object obj : objs) {
            if (!(obj instanceof EObject)) {
                return null;
            }
            if (parent == null) {
                parent = ((EObject)obj).eContainer();
            } else if (parent != ((EObject)obj).eContainer()) {
                return null;
            }
            if (childContainmentReference == null) {
                childContainmentReference = (EReference)((EObject)obj).eContainingFeature();
                continue;
            }
            if (childContainmentReference == (EReference)((EObject)obj).eContainingFeature()) continue;
            return null;
        }
        return childContainmentReference;
    }

    @Override
    public void run() {
        final List selectedElements = this.getStructuredSelection().toList();
        TransactionHelper.getExecutionManager(this.filterNonEObjects(selectedElements)).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                EReference commonContainmentReference = SortSelectionAction.this.getCommonContainmentReference(selectedElements);
                ArrayList<Integer> childIndexes = new ArrayList<Integer>();
                ArrayList<EObject> childrenToSort = new ArrayList<EObject>();
                if (commonContainmentReference != null) {
                    EList ownedElements = (EList)((EObject)selectedElements.get(0)).eContainer().eGet((EStructuralFeature)commonContainmentReference);
                    for (Object selectedElement : selectedElements) {
                        int index = ownedElements.indexOf(selectedElement);
                        childIndexes.add(index);
                        childrenToSort.add((EObject)selectedElement);
                    }
                    Collections.sort(childrenToSort, abstractNamedElementNameComparator);
                    ArrayList<EObject> tmpList = new ArrayList<EObject>();
                    for (EObject obj : ownedElements) {
                        tmpList.add(obj);
                    }
                    if (tmpList.size() >= 2) {
                        int i = 0;
                        while (i < childIndexes.size()) {
                            tmpList.set((Integer)childIndexes.get(i), (EObject)childrenToSort.get(i));
                            ++i;
                        }
                        ECollections.setEList((EList)ownedElements, tmpList);
                        CommonViewer _commonViewer = ((CommonNavigator)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("capella.project.explorer")).getCommonViewer();
                        _commonViewer.refresh(true);
                    }
                }
            }
        });
    }

    @Override
    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            return false;
        }
        List selectedElements = this.getStructuredSelection().toList();
        EReference commonContainmentReference = this.getCommonContainmentReference(selectedElements);
        if (commonContainmentReference == null) {
            return false;
        }
        return super.updateSelection(selection);
    }
}

