/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.menu.dynamic.DynamicActionProvider;
import org.polarsys.capella.core.menu.dynamic.DynamicCreationAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers.Messages;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;
import org.polarsys.capella.core.sirius.ui.actions.NewScenarioRepresentationAction;

public class DynamicNewRepresentationContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    IServiceLocator locator = null;

    public void initialize(IServiceLocator serviceLocator_p) {
        this.locator = serviceLocator_p;
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem item = new NewRepresentationActionProvider().createContributionItem();
        return new IContributionItem[]{item};
    }

    class NewRepresentationActionProvider
    extends DynamicActionProvider {
        private static final String CAPELLA_PROJECT_DIAGRAMS_MENU_ID = "capella.project.diagrams.menu";

        NewRepresentationActionProvider() {
        }

        protected void fillContextMenu(IMenuManager menu, DynamicCreationAction action, String groupId) {
            ISelectionService service = (ISelectionService)DynamicNewRepresentationContributionItem.this.locator.getService(ISelectionService.class);
            ISelection selection = service.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.createMenu(menu, (IStructuredSelection)selection);
            }
        }

        protected IContributionItem createContributionItem() {
            MenuManager subMenuManager = new MenuManager(Messages.NewRepresentationActionProvider_NewRepresentationAction_Title, CAPELLA_PROJECT_DIAGRAMS_MENU_ID);
            IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            IIdentifier identifier = activityManager.getIdentifier(CAPELLA_PROJECT_DIAGRAMS_MENU_ID);
            if (identifier.isEnabled()) {
                this.fillContextMenu((IMenuManager)subMenuManager, this.dynamicAction, null);
            }
            return subMenuManager;
        }

        private void createMenu(IMenuManager menu, IStructuredSelection selection) {
            EObject firstSelectedEObject;
            Session currentSession;
            Object firstElement;
            IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            IIdentifier identifier = activityManager.getIdentifier(CAPELLA_PROJECT_DIAGRAMS_MENU_ID);
            if (identifier.isEnabled() && (firstElement = selection.getFirstElement()) instanceof EObject && (currentSession = SessionManager.INSTANCE.getSession(firstSelectedEObject = (EObject)firstElement)) != null) {
                IModel sessionModel = ILibraryManager.INSTANCE.getModel(TransactionHelper.getEditingDomain((Session)currentSession));
                IModel currentElementModel = ILibraryManager.INSTANCE.getModel(firstSelectedEObject);
                if (sessionModel == null || sessionModel.equals(currentElementModel)) {
                    this.createNewDiagramMenu(firstSelectedEObject, menu, currentSession);
                }
            }
        }

        private void createNewDiagramMenu(EObject firstSelectedEObject, IMenuManager menu, Session currentSession) {
            Collection selectedViewpoints = currentSession.getSelectedViewpoints(false);
            Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, firstSelectedEObject);
            if (!descriptions.isEmpty()) {
                for (RepresentationDescription description : descriptions) {
                    menu.add((IAction)new NewRepresentationAction(description, firstSelectedEObject, currentSession));
                }
                if (firstSelectedEObject instanceof AbstractCapability) {
                    this.addScenariosFromCapabilitiesMenuEntries((AbstractCapability)firstSelectedEObject, menu, currentSession, selectedViewpoints);
                }
            }
        }

        private void addScenariosFromCapabilitiesMenuEntries(AbstractCapability capa, IMenuManager menu, Session currentSession, Collection<Viewpoint> selectedViewpoints) {
            for (Viewpoint vp : selectedViewpoints) {
                for (RepresentationDescription representationDescription : vp.getOwnedRepresentations()) {
                    if (!(representationDescription instanceof SequenceDiagramDescription)) continue;
                    SequenceDiagramDescription sdd = (SequenceDiagramDescription)representationDescription;
                    String precondition = sdd.getPreconditionExpression();
                    try {
                        if (!InterpreterUtil.getInterpreter((EObject)capa).evaluateBoolean((EObject)capa, precondition)) continue;
                        menu.add((IAction)new NewScenarioRepresentationAction((RepresentationDescription)sdd, capa, currentSession));
                    }
                    catch (EvaluationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

