/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.drop;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.IDropAssistant;

public abstract class AbstractCapellaDropAdapterAssistant
extends CommonDropAdapterAssistant
implements IDropAssistant {
    public boolean isSupportedType(TransferData transferType_p) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(transferType_p);
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter_p, DropTargetEvent dropTargetEvent_p, Object target_p) {
        return this.handleDrop(target_p, dropAdapter_p.getCurrentOperation(), dropTargetEvent_p);
    }

    protected float getLocation(DropTargetEvent event) {
        if (event.item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)event.item;
            Tree control = treeItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = treeItem.getBounds();
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        if (event.item instanceof TableItem) {
            TableItem tableItem = (TableItem)event.item;
            Table control = tableItem.getParent();
            Point point = control.toControl(new Point(event.x, event.y));
            Rectangle bounds = tableItem.getBounds(0);
            return (float)(point.y - bounds.y) / (float)bounds.height;
        }
        return 0.0f;
    }
}

