/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.view;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ILinkHelper;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class AirdDiagramLinkHelper
implements ILinkHelper {
    public void activateEditor(IWorkbenchPage page, IStructuredSelection selection) {
        DialectEditor editor;
        IEditingSession sessionUI;
        DSemanticDiagram semanticDiagram;
        Session session;
        Object firstElement;
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof DSemanticDiagram && (session = SessionManager.INSTANCE.getSession((semanticDiagram = (DSemanticDiagram)firstElement).getTarget())) != null && (sessionUI = SessionUIManager.INSTANCE.getUISession(session)) != null && (editor = sessionUI.getEditor((DRepresentation)semanticDiagram)) != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
        }
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ISelectionProvider selectionProvider = activeEditor.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return new StructuredSelection();
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            View gmfView;
            EObject element;
            IStructuredSelection diagramSelection = (IStructuredSelection)selection;
            Object firstElement = diagramSelection.getFirstElement();
            if (firstElement instanceof GraphicalEditPart) {
                GraphicalEditPart editPart = (GraphicalEditPart)firstElement;
                if ((editPart = this.getDiagramEditPart(editPart)) != null) {
                    firstElement = editPart.getModel();
                }
            }
            if (firstElement instanceof View && (element = (gmfView = (View)firstElement).getElement()) != null) {
                if (element instanceof ModelElement) {
                    return new StructuredSelection((Object)element);
                }
                if (element instanceof DRepresentation) {
                    DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)((DRepresentation)element));
                    return descriptor == null ? null : new StructuredSelection((Object)descriptor);
                }
            }
        }
        return null;
    }

    private DiagramEditPart getDiagramEditPart(GraphicalEditPart editPart) {
        if (editPart instanceof DiagramEditPart) {
            return (DiagramEditPart)editPart;
        }
        if (editPart != null) {
            GraphicalEditPart parent = (GraphicalEditPart)editPart.getParent();
            return this.getDiagramEditPart(parent);
        }
        return null;
    }
}

