/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorPatternFilter;

public class CapellaCommonViewer
extends CommonViewer {
    Set<ViewerFilter> mandatoryFilters = new HashSet<ViewerFilter>();

    public CapellaCommonViewer(String aViewerId, Composite aParent, int aStyle) {
        super(aViewerId, aParent, aStyle);
    }

    public void setFilters(ViewerFilter ... filters) {
        this.clearCachesForFilters();
        ViewerFilter[] filtersToSet = new ViewerFilter[filters.length + this.mandatoryFilters.size()];
        int j = 0;
        while (j < filters.length) {
            filtersToSet[j] = filters[j];
            ++j;
        }
        int i = filters.length;
        Iterator<ViewerFilter> iterator = this.mandatoryFilters.iterator();
        while (iterator.hasNext()) {
            ViewerFilter mandatoryFilter;
            filtersToSet[i] = mandatoryFilter = iterator.next();
            ++i;
        }
        super.setFilters(filtersToSet);
    }

    public void addMandatoryFilter(ViewerFilter filter) {
        this.mandatoryFilters.add(filter);
    }

    public void removeMandatoryFilter(ViewerFilter filter) {
        this.mandatoryFilters.remove(filter);
    }

    protected void clearCachesForFilters() {
        ViewerFilter[] viewerFilterArray = this.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter viewerFilter = viewerFilterArray[n2];
            if (viewerFilter instanceof CapellaCommonNavigatorPatternFilter) {
                ((CapellaCommonNavigatorPatternFilter)viewerFilter).doClearCaches();
            }
            ++n2;
        }
    }

    public void add(Object parentElementOrTreePath, Object childElement) {
        this.clearCachesForFilters();
        super.add(parentElementOrTreePath, childElement);
    }

    public void add(Object parentElementOrTreePath, Object ... childElements) {
        this.clearCachesForFilters();
        super.add(parentElementOrTreePath, childElements);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.clearCachesForFilters();
        super.inputChanged(input, oldInput);
    }

    public void insert(Object parentElementOrTreePath, Object element, int position) {
        this.clearCachesForFilters();
        super.insert(parentElementOrTreePath, element, position);
    }

    public void refresh() {
        this.clearCachesForFilters();
        super.refresh();
    }

    public void refresh(boolean updateLabels) {
        this.clearCachesForFilters();
        super.refresh(updateLabels);
    }

    public void refresh(Object element) {
        this.clearCachesForFilters();
        super.refresh(element);
    }

    public void refresh(Object element, boolean updateLabels) {
        this.clearCachesForFilters();
        super.refresh(element, updateLabels);
    }

    public void remove(Object elementsOrTreePaths) {
        this.clearCachesForFilters();
        super.remove(elementsOrTreePaths);
    }

    public void remove(Object parent, Object ... elements) {
        this.clearCachesForFilters();
        super.remove(parent, elements);
    }

    public void remove(Object ... elementsOrTreePaths) {
        this.clearCachesForFilters();
        super.remove(elementsOrTreePaths);
    }

    public void replace(Object parentElementOrTreePath, int index, Object element) {
        this.clearCachesForFilters();
        super.replace(parentElementOrTreePath, index, element);
    }

    public void setChildCount(Object elementOrTreePath, int count) {
        this.clearCachesForFilters();
        super.setChildCount(elementOrTreePath, count);
    }

    public void setContentProvider(IContentProvider provider) {
        this.clearCachesForFilters();
        super.setContentProvider(provider);
    }

    public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
        this.clearCachesForFilters();
        super.setHasChildren(elementOrTreePath, hasChildren);
    }
}

