/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.AbstractSelectionDialog;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.core.data.capellacore.NamedElement;

public class SelectNewRepresentationDialog
extends AbstractSelectionDialog<RepresentationDescription> {
    HashSet<RepresentationDescription> descriptions;
    RepresentationDescription selectedRepresentationDescription;
    private Text text;
    private String newRepresentationName;
    private IInputValidator validator;
    private Text errorMessageText;
    private String errorMessage;
    private String message;
    private EObject selectedEObject;

    public SelectNewRepresentationDialog(Shell parentShell, String message, EObject selectedEObject, Collection<RepresentationDescription> descriptions) {
        super(parentShell);
        this.selectedEObject = selectedEObject;
        this.descriptions = new HashSet<RepresentationDescription>(descriptions);
        this.message = message;
        this.setTitle(String.valueOf(Messages.newRepresentationFor) + ((NamedElement)selectedEObject).getName());
        this.validator = newText -> {
            if (newText.isBlank()) {
                return Messages.blankName;
            }
            return null;
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setMessage(this.message);
        this.createMessageArea(composite);
        ComboViewer comboViewer = new ComboViewer(composite, 2828);
        comboViewer.getCombo().setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText("Name :");
        label.setFont(parent.getFont());
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.text = new Text(composite, 2052);
        this.text.setFont(parent.getFont());
        this.text.setLayoutData((Object)data);
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RepresentationDescription description = (RepresentationDescription)element;
                IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)description);
                String newName = "";
                String titleExpression = description.getTitleExpression();
                if (!StringUtil.isEmpty((String)titleExpression)) {
                    try {
                        newName = interpreter.evaluateString((EObject)description, titleExpression);
                    }
                    catch (EvaluationException e) {
                        SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
                    }
                }
                return newName;
            }
        });
        comboViewer.getCombo().setLayoutData((Object)data);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setInput(this.descriptions);
        this.setInitialSelection(new RepresentationDescription[]{this.descriptions.iterator().next()});
        comboViewer.addSelectionChangedListener(selectionChangedEvent -> {
            this.selectedRepresentationDescription = (RepresentationDescription)((StructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
            this.text.setText(this.computeDefaultName(this.selectedEObject, this.selectedRepresentationDescription));
        });
        comboViewer.setSelection((ISelection)new StructuredSelection(this.getInitialSelection()));
        this.newRepresentationName = this.computeDefaultName(this.selectedEObject, (RepresentationDescription)this.getInitialSelection().get(0));
        this.text.setText(this.newRepresentationName);
        this.text.addModifyListener(e -> this.validateInput());
        this.errorMessageText = new Text(composite, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        comboViewer.addSelectionChangedListener(event -> this.text.setText(this.computeDefaultName(this.selectedEObject, (RepresentationDescription)((StructuredSelection)event.getSelection()).getFirstElement())));
        return composite;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean isResizable() {
        return false;
    }

    public DialogTray getTray() {
        return null;
    }

    public String getName() {
        return this.newRepresentationName;
    }

    protected String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        String newName = "New ";
        newName = String.valueOf(newName) + repDescription.getName();
        String titleExpression = repDescription.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject, titleExpression);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
            }
        }
        return newName;
    }

    protected void validateInput() {
        this.newRepresentationName = this.text.getText();
        if (this.validator != null) {
            this.errorMessage = this.validator.isValid(this.text.getText());
        }
        this.setErrorMessage(this.errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    public RepresentationDescription getSelectedRepresentationDescription() {
        return this.selectedRepresentationDescription;
    }
}

