/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.utils.saxparser;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class SaxParserHelper {
    public static String escapeSpecialCharacter(String input) {
        String result = input;
        result = result.replace("&nbsp;", "&#160;");
        result = result.replace("&euro;", "&#8364;");
        result = result.replace("&trade;", "&#8482;");
        result = result.replace("&amp;", "&#38;");
        result = result.replace("&lt;", "&#60;");
        result = result.replace("&gt;", "&#62;");
        result = result.replace("&quot;", "&#34;");
        result = result.replace("'", "&#39;");
        result = result.replace("&apos;", "&#39;");
        result = result.replace("&", "&#38;");
        return result;
    }

    public static String unescapeSpecialCharacter(String input) {
        String result = input;
        result = result.replace("&#160;", " ");
        result = result.replace("&euro;", "\u20a0");
        result = result.replace("&#8364;", "\u20a0");
        result = result.replace("&trade;", "\ufffd");
        result = result.replace("&#8482;", "\ufffd");
        result = result.replace("&amp;", "&");
        result = result.replace("&#38;", "&");
        result = result.replace("&#60;", "<");
        result = result.replace("&lt;", "<");
        result = result.replace("&#62;", ">");
        result = result.replace("&gt;", ">");
        result = result.replace("&#34;", "\"");
        result = result.replace("&quot;", "\"");
        result = result.replace("&#39;", "'");
        result = result.replace("&apos;", "'");
        return result;
    }

    public static EObject getEObjectFromHrefAttribute(EObject context, String attValue) {
        String[] split = attValue.split("hlink://");
        EObject eObject = null;
        if (split.length == 2) {
            String id = split[1].replace("/", "");
            ResourceSet rSet = TransactionHelper.getEditingDomain((EObject)context).getResourceSet();
            eObject = RepresentationHelper.getRepresentationDescriptorOrSemanticObject((ResourceSet)rSet, (String)id);
        }
        return eObject;
    }
}

