/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.ui.queries.CatalogElementOrigin;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;

public class RecDynamicMenu
extends ContributionItem {
    public RecDynamicMenu() {
    }

    public RecDynamicMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection theSelection = selectionService.getSelection();
        if (!(theSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)theSelection;
        Collection<CatalogElement> commonRecs = RecDynamicMenu.getCommonRecs(selection);
        for (CatalogElement commonRec : commonRecs) {
            EList referencedElements = commonRec.getReferencedElements();
            StructuredSelection newSelection = new StructuredSelection((List)referencedElements);
            if (referencedElements.isEmpty()) continue;
            MenuItem menuItem = new MenuItem(menu, 32, index);
            menuItem.setText(commonRec.getName());
            menuItem.addSelectionListener(new SelectionListener((IStructuredSelection)newSelection){
                private final /* synthetic */ IStructuredSelection val$newSelection;
                {
                    this.val$newSelection = iStructuredSelection;
                }

                public void widgetSelected(SelectionEvent e) {
                    ShowInDiagramAction action = new ShowInDiagramAction();
                    action.selectionChanged(this.val$newSelection);
                    action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public static Collection<CatalogElement> getCommonRecs(IStructuredSelection selection) {
        LinkedHashSet<EObject> selectedElements = new LinkedHashSet<EObject>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object aSelectedElement = objectArray[n2];
            if (!(aSelectedElement instanceof AbstractGraphicalEditPart)) {
                return new ArrayList<CatalogElement>();
            }
            EObject semantic = CapellaAdapterHelper.resolveBusinessObject((Object)((AbstractGraphicalEditPart)aSelectedElement));
            selectedElements.add(semantic);
            ++n2;
        }
        HashMap<EObject, Collection> mapOfRecs = new HashMap<EObject, Collection>();
        for (EObject anElement : selectedElements) {
            Collection replicablesElements = new CatalogElementOrigin().compute(anElement).stream().map(CatalogElement.class::cast).collect(Collectors.toList());
            mapOfRecs.put(anElement, replicablesElements);
        }
        Iterator recIterator = mapOfRecs.values().iterator();
        HashSet<CatalogElement> commonRecs = new HashSet<CatalogElement>((Collection)recIterator.next());
        while (recIterator.hasNext()) {
            commonRecs.retainAll((Collection)recIterator.next());
        }
        return commonRecs;
    }

    public static boolean hasCommonRecs(IStructuredSelection selection) {
        return !RecDynamicMenu.getCommonRecs(selection).isEmpty();
    }
}

