/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.menu;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.ui.queries.ReferencingReplicas;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.ShowInDiagramAction;

public class RplDynamicMenu
extends ContributionItem {
    public RplDynamicMenu() {
    }

    public RplDynamicMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        ISelectionService selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ISelection theSelection = selectionService.getSelection();
        if (!(theSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)theSelection;
        Collection<CatalogElement> commonRpls = RplDynamicMenu.getCommonRpls(selection);
        for (CatalogElement commonRpl : commonRpls) {
            EList referencedElements = commonRpl.getReferencedElements();
            StructuredSelection newSelection = new StructuredSelection((List)referencedElements);
            if (referencedElements.isEmpty()) continue;
            MenuItem menuItem = new MenuItem(menu, 32, index);
            menuItem.setText(commonRpl.getName());
            menuItem.addSelectionListener(new SelectionListener((IStructuredSelection)newSelection){
                private final /* synthetic */ IStructuredSelection val$newSelection;
                {
                    this.val$newSelection = iStructuredSelection;
                }

                public void widgetSelected(SelectionEvent e) {
                    ShowInDiagramAction action = new ShowInDiagramAction();
                    action.selectionChanged(this.val$newSelection);
                    action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public static Collection<CatalogElement> getCommonRpls(IStructuredSelection selection) {
        LinkedHashSet<EObject> selectedElements = new LinkedHashSet<EObject>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object aSelectedElement = objectArray[n2];
            if (!(aSelectedElement instanceof AbstractGraphicalEditPart)) {
                return new ArrayList<CatalogElement>();
            }
            EObject semantic = CapellaAdapterHelper.resolveBusinessObject((Object)((AbstractGraphicalEditPart)aSelectedElement));
            selectedElements.add(semantic);
            ++n2;
        }
        HashMap<EObject, Collection> mapOfRpls = new HashMap<EObject, Collection>();
        for (EObject anElement : selectedElements) {
            Collection replicas = new ReferencingReplicas().compute(anElement).stream().map(CatalogElement.class::cast).collect(Collectors.toList());
            mapOfRpls.put(anElement, replicas);
        }
        Iterator rplIterator = mapOfRpls.values().iterator();
        HashSet<CatalogElement> commonRpls = new HashSet<CatalogElement>((Collection)rplIterator.next());
        while (rplIterator.hasNext()) {
            commonRpls.retainAll((Collection)rplIterator.next());
        }
        return commonRpls;
    }

    public static boolean hasCommonRpls(IStructuredSelection selection) {
        return !RplDynamicMenu.getCommonRpls(selection).isEmpty();
    }
}

