/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.obfuscator.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.obfuscator.CapellaModelObfuscatorActivator;
import org.polarsys.capella.core.model.obfuscator.IResourceObfuscator;
import org.polarsys.capella.core.model.obfuscator.actions.Messages;
import org.polarsys.capella.core.model.obfuscator.actions.ObfuscateRepresentationCommand;
import org.polarsys.capella.core.model.obfuscator.actions.ObfuscateSemanticResourceCommand;
import org.polarsys.capella.core.sirius.ui.actions.CloseSessionAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class ObfuscateSessionAction
extends BaseSelectionListenerAction {
    public ObfuscateSessionAction() {
        super(Messages.ObfuscateModelAction_Title);
        this.setImageDescriptor(CapellaModelObfuscatorActivator.getDefault().getImageDescriptor("full/ctool16/binary-16x16.gif"));
    }

    public void run() {
        if (!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.ObfuscateModelAction_ConfirmationDialog_Title, (String)Messages.ObfuscateModelAction_ConfirmationDialog_Message)) {
            return;
        }
        this.obfuscate();
    }

    public void obfuscate() {
        List sessions = SessionHelper.getSessionsFromSelection((IStructuredSelection)this.getStructuredSelection());
        for (Couple sessionCouple : sessions) {
            Session session = (Session)sessionCouple.getKey();
            Collection semanticResources = session.getSemanticResources();
            ExecutionManager executionManager = TransactionHelper.getExecutionManager((Session)session);
            for (Resource resource : semanticResources) {
                URI uri = resource.getURI();
                if (uri.fileExtension() == null || uri.fileExtension().equals("afm") || CapellaResourceHelper.isAirdResource((URI)uri)) continue;
                this.obfuscateSemanticResource(resource, executionManager);
            }
            for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
                this.obfuscateRepresentation(descriptor, executionManager);
            }
            for (Resource resource : this.getComplementaryResources(semanticResources)) {
                this.obfuscateComplementaryResource(resource, executionManager);
            }
            this.obfuscateFile((IFile)sessionCouple.getValue(), session);
            session.save((IProgressMonitor)new NullProgressMonitor());
            CloseSessionAction closeSessionAction = new CloseSessionAction();
            closeSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection(sessionCouple.getValue()));
            closeSessionAction.run();
            this.obfuscateFile((IFile)sessionCouple.getValue());
        }
    }

    protected void obfuscateFile(IFile value_p, Session session_p) {
    }

    protected void obfuscateFile(IFile value_p) {
    }

    protected Set<Resource> getComplementaryResources(Collection<Resource> semanticResources) {
        HashSet<Resource> result = new HashSet<Resource>();
        result.addAll((Collection<Resource>)semanticResources.iterator().next().getResourceSet().getResources());
        return result;
    }

    protected void obfuscateComplementaryResource(final Resource resource_p, ExecutionManager executionManager_p) {
        executionManager_p.execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                IConfigurationElement[] element;
                IConfigurationElement[] iConfigurationElementArray = element = ExtensionPointHelper.getConfigurationElements((String)CapellaModelObfuscatorActivator.getDefault().getPluginId(), (String)"Obfuscator");
                int n = element.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce = iConfigurationElementArray[n2];
                    IResourceObfuscator obfuscator = (IResourceObfuscator)ExtensionPointHelper.createInstance((IConfigurationElement)ce, (String)"obfuscatorClass");
                    if (obfuscator != null && obfuscator.isApplicableOn(resource_p)) {
                        obfuscator.obfuscate(resource_p);
                    }
                    ++n2;
                }
            }
        });
    }

    protected void obfuscateRepresentation(DRepresentationDescriptor descriptor_p, ExecutionManager executionManager_p) {
        executionManager_p.execute((ICommand)new ObfuscateRepresentationCommand(descriptor_p));
    }

    protected void obfuscateSemanticResource(Resource resource_p, ExecutionManager executionManager_p) {
        executionManager_p.execute((ICommand)new ObfuscateSemanticResourceCommand(resource_p));
    }
}

