/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.capellamodeller.validation;

import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ConstraintLocationRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Constraint) {
            Constraint constraint = (Constraint)eObj;
            EList constrainedElements = constraint.getConstrainedElements();
            if (CsServices.getService().isMultipartMode((ModelElement)eObj)) {
                if (constraint.eContainer() instanceof PartDeploymentLink && constrainedElements != null && !constrainedElements.isEmpty() && !((ModelElement)constrainedElements.get(0)).equals(constraint.eContainer())) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)constraint), "first value of ConstrainedElements"});
                }
            } else {
                boolean isConstrainingPartOrPDL;
                if (BlockArchitectureExt.getRootBlockArchitecture((EObject)constraint) instanceof EPBSArchitecture) {
                    return ctx.createSuccessStatus();
                }
                boolean bl = isConstrainingPartOrPDL = !constrainedElements.stream().filter(element -> element instanceof Part || element instanceof PartDeploymentLink).collect(Collectors.toList()).isEmpty();
                if ((constraint.eContainer() instanceof Part || constraint.eContainer() instanceof PartDeploymentLink) && !isConstrainingPartOrPDL) {
                    return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)constraint), "Component"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

