/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.capellaelement;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class AbstractTraceSourceAndTargetNaming
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof TraceableElement) {
            TraceableElement cst = (TraceableElement)eObj;
            EList outgoingTraces = cst.getOutgoingTraces();
            for (AbstractTrace abstractTrace : outgoingTraces) {
                String targetName;
                if (!CapellaElementExt.isValidTransitionTrace((AbstractTrace)abstractTrace) || !this.isNotRootElement((EObject)cst)) continue;
                TraceableElement sourceElement = abstractTrace.getSourceElement();
                TraceableElement targetElement = abstractTrace.getTargetElement();
                if (sourceElement == null || targetElement == null || !(sourceElement instanceof AbstractNamedElement) || !(targetElement instanceof AbstractNamedElement) || !(sourceElement instanceof CapellaElement) || !(targetElement instanceof CapellaElement) || !CapellaLayerCheckingExt.isElementFromUpperLayer((CapellaElement)((CapellaElement)targetElement), (CapellaElement)((CapellaElement)sourceElement))) continue;
                AbstractNamedElement sourceNamedElement = (AbstractNamedElement)sourceElement;
                AbstractNamedElement targetNamedElement = (AbstractNamedElement)targetElement;
                String sourceName = sourceNamedElement.getName() == null ? "" : sourceNamedElement.getName();
                String string = targetName = targetNamedElement.getName() == null ? "" : targetNamedElement.getName();
                if (sourceName.equals(targetName)) continue;
                return ctx.createFailureStatus(new Object[]{sourceName, cst.eClass().getName(), targetName, targetNamedElement.eClass().getName()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean isNotRootElement(EObject element) {
        if (element instanceof Component && ComponentExt.isComponentRoot((EObject)element)) {
            return false;
        }
        return !(element instanceof AbstractFunction) || !FunctionExt.isRootFunction((EObject)element);
    }
}

