/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.constraint;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateEvent;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class I_36_ConstraintNotReferenced
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObject = ctx.getTarget();
        if (eObject instanceof Constraint) {
            Constraint constraint = (Constraint)eObject;
            EObject container = eObject.eContainer();
            if (!constraint.getConstrainedElements().isEmpty()) {
                return ctx.createSuccessStatus();
            }
            ArrayList<EReference> references = new ArrayList<EReference>();
            references.add(CapellacommonPackage.Literals.STATE_TRANSITION__GUARD);
            references.add(CapellacommonPackage.Literals.STATE_EVENT__EXPRESSION);
            references.add(InteractionPackage.Literals.SEQUENCE_MESSAGE__EXCHANGE_CONTEXT);
            references.add(InteractionPackage.Literals.SCENARIO__PRE_CONDITION);
            references.add(InteractionPackage.Literals.SCENARIO__POST_CONDITION);
            references.add(InteractionPackage.Literals.ABSTRACT_CAPABILITY__PRE_CONDITION);
            references.add(InteractionPackage.Literals.ABSTRACT_CAPABILITY__POST_CONDITION);
            references.add(InteractionPackage.Literals.INTERACTION_OPERAND__GUARD);
            if (EObjectExt.getReferencers((EObject)constraint, references).isEmpty()) {
                if (container instanceof StateTransition) {
                    return this.failMessage(ctx, constraint, "Guard", container);
                }
                if (container instanceof StateEvent) {
                    return this.failMessage(ctx, constraint, "Expression", container);
                }
                if (container instanceof SequenceMessage) {
                    return this.failMessage(ctx, constraint, "Exchange Context", container);
                }
                if (container instanceof Scenario) {
                    return this.failMessage(ctx, constraint, "Pre/Post Condition", container);
                }
                if (container instanceof AbstractCapability) {
                    return this.failMessage(ctx, constraint, "Pre/Post Condition", container);
                }
                if (container instanceof InteractionOperand) {
                    return this.failMessage(ctx, constraint, "Guard", container);
                }
                return this.failMessage(ctx, constraint);
            }
        }
        return ctx.createSuccessStatus();
    }

    protected IStatus failMessage(IValidationContext ctx, Constraint constraint, String feature, EObject container) {
        String a = EObjectLabelProviderHelper.getText((Object)constraint);
        String b = EObjectLabelProviderHelper.getText((Object)container);
        String c = EObjectLabelProviderHelper.getMetaclassLabel((EObject)container, (boolean)false);
        String result = NLS.bind((String)", specifically on {0} of the owning {1} ({2})", (Object[])new String[]{feature, b, c});
        return ctx.createFailureStatus(new Object[]{a, result});
    }

    protected IStatus failMessage(IValidationContext ctx, Constraint constraint) {
        String a = EObjectLabelProviderHelper.getText((Object)constraint);
        return ctx.createFailureStatus(new Object[]{a, ""});
    }
}

