/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.internal;

import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class RunInWorkspaceJob
extends Job {
    public RunInWorkspaceJob(String name) {
        super(name);
    }

    public final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        Workspace workspace;
        block10: {
            monitor = Policy.monitorFor((IProgressMonitor)monitor);
            workspace = (Workspace)ResourcesPlugin.getWorkspace();
            if (!workspace.isOpen()) {
                return Status.OK_STATUS;
            }
            int depth = -1;
            try {
                workspace.prepareOperation(null, monitor);
                workspace.beginOperation(true);
                depth = workspace.getWorkManager().beginUnprotected();
                iStatus = this.runInWorkspace(monitor);
                if (depth < 0) break block10;
            }
            catch (OperationCanceledException e) {
                IStatus iStatus2;
                block11: {
                    try {
                        workspace.getWorkManager().operationCanceled();
                        iStatus2 = Status.CANCEL_STATUS;
                        if (depth < 0) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (depth >= 0) {
                                workspace.getWorkManager().endUnprotected(depth);
                            }
                            workspace.endOperation(null, false);
                            workspace = null;
                            throw throwable;
                        }
                        catch (CoreException e2) {
                            return e2.getStatus();
                        }
                    }
                    workspace.getWorkManager().endUnprotected(depth);
                }
                workspace.endOperation(null, false);
                workspace = null;
                return iStatus2;
            }
            workspace.getWorkManager().endUnprotected(depth);
        }
        workspace.endOperation(null, false);
        workspace = null;
        return iStatus;
    }

    protected abstract IStatus runInWorkspace(IProgressMonitor var1) throws CoreException;
}

