/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project.sample;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.wizard.AbstractExampleInstallerWizard;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.project.sample.ZipFilenameFilter;
import org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction;
import org.xml.sax.InputSource;

public class SampleModelWizard
extends AbstractExampleInstallerWizard {
    List<AbstractExampleInstallerWizard.ProjectDescriptor> descriptors = null;
    AbstractExampleInstallerWizard.ProjectDescriptor selected = null;
    boolean install = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProjectDescription createProjectDescription(URI contentURI) {
        try {
            String location = contentURI.toFileString();
            if (location == null) return null;
            File file = new File(location);
            if (!file.isFile()) return null;
            if (!file.canRead()) return null;
            ZipFile zipFile = this.createZipFile(file);
            if (zipFile == null) return null;
            try {
                ProjectDescription description;
                Object subfile;
                ZipFileStructureProvider structureProvider = new ZipFileStructureProvider(zipFile);
                Iterator iterator = structureProvider.getChildren((Object)structureProvider.getRoot()).iterator();
                block12: while (true) {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    Object folder = iterator.next();
                    Iterator iterator2 = structureProvider.getChildren(folder).iterator();
                    do {
                        if (!iterator2.hasNext()) continue block12;
                    } while (!((subfile = iterator2.next()) instanceof ZipEntry) || !((ZipEntry)subfile).getName().endsWith(".project"));
                    break;
                }
                BufferedInputStream in = new BufferedInputStream(structureProvider.getContents((Object)((ZipEntry)subfile)));
                ProjectDescription projectDescription = description = new ProjectDescriptionReader(ResourcesPlugin.getWorkspace()).read(new InputSource(in));
                return projectDescription;
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected Collection<URI> getSampleLocations() {
        ArrayList<URI> result = new ArrayList<URI>();
        Location location = Platform.getInstallLocation();
        URL url = location.getURL();
        URI uri = URI.createURI((String)url.toString());
        URI sampleLocation = uri.trimSegments(2).appendSegment("samples");
        result.add(sampleLocation);
        return result;
    }

    protected List<AbstractExampleInstallerWizard.ProjectDescriptor> getProjectDescriptors() {
        if (this.install) {
            return Collections.singletonList(this.selected);
        }
        if (this.descriptors == null) {
            this.descriptors = new ArrayList<AbstractExampleInstallerWizard.ProjectDescriptor>();
            try {
                for (URI location : this.getSampleLocations()) {
                    for (File zip : this.getOwnedZips(location)) {
                        try {
                            URI fileUri = URI.createFileURI((String)zip.getAbsolutePath());
                            this.descriptors.add(new ExampleProjectDescriptor(fileUri));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.descriptors;
    }

    protected Collection<File> getOwnedZips(URI sampleLocation) {
        ArrayList<File> zips = new ArrayList<File>();
        ZipFilenameFilter zipFilter = new ZipFilenameFilter();
        File folder = new File(sampleLocation.toFileString());
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    File[] fileArray2 = file.listFiles(zipFilter);
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File zip = fileArray2[n4];
                        zips.add(zip);
                        ++n4;
                    }
                } else if (zipFilter.accept(file.getParentFile(), file.getName())) {
                    zips.add(file);
                }
                ++n2;
            }
        }
        return zips;
    }

    public void addPages() {
        this.projectPage = new AbstractExampleInstallerWizard.ProjectPage(this, "projectPage", CommonUIPlugin.INSTANCE.getString("_UI_ProjectPage_title"), null){

            protected void itemSelected() {
                AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
                if (projectDescriptor != null) {
                    SampleModelWizard.this.selected = projectDescriptor;
                }
                super.itemSelected();
            }
        };
        this.projectPage.setDescription("Select a sample project to import");
        this.addPage((IWizardPage)this.projectPage);
    }

    public boolean performFinish() {
        try {
            this.install = true;
            boolean bl = super.performFinish();
            return bl;
        }
        finally {
            this.install = false;
        }
    }

    protected void openFiles(IProgressMonitor progressMonitor) {
        List<AbstractExampleInstallerWizard.FileToOpen> filesToOpen = this.getFilesToOpen();
        ArrayList<IFile> airds = new ArrayList<IFile>();
        if (!filesToOpen.isEmpty()) {
            for (AbstractExampleInstallerWizard.FileToOpen open : filesToOpen) {
                airds.add(open.getWorkspaceFile());
            }
            OpenSessionAction action = new OpenSessionAction();
            action.selectionChanged((IStructuredSelection)new StructuredSelection(airds));
            action.run();
        }
    }

    protected void installProjectFromFile(AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor, IProgressMonitor progressMonitor) throws Exception {
        block11: {
            URI contentURI = projectDescriptor.getContentURI();
            if (contentURI.isPlatform()) {
                contentURI = CommonPlugin.asLocalURI((URI)contentURI);
            }
            ImportOperation importOperation = null;
            ZipFile zipFile = null;
            try {
                List child;
                ZipFileStructureProvider structureProvider;
                ZipEntry root;
                File file;
                String location = contentURI.toFileString();
                if (location != null && (file = new File(location)).isFile() && file.canRead() && (zipFile = this.createZipFile(file)) != null && (root = (structureProvider = new ZipFileStructureProvider(zipFile)).getRoot()) != null && (child = structureProvider.getChildren((Object)root)) != null && child.size() > 0) {
                    Object mainProject = child.get(0);
                    importOperation = new ImportOperation(projectDescriptor.getProject().getFullPath(), mainProject, (IImportStructureProvider)structureProvider, OVERWRITE_ALL_QUERY);
                }
                if (importOperation != null) {
                    this.installProject(projectDescriptor, importOperation, progressMonitor);
                    break block11;
                }
                throw new Exception(CommonUIPlugin.INSTANCE.getString("_UI_FileError_message", (Object[])new String[]{contentURI.toString()}));
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected void installProject(AbstractExampleInstallerWizard.ProjectDescriptor projectDescriptor, ImportOperation importOperation, IProgressMonitor progressMonitor) throws Exception {
        importOperation.setCreateContainerStructure(false);
        super.installProject(projectDescriptor, importOperation, progressMonitor);
    }

    protected List<AbstractExampleInstallerWizard.FileToOpen> getFilesToOpen() {
        if (this.selected != null) {
            final ArrayList airds = new ArrayList();
            ArrayList<AbstractExampleInstallerWizard.FileToOpen> locations = new ArrayList<AbstractExampleInstallerWizard.FileToOpen>();
            try {
                this.selected.getProject().accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (CapellaResourceHelper.isAirdResource((IResource)resource, (boolean)true)) {
                            airds.add((IFile)resource);
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            for (final IFile file : airds) {
                locations.add(new AbstractExampleInstallerWizard.FileToOpen(){

                    public IFile getWorkspaceFile() {
                        return file;
                    }
                });
            }
            return locations;
        }
        return Collections.emptyList();
    }

    public class ExampleProjectDescriptor
    extends AbstractExampleInstallerWizard.ProjectDescriptor {
        public ExampleProjectDescriptor(URI uri) throws AssertionFailedException {
            this.setContentURI(uri);
            ProjectDescription project = SampleModelWizard.this.createProjectDescription(this.contentURI);
            Assert.isNotNull((Object)project);
            this.setName(project.getName());
            this.setDescription(project.getComment());
        }
    }
}

