/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.types.Type;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public final class InvocationSetInvokedActivityCommand
extends SetCommand {
    private boolean _process;
    private Map<InvocationContract, Contract[]> _contracts;
    private Invocation _invocation;
    private Activity _newActivity;

    public InvocationSetInvokedActivityCommand(EditingDomain domain, Invocation invocation, Activity newActivity) {
        super(domain, (EObject)invocation, (EStructuralFeature)FcorePackage.Literals.INVOCATION__INVOKED_ACTIVITY, (Object)newActivity);
        this._invocation = invocation;
        this._newActivity = newActivity;
        this._contracts = new HashMap<InvocationContract, Contract[]>();
    }

    protected boolean prepare() {
        if (this._invocation.getInvokedActivity() == null || this._newActivity == null || this._invocation.getInvokedActivity() == this._newActivity) {
            return super.prepare();
        }
        if (this._invocation.getInvocationContractContainer() != null) {
            block0: for (InvocationContract invocationContract : this._invocation.getInvocationContractContainer().getInvocationContracts()) {
                Contract[] contracts = new Contract[2];
                contracts[0] = invocationContract.getInvokedContract();
                this._contracts.put(invocationContract, contracts);
                for (Contract invokedContract : this._newActivity.getContracts()) {
                    if (invokedContract.getType() == null || invokedContract.getName() == null || !invokedContract.getName().equals(invocationContract.getInvokedContract().getName())) continue;
                    if (invocationContract.getType() != null) {
                        if (!invocationContract.getType().isCompatible(invokedContract.getType())) continue;
                        contracts[1] = invokedContract;
                        continue block0;
                    }
                    if (invocationContract.getFactoryComponentContract() != null && invocationContract.getFactoryComponentContract().getType() != null) {
                        if (!invokedContract.getType().isCompatible(invocationContract.getFactoryComponentContract().getType())) continue;
                        contracts[1] = invokedContract;
                        continue block0;
                    }
                    if (invocationContract.getOrchestrationParameter() != null && invocationContract.getOrchestrationParameter().getType() != null) {
                        if (invokedContract.getType().isCompatible(invocationContract.getOrchestrationParameter().getType())) continue;
                        contracts[1] = invokedContract;
                        continue block0;
                    }
                    if (invocationContract.getSourceInvocationContract() == null || invocationContract.getSourceInvocationContract().getInvokedContract() == null || invocationContract.getSourceInvocationContract().getInvokedContract().getType() == null) continue;
                    Type sourceType = invocationContract.getSourceInvocationContract().getType();
                    if (sourceType == null) {
                        sourceType = invocationContract.getSourceInvocationContract().getInvokedContract().getType();
                    }
                    if (invokedContract.getType().isCompatible(sourceType)) continue;
                    contracts[1] = invokedContract;
                    continue block0;
                }
            }
            this._process = true;
        }
        return super.prepare();
    }

    public Collection<?> doGetAffectedObjects() {
        UniqueEList affectedObjects = new UniqueEList();
        affectedObjects.add(this.owner);
        affectedObjects.addAll(this._contracts.keySet());
        return affectedObjects;
    }

    public void doExecute() {
        if (!this._process) {
            super.doExecute();
            return;
        }
        for (Map.Entry<InvocationContract, Contract[]> entry : this._contracts.entrySet()) {
            entry.getKey().setInvokedContract(entry.getValue()[1]);
        }
        super.doExecute();
    }

    public void doUndo() {
        if (!this._process) {
            super.doUndo();
            return;
        }
        for (Map.Entry<InvocationContract, Contract[]> entry : this._contracts.entrySet()) {
            entry.getKey().setInvokedContract(entry.getValue()[0]);
        }
        super.doUndo();
    }

    public void doRedo() {
        if (!this._process) {
            super.doRedo();
            return;
        }
        for (Map.Entry<InvocationContract, Contract[]> entry : this._contracts.entrySet()) {
            entry.getKey().setInvokedContract(entry.getValue()[1]);
        }
        super.doRedo();
    }
}

