/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.ui.helper;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.common.helper.StatusHelper;
import org.eclipse.ui.statushandlers.StatusManager;

public class ThrowableHandler {
    private ThrowableHandler() {
    }

    public static void handleThrowable(String pluginID, Throwable t) {
        IStatus status = null;
        if (t instanceof CoreException) {
            CoreException ce = (CoreException)t;
            status = ce.getStatus();
        } else if (t instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)t;
            status = StatusHelper.newStatus((String)pluginID, (int)4, (String)ite.getClass().getSimpleName(), (Throwable)ite.getTargetException());
        } else {
            Throwable throwable = t;
            if (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            status = StatusHelper.newStatus((String)pluginID, (int)4, (String)t.getClass().getSimpleName(), (Throwable)throwable);
        }
        StatusManager.getManager().handle(status, 3);
    }
}

