/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.behavior.AbstractEvent;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.EntryPointPseudoState;
import org.polarsys.capella.core.data.capellacommon.ExitPointPseudoState;
import org.polarsys.capella.core.data.capellacommon.FinalState;
import org.polarsys.capella.core.data.capellacommon.ForkPseudoState;
import org.polarsys.capella.core.data.capellacommon.InitialPseudoState;
import org.polarsys.capella.core.data.capellacommon.JoinPseudoState;
import org.polarsys.capella.core.data.capellacommon.Pseudostate;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.TerminatePseudoState;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.StateMachineServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideMSMStateMode;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideMSMTransitions;

public class ModeStateMachineServices {
    private static ModeStateMachineServices _service;

    public static ModeStateMachineServices getService() {
        if (_service == null) {
            _service = new ModeStateMachineServices();
        }
        return _service;
    }

    public String getRegionLabel(Region region, DDiagram diagram) {
        return this.isDiagramFilterEnable(diagram, "hide.region.names.filter") ? "" : " [" + EObjectExt.getText((EObject)region) + "]";
    }

    public String getActivityLabel(AbstractEvent abstractEvent) {
        if (abstractEvent instanceof FunctionalExchange) {
            return this.getOutgoingFunctionalExchangeLabel((FunctionalExchange)abstractEvent);
        }
        return EObjectExt.getText((EObject)abstractEvent);
    }

    public String getOutgoingFunctionalExchangeLabel(FunctionalExchange fe) {
        ActivityNode target = fe.getTarget();
        if (target instanceof FunctionPort) {
            target = target.eContainer();
        }
        if (target instanceof AbstractFunction) {
            return String.valueOf(EObjectExt.getText((EObject)fe)) + " [-> " + EObjectExt.getText((EObject)target) + "]";
        }
        return "";
    }

    public String getIncomingFunctionalExchangeLabel(FunctionalExchange fe) {
        ActivityNode source = fe.getSource();
        if (source instanceof FunctionPort) {
            source = source.eContainer();
        }
        if (source instanceof AbstractFunction) {
            return "[" + EObjectExt.getText((EObject)source) + " ->] " + EObjectExt.getText((EObject)fe);
        }
        return "";
    }

    public String getEntryExitPointLabel(Pseudostate pseudostate, DDiagram diagram) {
        EList regions;
        if (this.isDiagramFilterEnable(diagram, "DisplayRegionNameOnEntryExitPoints") && !(regions = pseudostate.getInvolverRegions()).isEmpty()) {
            Region region = (Region)regions.get(0);
            return String.valueOf(EObjectExt.getText((EObject)pseudostate)) + " (" + EObjectExt.getText((EObject)region) + ")";
        }
        return EObjectExt.getText((EObject)pseudostate);
    }

    private boolean isDiagramFilterEnable(DDiagram diagram, String filterName) {
        if (diagram != null) {
            EList activatedFilters = diagram.getActivatedFilters();
            for (FilterDescription filterDescription : activatedFilters) {
                if (filterDescription == null || !filterDescription.getName().equalsIgnoreCase(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public EObject showHideStatesInStateAndModeDiag(DSemanticDecorator view, List<State> selectedStates, List<State> visibleStates, List<AbstractDNode> visibleStateViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        ShowHideMSMStateMode shHide = new ShowHideMSMStateMode(content);
        AbstractShowHide.DiagramContext diagramContext = new ShowHideMSMStateMode(content).new AbstractShowHide.DiagramContext();
        diagramContext.setVariable("CONTEXTUAL_CONTAINER", view.getTarget());
        diagramContext.setVariable("CONTEXTUAL_CONTAINER_VIEW", view);
        for (IState iState : selectedStates) {
            shHide.show((EObject)iState, diagramContext);
        }
        for (AbstractDNode abstractDNode : visibleStateViews) {
            if (selectedStates.contains(abstractDNode.getTarget())) continue;
            toBeRemoved.add(abstractDNode.getTarget());
        }
        for (EObject eObject : toBeRemoved) {
            shHide.hide(eObject, diagramContext);
        }
        return view;
    }

    public EObject moveRegionMSM(EObject context, Region newRegion, Region selectedRegion) {
        EObject container = newRegion.eContainer();
        State state = (State)container;
        state.getOwnedRegions().remove((Object)newRegion);
        int index = 0;
        if (selectedRegion != null) {
            index = state.getOwnedRegions().indexOf((Object)selectedRegion) + 1;
        }
        state.getOwnedRegions().add(index, (Object)newRegion);
        return context;
    }

    public Region getRegionForTransitionMSM(EObject context, DDiagramElement sourceView) {
        EObject containerView = sourceView.eContainer();
        if (containerView instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)containerView).getTarget();
            if (target instanceof Region) {
                return (Region)target;
            }
            if (target instanceof State && context instanceof Pseudostate && context.eContainer() instanceof Region) {
                return (Region)context.eContainer();
            }
        }
        return null;
    }

    public boolean canCreateTransitionMSM(EObject context, EObject sourceElement, EObject targetElement) {
        IState source = null;
        IState target = null;
        if (sourceElement instanceof IState) {
            source = (IState)sourceElement;
        } else if (sourceElement instanceof Region) {
            source = (IState)sourceElement.eContainer();
        } else {
            return false;
        }
        if (targetElement instanceof IState) {
            target = (IState)targetElement;
        } else if (targetElement instanceof Region) {
            target = (IState)targetElement.eContainer();
        } else {
            return false;
        }
        if (target instanceof InitialPseudoState || source instanceof TerminatePseudoState || source instanceof FinalState) {
            return false;
        }
        if (source instanceof InitialPseudoState && (target instanceof TerminatePseudoState || target instanceof FinalState)) {
            return false;
        }
        if (target instanceof ExitPointPseudoState && !StateMachineServices.getService().isInSameOrSubRegion(target, source) || source instanceof EntryPointPseudoState && !StateMachineServices.getService().isInSameOrSubRegion(source, target) || source instanceof JoinPseudoState && StateMachineServices.getService().getSourcingTransition((EObject)source).size() != 0 || target instanceof ForkPseudoState && StateMachineServices.getService().getTargettingTransition((EObject)target).size() != 0) {
            return false;
        }
        if (source.equals(target) && !(source instanceof Pseudostate)) {
            return true;
        }
        if (EcoreUtil.isAncestor((EObject)source, (EObject)target) || EcoreUtil.isAncestor((EObject)target, (EObject)source)) {
            return false;
        }
        return !(EcoreUtil2.getCommonAncestor((EObject)source, (EObject)target) instanceof IState);
    }

    public Region getRegionForInsertionMSM(EObject context, EObject delement) {
        EObject target;
        Region region = null;
        if (delement instanceof DDiagram) {
            region = (Region)((DSemanticDiagram)delement).getTarget();
        } else if (delement instanceof DDiagramElementContainer && (target = ((DNodeContainer)delement).getTarget()) instanceof Region) {
            return (Region)target;
        }
        return region;
    }

    public EObject showHideStatesInMSMDiag(DSemanticDecorator view, List<State> selectedStates, List<State> visibleStates, List<AbstractDNode> visibleStateViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        ShowHideMSMStateMode shHide = new ShowHideMSMStateMode(content);
        AbstractShowHide.DiagramContext diagramContext = new ShowHideMSMStateMode(content).new AbstractShowHide.DiagramContext();
        diagramContext.setVariable("CONTEXTUAL_CONTAINER", view.getTarget());
        diagramContext.setVariable("CONTEXTUAL_CONTAINER_VIEW", view);
        for (IState iState : selectedStates) {
            shHide.show((EObject)iState, diagramContext);
        }
        for (AbstractDNode abstractDNode : visibleStateViews) {
            if (selectedStates.contains(abstractDNode.getTarget())) continue;
            toBeRemoved.add(abstractDNode.getTarget());
        }
        for (EObject eObject : toBeRemoved) {
            shHide.hide(eObject, diagramContext);
        }
        return view;
    }

    public EObject showHideMSMTransitions(DSemanticDecorator view, List<StateTransition> selectedTransitions, List<StateTransition> visibleTransitions, List<DEdge> visibleTransitionViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        ShowHideMSMTransitions shHide = new ShowHideMSMTransitions(content);
        AbstractShowHide.DiagramContext diagramContext = shHide.new AbstractShowHide.DiagramContext();
        diagramContext.setVariable("CONTEXTUAL_CONTAINER", view.getTarget());
        diagramContext.setVariable("CONTEXTUAL_CONTAINER_VIEW", view);
        for (StateTransition trans : selectedTransitions) {
            shHide.show((EObject)trans, diagramContext);
        }
        for (DEdge edge : visibleTransitionViews) {
            if (selectedTransitions.contains(edge.getTarget())) continue;
            toBeRemoved.add(edge.getTarget());
        }
        for (EObject aView : toBeRemoved) {
            shHide.hide(aView, diagramContext);
        }
        return view;
    }

    public ContainerMapping getMappingMSMStateMode(State state, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Mode State Machine")) {
            mappingName = "MSM_ModeState_Container";
        }
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    public NodeMapping getMappingMSMPseudostate(Pseudostate pseudoState, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Mode State Machine")) {
            mappingName = "MSM_ModeState";
        }
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    public EdgeMapping getMappingMSMTransition(StateTransition function, DDiagram diagram) {
        String mappingName = null;
        if (diagram.getDescription().getName().equalsIgnoreCase("Mode State Machine")) {
            mappingName = "MSM_Transition";
        }
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    public List<StateTransition> getComputedTransitions(Region region, DDiagram diagram) {
        ArrayList<StateTransition> transitions = new ArrayList<StateTransition>();
        region.eAllContents().forEachRemaining(el -> {
            if (el instanceof StateTransition) {
                StateTransition transition = (StateTransition)el;
                Collection<DSemanticDecorator> sourceDiagramElements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)transition.getSource());
                Collection<DSemanticDecorator> targetDiagramElements = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)transition.getTarget());
                Stream.concat(sourceDiagramElements.stream(), targetDiagramElements.stream()).forEach(diagElt -> {
                    if (diagElt instanceof DDiagramElement && !((DDiagramElement)diagElt).isVisible()) {
                        transitions.add(transition);
                    }
                });
            }
        });
        return transitions;
    }

    public EObject getComputedTransitionSource(EObject related, DDiagram diagram) {
        if (related instanceof StateTransition) {
            StateTransition transition = (StateTransition)related;
            AbstractState transitionSource = transition.getSource();
            DDiagramElement sourceDiagramElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)transitionSource);
            Optional<DDiagramElement> firstVisibleEdgeEnd = this.getFirstVisibleEdgeEnd(diagram, sourceDiagramElement);
            if (firstVisibleEdgeEnd.isPresent()) {
                return firstVisibleEdgeEnd.get().getTarget();
            }
        }
        return null;
    }

    public EObject getComputedTransitionTarget(EObject related, DDiagram diagram) {
        if (related instanceof StateTransition) {
            StateTransition transition = (StateTransition)related;
            AbstractState transitionTarget = transition.getTarget();
            DDiagramElement targetDiagramElement = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)transitionTarget);
            Optional<DDiagramElement> firstVisibleEdgeEnd = this.getFirstVisibleEdgeEnd(diagram, targetDiagramElement);
            if (firstVisibleEdgeEnd.isPresent()) {
                return firstVisibleEdgeEnd.get().getTarget();
            }
        }
        return null;
    }

    private Optional<DDiagramElement> getFirstVisibleEdgeEnd(DDiagram diagram, DDiagramElement diagramElement) {
        if (diagramElement != null && diagramElement.getTarget() instanceof AbstractState && diagramElement.isVisible()) {
            return Optional.of(diagramElement);
        }
        if (diagramElement != null && diagramElement.eContainer() instanceof DDiagramElement) {
            return this.getFirstVisibleEdgeEnd(diagram, (DDiagramElement)diagramElement.eContainer());
        }
        return Optional.empty();
    }
}

