/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CompositeFilterApplicationBuilder;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;
import org.polarsys.capella.core.diagram.helpers.TitleBlockHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.preferences.TitleBlockPreferencesInitializer;

public class TitleBlockServices {
    private static TitleBlockServices service = null;
    static Map<String, String> propertiesName = new HashMap<String, String>();
    static Map<String, String> propertiesContent = new HashMap<String, String>();
    private static final String SEPARATOR = "SEPARATOR";
    private static final String DEFAULT_CELL_NAME = "Name";
    private static final String DEFAULT_CELL_CONTENT = "feature:name";
    private static final String FILTERS_TITLE_BLOCKS_MESSAGE = "{0}s are hidden by filters. Do you want to deactivate the filters for {1}s?";
    private static final String FILTERS_DIALOG_TITLE = "Filters deactivation";
    private static final String FILTER_DIAGRAM_TITLE_BLOCK = "hide.diagram.title.blocks.filter";
    private static final String FILTER_ELEMENT_TITLE_BLOCK = "hide.element.title.blocks.filter";

    public static TitleBlockServices getService() {
        if (service == null) {
            service = new TitleBlockServices();
        }
        return service;
    }

    public boolean isContainerDiagram(EObject containerView) {
        return containerView instanceof DDiagram;
    }

    public boolean hasADiagramTitleBlock(DDiagram diagram) {
        return !TitleBlockHelper.getDiagramTitleBlocks((DDiagram)diagram).isEmpty();
    }

    public boolean hasAElementTitleBlock(DDiagramElement elementView) {
        List<DAnnotation> list = this.getElementTitleBlocks(elementView.getParentDiagram());
        for (DAnnotation annotation : list) {
            if (!annotation.getReferences().contains((Object)elementView.getTarget())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidCreateDiagramTitleBlock(EObject containerView) {
        return this.isContainerDiagram(containerView);
    }

    public boolean isValidCreateElementTitleBlock(EObject containerView) {
        return containerView instanceof DDiagramElement && !TitleBlockHelper.isTitleBlockAnnotation((EObject)((DDiagramElement)containerView).getTarget());
    }

    public boolean isValidCreateTitleBlock(EObject containerView) {
        return this.isValidCreateDiagramTitleBlock(containerView) || this.isValidCreateElementTitleBlock(containerView);
    }

    public boolean isValidInsertLineOrColumn(EObject containerView) {
        if (containerView instanceof DDiagramElement) {
            DDiagramElement diagramElement = (DDiagramElement)containerView;
            return TitleBlockHelper.isTitleBlockCell((DDiagramElement)diagramElement);
        }
        return false;
    }

    public boolean isValidRemoveLineOfElementTitleBlock(EObject containerView) {
        if (this.isValidInsertLineOrColumn(containerView)) {
            DAnnotation annotation = (DAnnotation)((DDiagramElement)containerView).getTarget();
            DAnnotation titleBlockContainer = TitleBlockHelper.getParentTitleBlock((DAnnotation)annotation);
            return TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlockContainer).size() > 1;
        }
        return false;
    }

    public boolean isValidRemoveColumnOfElementTitleBlock(EObject containerView) {
        if (this.isValidInsertLineOrColumn(containerView)) {
            DAnnotation annotation = (DAnnotation)((DDiagramElement)containerView).getTarget();
            DAnnotation titleBlockContainer = TitleBlockHelper.getParentTitleBlock((DAnnotation)annotation);
            return TitleBlockHelper.getNumOfColumns((DAnnotation)titleBlockContainer) > 1;
        }
        return false;
    }

    public void createDiagramTitleBlock(DDiagram diagram) {
        this.createDiagramTitleBlock(diagram, true);
    }

    public void createDiagramTitleBlock(DDiagram diagram, boolean checkFilters) {
        DAnnotation titleBlock = TitleBlockHelper.addDiagramTitleBlock((DDiagram)diagram);
        this.addDiagramTitleBlockContent(diagram, titleBlock);
        this.createTitleBlockView(titleBlock, diagram, (EObject)diagram);
        if (checkFilters) {
            this.checkTitleBlocksFilters(diagram, "DiagramTitleBlock");
        }
    }

    public boolean deactivateDiagramTitleBlockFilter(DDiagram diagram) {
        if (this.hasADiagramTitleBlock(diagram) && !this.getVisibleDiagramTitleBlocks(diagram).isEmpty() && this.isFilterDiagramTitleBlocksEnabled(diagram)) {
            return this.checkTitleBlocksFilters(diagram, "DiagramTitleBlock");
        }
        return false;
    }

    protected void addDiagramTitleBlockContent(DDiagram diagram, DAnnotation titleBlock) {
        int numLines = TitleBlockPreferencesInitializer.getLinesNumber();
        int numCols = TitleBlockPreferencesInitializer.getColumnsNumber();
        String[] titleBlockContent = TitleBlockPreferencesInitializer.getContentAsArray();
        int currIndexTB = 0;
        int i = 0;
        while (i < numLines) {
            DAnnotation line = TitleBlockHelper.addTitleBlockLine((DDiagram)diagram, (DAnnotation)titleBlock);
            int j = 0;
            while (j < numCols) {
                TitleBlockHelper.addTitleBlockCell((DDiagram)diagram, (DAnnotation)line, (String)titleBlockContent[currIndexTB], (String)titleBlockContent[currIndexTB + 1]);
                currIndexTB += 2;
                ++j;
            }
            ++i;
        }
    }

    public void createElementTitleBlock(DDiagramElement elementView, DDiagram diagram) {
        DAnnotation titleBlock = TitleBlockHelper.addElementTitleBlock((DDiagram)diagram, (DDiagramElement)elementView);
        DAnnotation line = TitleBlockHelper.addTitleBlockLine((DDiagram)diagram, (DAnnotation)titleBlock);
        TitleBlockHelper.addTitleBlockCell((DDiagram)diagram, (DAnnotation)line, (String)DEFAULT_CELL_NAME, (String)DEFAULT_CELL_CONTENT);
        this.createTitleBlockView(titleBlock, diagram, (EObject)elementView);
        this.checkTitleBlocksFilters(diagram, "ElementTitleBlock");
    }

    public boolean deactivateElementTitleBlockFilter(DDiagramElement elementView) {
        if (this.hasAElementTitleBlock(elementView) && !this.getVisibleElementTitleBlocks(elementView).isEmpty() && this.isFilterElementTitleBlocksEnabled(elementView)) {
            return this.checkTitleBlocksFilters((DDiagram)elementView.eContainer(), "ElementTitleBlock");
        }
        return false;
    }

    public void insertTitleBlockLine(DAnnotation cell, DDiagram diagram) {
        DAnnotation titleBlock = TitleBlockHelper.getParentTitleBlock((DAnnotation)cell);
        int numCols = TitleBlockHelper.getNumOfColumns((DAnnotation)titleBlock);
        if (numCols > 0) {
            int indexLine = TitleBlockHelper.getLineIndexOfCell((DAnnotation)cell, (DAnnotation)titleBlock);
            DAnnotation annotationLine = TitleBlockHelper.addTitleBlockLine((DDiagram)diagram, (DAnnotation)titleBlock, (int)(indexLine + 1), (int)numCols);
            this.createTitleBlockLineView(DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)titleBlock), annotationLine, diagram, (EObject)diagram, indexLine + 1);
        }
    }

    public void insertTitleBlockColumn(DAnnotation cell, DDiagram diagram) {
        DAnnotation titleBlock = TitleBlockHelper.getParentTitleBlock((DAnnotation)cell);
        int indexCol = TitleBlockHelper.getColumnIndexOfCell((DAnnotation)cell, (DAnnotation)titleBlock);
        for (DAnnotation line : TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlock)) {
            DAnnotation annotationColumn = TitleBlockHelper.addTitleBlockCell((DDiagram)diagram, (DAnnotation)line, (String)"", (String)"", (int)(indexCol + 1));
            this.createTitleBlockColumnView(DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)line), annotationColumn, diagram, (EObject)diagram, indexCol + 1);
        }
    }

    public void clearCellContent(EObject object) {
        DAnnotation cellAnnotation;
        if (object instanceof DAnnotation && TitleBlockHelper.isTitleBlockCell((DAnnotation)(cellAnnotation = (DAnnotation)object))) {
            TitleBlockHelper.setTitleBlockCellContent((DAnnotation)cellAnnotation, (String)"", (String)"");
        }
    }

    public List<EObject> targetFinderExpressionForTitleBlocks(EObject element) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        if (element instanceof DAnnotation) {
            list.add(TitleBlockHelper.getReferencedElement((EObject)element));
        }
        return list;
    }

    public List<DAnnotation> getTitleBlocksInDiagram(DDiagram diagram) {
        ArrayList<DAnnotation> allList = new ArrayList<DAnnotation>();
        allList.addAll(this.getElementTitleBlocks(diagram));
        allList.addAll(this.getDiagramTitleBlocks(diagram));
        return allList;
    }

    public void refreshTitleBlocksInDiagram(DDiagram diagram) {
        if (diagram.getOwnedDiagramElements().isEmpty() && TitleBlockPreferencesInitializer.isCreateDiagramTitleBlockByDefault()) {
            this.createDiagramTitleBlock(diagram, false);
        }
        this.handleDanglingElementTitleBlocks(diagram);
    }

    public List<DAnnotation> getVisibleDiagramTitleBlocks(Object containerView) {
        return this.getVisibleTitleBlocks(containerView, "DiagramTitleBlock");
    }

    public List<DAnnotation> getVisibleElementTitleBlocks(Object containerView) {
        return this.getVisibleTitleBlocks(containerView, "ElementTitleBlock");
    }

    public Set<DAnnotation> getVisibleTitleBlocks(Object containerView) {
        return Stream.concat(this.getVisibleDiagramTitleBlocks(containerView).stream(), this.getVisibleElementTitleBlocks(containerView).stream()).collect(Collectors.toSet());
    }

    public boolean isFilterDiagramTitleBlocksEnabled(DDiagram diagram) {
        return !this.getActivatedFilters(diagram, FILTER_DIAGRAM_TITLE_BLOCK).isEmpty();
    }

    public boolean isFilterElementTitleBlocksEnabled(DDiagramElement element) {
        if (element.eContainer() instanceof DDiagram) {
            DDiagram diagram = (DDiagram)element.eContainer();
            return !this.getActivatedFilters(diagram, FILTER_ELEMENT_TITLE_BLOCK).isEmpty();
        }
        return false;
    }

    public List<FilterDescription> getActivatedFilters(DDiagram diagram, String filerType) {
        return diagram.getActivatedFilters().stream().filter(x -> x.getName().equals(filerType)).collect(Collectors.toList());
    }

    private List<DAnnotation> getVisibleTitleBlocks(Object containerView, String type) {
        if (containerView instanceof EdgeTarget) {
            return this.getAssociatedElementTitleBlocks((EdgeTarget)containerView);
        }
        if (containerView instanceof DDiagram) {
            return this.getAllAssociatedTitleBlocks((DDiagram)containerView, type);
        }
        return new ArrayList<DAnnotation>();
    }

    private List<DAnnotation> getAssociatedElementTitleBlocks(EdgeTarget edgeTarget) {
        ArrayList<DAnnotation> elementTBs = new ArrayList<DAnnotation>();
        for (DEdge edge : edgeTarget.getIncomingEdges()) {
            if (!(edge.getSourceNode() instanceof DNodeContainer) || !(((DNodeContainer)edge.getSourceNode()).getTarget() instanceof DAnnotation)) continue;
            elementTBs.add((DAnnotation)((DNodeContainer)edge.getSourceNode()).getTarget());
        }
        return elementTBs;
    }

    private List<DAnnotation> getAllAssociatedTitleBlocks(DDiagram diagram, String type) {
        ArrayList<DAnnotation> list = new ArrayList();
        list = diagram.getDiagramElements().stream().filter(x -> x instanceof DNodeContainer && x.getTarget() instanceof DAnnotation && type != null && type.equals(((DAnnotation)x.getTarget()).getSource())).map(x -> (DAnnotation)x.getTarget()).collect(Collectors.toList());
        return list;
    }

    public List<DAnnotation> getElementTitleBlocks(DDiagram diagram) {
        return TitleBlockHelper.getElementTitleBlocks((DDiagram)diagram);
    }

    public List<DAnnotation> getAvailableToInsertTitleBlocks(DDiagram diagram) {
        List<DAnnotation> allTitleBlocks = this.getTitleBlocksInDiagram(diagram);
        List ignoredTBs = allTitleBlocks.stream().filter(tb -> !tb.getReferences().isEmpty()).filter(TitleBlockHelper::isElementTitleBlock).filter(tb -> DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)tb.getReferences().get(0)) == null).collect(Collectors.toList());
        allTitleBlocks.removeAll(ignoredTBs);
        return allTitleBlocks;
    }

    public List<DAnnotation> getAvailableToInsertTitleBlocks(EObject elementView, DDiagram diagram) {
        if (elementView instanceof EdgeTarget) {
            return this.getAvailableToInsertTitleBlocks(diagram).stream().filter(x -> x.getReferences().contains((Object)((DDiagramElement)elementView).getTarget())).collect(Collectors.toList());
        }
        return this.getAvailableToInsertTitleBlocks(diagram);
    }

    public List<DAnnotation> getDiagramTitleBlocks(DDiagram diagram) {
        return TitleBlockHelper.getDiagramTitleBlocks((DDiagram)diagram);
    }

    private void handleDanglingElementTitleBlocks(DDiagram diagram) {
        Set<DAnnotation> titleBlocks = this.getVisibleTitleBlocks(diagram);
        ArrayList<DAnnotation> titleBlocksToDelete = new ArrayList<DAnnotation>();
        ArrayList<DAnnotation> titleBlocksToHide = new ArrayList<DAnnotation>();
        for (DAnnotation titleBlock : titleBlocks) {
            if (!TitleBlockHelper.isElementTitleBlock((DAnnotation)titleBlock)) continue;
            EObject semanticReference = TitleBlockHelper.getSemanticElementReference((DAnnotation)titleBlock);
            if (semanticReference != null) {
                DDiagramElement semanticElementView = DiagramServices.getDiagramServices().getDiagramElement(diagram, semanticReference);
                if (semanticElementView != null) continue;
                titleBlocksToHide.add(titleBlock);
                continue;
            }
            titleBlocksToDelete.add(titleBlock);
        }
        if (!titleBlocksToDelete.isEmpty()) {
            for (DAnnotation titleBlock : titleBlocksToDelete) {
                DDiagramElement titleBlockView = DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)titleBlock);
                if (titleBlockView != null) {
                    DiagramServices.getDiagramServices().removeContainerView((EObject)titleBlockView);
                }
                this.deleteTitleBlock(diagram, titleBlock);
            }
            titleBlocks.removeAll(titleBlocksToDelete);
        }
        if (!titleBlocksToHide.isEmpty()) {
            titleBlocks.removeAll(titleBlocksToHide);
            this.showHideTitleBlocks((EObject)diagram, titleBlocks);
        }
    }

    public void deleteTitleBlock(DDiagram diagram, DAnnotation titleBlock) {
        this.removeTitleBlockContent(diagram, titleBlock);
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        descriptor.getEAnnotations().remove((Object)titleBlock);
    }

    protected void removeTitleBlockContent(DDiagram diagram, DAnnotation titleBlock) {
        ArrayList<DAnnotation> annotationsList = new ArrayList<DAnnotation>();
        for (DAnnotation line : TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlock)) {
            annotationsList.add(line);
            for (DAnnotation cell : TitleBlockHelper.getTitleBlockCells((DAnnotation)line)) {
                annotationsList.add(cell);
                for (EObject reference : cell.getReferences()) {
                    if (!(reference instanceof DAnnotation)) continue;
                    annotationsList.add((DAnnotation)reference);
                }
                cell.getReferences().clear();
            }
            line.getReferences().clear();
        }
        titleBlock.getReferences().clear();
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        descriptor.getEAnnotations().removeAll(annotationsList);
    }

    public void removeLineOfTitleBlock(DAnnotation cell, DDiagram diagram) {
        if (TitleBlockHelper.isTitleBlockCell((DAnnotation)cell)) {
            DAnnotation titleBlockContainer = TitleBlockHelper.getParentTitleBlock((DAnnotation)cell);
            int indexLine = TitleBlockHelper.getLineIndexOfCell((DAnnotation)cell, (DAnnotation)titleBlockContainer);
            DAnnotation titleBlockLine = (DAnnotation)TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlockContainer).get(indexLine);
            ArrayList<DAnnotation> toRemove = new ArrayList<DAnnotation>();
            toRemove.add(titleBlockLine);
            toRemove.addAll(TitleBlockHelper.getTitleBlockCells((DAnnotation)titleBlockLine));
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
            descriptor.getEAnnotations().removeAll(toRemove);
        }
    }

    public void removeColumnOfTitleBlock(DAnnotation cell, DDiagram diagram) {
        if (TitleBlockHelper.isTitleBlockCell((DAnnotation)cell)) {
            DAnnotation titleBlockContainer = TitleBlockHelper.getParentTitleBlock((DAnnotation)cell);
            int indexCol = TitleBlockHelper.getColumnIndexOfCell((DAnnotation)cell, (DAnnotation)titleBlockContainer);
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
            for (DAnnotation line : TitleBlockHelper.getTitleBlockLines((DAnnotation)titleBlockContainer)) {
                EObject removedCell = (EObject)line.getReferences().remove(indexCol);
                descriptor.getEAnnotations().remove((Object)removedCell);
            }
        }
    }

    public Object getCellContent(DDiagram diagram, DAnnotation cell, DAnnotation titleBlockContainer) {
        Object evaluationResult;
        String evaluationExpression;
        if (TitleBlockHelper.isTitleBlockCell((DAnnotation)cell) && (evaluationExpression = (String)cell.getDetails().get((Object)"Content:")) != null && (evaluationResult = TitleBlockHelper.getResultOfExpression((DRepresentationDescriptor)RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram), (String)evaluationExpression, (DAnnotation)titleBlockContainer)) != null && !(evaluationResult instanceof EvaluationException)) {
            if (evaluationResult instanceof Collection) {
                Collection evaluationResultCollection = (Collection)evaluationResult;
                return this.getCellContentFromCollection(diagram, cell, evaluationResultCollection);
            }
            return this.getCellContentFromObject(diagram, cell, evaluationResult);
        }
        return null;
    }

    private EObject getCellContentFromObject(DDiagram diagram, DAnnotation cell, Object evaluationResult) {
        return evaluationResult instanceof EObject ? (EObject)evaluationResult : this.createOrUpdatePrimitiveAnnotation(Arrays.asList(evaluationResult), cell, diagram);
    }

    private List<EObject> getCellContentFromCollection(DDiagram diagram, DAnnotation cell, Collection<?> evaluationResult) {
        ArrayList<EObject> wrappedEvaluationResult = new ArrayList<EObject>();
        ArrayList<Object> primitiveEvaluationResult = new ArrayList<Object>();
        for (Object object : evaluationResult) {
            if (object instanceof EObject) {
                wrappedEvaluationResult.add((EObject)object);
                continue;
            }
            primitiveEvaluationResult.add(object);
        }
        DAnnotation primitiveResultAnnotation = this.createOrUpdatePrimitiveAnnotation(primitiveEvaluationResult, cell, diagram);
        wrappedEvaluationResult.add((EObject)primitiveResultAnnotation);
        return wrappedEvaluationResult;
    }

    public Object getTitleBlockCellContent(EObject diagram, EObject cell) {
        DAnnotation titleBlockContainer;
        DAnnotation titleBlockCell;
        if (diagram instanceof DDiagram && cell instanceof DAnnotation && TitleBlockHelper.isTitleBlockCell((DAnnotation)(titleBlockCell = (DAnnotation)cell)) && (titleBlockContainer = TitleBlockHelper.getParentTitleBlock((DAnnotation)titleBlockCell)) != null) {
            return this.getCellContent((DDiagram)diagram, titleBlockCell, titleBlockContainer);
        }
        return null;
    }

    private DAnnotation createOrUpdatePrimitiveAnnotation(List<Object> primitiveEvaluationResult, DAnnotation cell, DDiagram diagram) {
        DAnnotation wrapperAnnotation = null;
        String serializedResult = primitiveEvaluationResult.stream().map(o -> this.htmlToPlainText(o.toString())).collect(Collectors.joining("\n"));
        if (cell.getReferences().isEmpty()) {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
            wrapperAnnotation = DAnnotationHelper.createAnnotation((String)"TitleBlockContent", (DModelElement)descriptor);
            wrapperAnnotation.getDetails().put((Object)"Content:", (Object)serializedResult);
            cell.getReferences().add((Object)wrapperAnnotation);
        } else {
            wrapperAnnotation = (DAnnotation)cell.getReferences().get(0);
            String existingResult = (String)wrapperAnnotation.getDetails().get((Object)"Content:");
            if (!serializedResult.equals(existingResult)) {
                wrapperAnnotation.getDetails().put((Object)"Content:", (Object)serializedResult);
            }
        }
        return wrapperAnnotation;
    }

    private String htmlToPlainText(String content) {
        return StringEscapeUtils.unescapeHtml((String)content).replaceAll("\\<[^>]*>", "").trim();
    }

    public boolean isAnnotation(EObject object) {
        return object instanceof DAnnotation;
    }

    public String getTitleBockCellLabel(DAnnotation cell) {
        return (String)cell.getDetails().get((Object)"Content:");
    }

    public EObject showHideTitleBlocks(EObject targetView, Collection<DAnnotation> titleBlockUserSelection) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(targetView);
        Map<DAnnotation, Collection<DSemanticDecorator>> existingTitleBlocksToViews = Collections.emptyMap();
        existingTitleBlocksToViews = targetView instanceof EdgeTarget ? this.getTitleBLocksToViewsMap((EdgeTarget)targetView, diagram) : this.getTitleBLocksToViewsMap(diagram);
        this.hideTitleBlocks(titleBlockUserSelection, existingTitleBlocksToViews);
        this.showTitleBlocks(targetView, diagram, titleBlockUserSelection, existingTitleBlocksToViews);
        return targetView;
    }

    private Map<DAnnotation, Collection<DSemanticDecorator>> getTitleBLocksToViewsMap(EdgeTarget targetView, DDiagram diagram) {
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        HashMap<DAnnotation, Collection<DSemanticDecorator>> existingTitleBlocksToViews = new HashMap<DAnnotation, Collection<DSemanticDecorator>>();
        List<DAnnotation> associatedTitleBlocks = this.getAssociatedElementTitleBlocks(targetView);
        for (DAnnotation titleBLock : associatedTitleBlocks) {
            Collection<DSemanticDecorator> titleBlockViews = diagramServices.getDiagramElements((DRepresentation)diagram, (EObject)titleBLock);
            existingTitleBlocksToViews.put(titleBLock, titleBlockViews);
        }
        return existingTitleBlocksToViews;
    }

    private Map<DAnnotation, Collection<DSemanticDecorator>> getTitleBLocksToViewsMap(DDiagram diagram) {
        HashMap<DAnnotation, Collection<DSemanticDecorator>> existingTitleBlocksToViews = new HashMap<DAnnotation, Collection<DSemanticDecorator>>();
        for (DDiagramElement diagramElement : diagram.getDiagramElements()) {
            DAnnotation annotation;
            EObject target = diagramElement.getTarget();
            if (!(target instanceof DAnnotation) || !TitleBlockHelper.isTitleBlock((DAnnotation)(annotation = (DAnnotation)target)) || annotation.getSource() == null) continue;
            existingTitleBlocksToViews.computeIfAbsent(annotation, key -> new HashSet()).add(diagramElement);
        }
        return existingTitleBlocksToViews;
    }

    private void hideTitleBlocks(Collection<DAnnotation> titleBlockUserSelection, Map<DAnnotation, Collection<DSemanticDecorator>> existingTitleBlocksToViews) {
        DiagramServices diagramServices = DiagramServices.getDiagramServices();
        for (Map.Entry<DAnnotation, Collection<DSemanticDecorator>> existingEntry : existingTitleBlocksToViews.entrySet()) {
            DAnnotation existingTitleBlock = existingEntry.getKey();
            if (titleBlockUserSelection.contains(existingTitleBlock)) continue;
            Collection<DSemanticDecorator> titleBlockViews = existingEntry.getValue();
            for (DSemanticDecorator view : titleBlockViews) {
                if (view instanceof DEdge) {
                    diagramServices.removeEdgeView((DEdge)view);
                    continue;
                }
                diagramServices.removeContainerView((EObject)view);
            }
        }
    }

    private void showTitleBlocks(EObject targetView, DDiagram diagram, Collection<DAnnotation> titleBlockUserSelection, Map<DAnnotation, Collection<DSemanticDecorator>> existingTitleBlocksToViews) {
        for (DAnnotation selectedTitleBLock : titleBlockUserSelection) {
            if (existingTitleBlocksToViews.containsKey(selectedTitleBLock)) continue;
            String titleBlockType = TitleBlockHelper.isDiagramTitleBlock((DAnnotation)selectedTitleBLock) ? "DiagramTitleBlock" : "ElementTitleBlock";
            this.createTitleBlockView(selectedTitleBLock, diagram, targetView);
            this.checkTitleBlocksFilters(diagram, titleBlockType);
        }
    }

    private DNodeContainer createTitleBlockContainerNode(DAnnotation annotation, DDiagram diagram, EObject context, String mappingName, int index) {
        ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
        return DiagramServices.getDiagramServices().createContainer(mapping, (EObject)annotation, (DragAndDropTarget)context, diagram, index);
    }

    protected void createTitleBlockView(DAnnotation titleBlock, DDiagram diagram, EObject context) {
        try {
            DNodeContainer nodeTitleBlock = this.createTitleBlockContainerNode(titleBlock, diagram, (EObject)diagram, "DT_TitleBlockContainer", -1);
            for (EObject objLine : titleBlock.getReferences()) {
                int i = 0;
                if (!(objLine instanceof DAnnotation)) continue;
                this.createTitleBlockLineView((DDiagramElement)nodeTitleBlock, (DAnnotation)objLine, diagram, context, i);
                ++i;
            }
            if (TitleBlockHelper.isElementTitleBlock((DAnnotation)titleBlock) && context instanceof EdgeTarget) {
                EdgeMapping edgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "DT_TitleBlockEdge");
                DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)nodeTitleBlock, (EdgeTarget)context, (EObject)titleBlock);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void createTitleBlockLineView(DDiagramElement nodeTitleBlock, DAnnotation annotationLine, DDiagram diagram, EObject context, int index) {
        try {
            DNodeContainer nodeLine = this.createTitleBlockContainerNode(annotationLine, diagram, (EObject)nodeTitleBlock, "DT_TitleBlockLineContainer", index);
            int i = 0;
            for (EObject annotationCol : annotationLine.getReferences()) {
                this.createTitleBlockColumnView((DDiagramElement)nodeLine, (DAnnotation)annotationCol, diagram, context, i);
                ++i;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected void createTitleBlockColumnView(DDiagramElement nodeLine, DAnnotation annotationCol, DDiagram diagram, EObject context, int index) {
        try {
            ContainerMapping mappingCol = DiagramServices.getDiagramServices().getContainerMapping(diagram, "DT_TitleBlockColumnContainer");
            DiagramServices.getDiagramServices().createDNodeListElement((AbstractNodeMapping)mappingCol, (EObject)annotationCol, (DragAndDropTarget)nodeLine, diagram, index);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public String getTitleBlockCellLabel(EObject cell) {
        String name = "";
        if (cell instanceof DAnnotation) {
            name = (String)((DAnnotation)cell).getDetails().get((Object)"Name:");
        }
        return name;
    }

    public boolean isTitleBlockContainer(EObject element) {
        if (element instanceof DAnnotation) {
            DAnnotation annotation = (DAnnotation)element;
            return TitleBlockHelper.isDiagramTitleBlock((DAnnotation)annotation) || TitleBlockHelper.isElementTitleBlock((DAnnotation)annotation);
        }
        return false;
    }

    public boolean isDiagramTitleBlock(EObject element) {
        return element instanceof DAnnotation && TitleBlockHelper.isDiagramTitleBlock((DAnnotation)((DAnnotation)element));
    }

    protected boolean checkTitleBlocksFilters(final DDiagram diagram, String type) {
        final List<FilterDescription> activatedFiltersOnNode = this.getActivatedFilters(diagram, this.getFilterLable(type));
        if (!activatedFiltersOnNode.isEmpty()) {
            String typeLabel = TitleBlockHelper.getTitleBlockName((String)type);
            boolean confirmation = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)FILTERS_DIALOG_TITLE, (String)NLS.bind((String)FILTERS_TITLE_BLOCKS_MESSAGE, (Object)typeLabel, (Object)typeLabel));
            if (confirmation) {
                AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

                    public void run() {
                        EList activatedFilters = diagram.getActivatedFilters();
                        activatedFilters.removeAll((Collection)activatedFiltersOnNode);
                        CompositeFilterApplicationBuilder builder = new CompositeFilterApplicationBuilder(diagram);
                        builder.computeCompositeFilterApplications();
                    }
                };
                TransactionHelper.getExecutionManager((EObject)diagram).execute((ICommand)cmd);
                return true;
            }
        }
        return false;
    }

    private String getFilterLable(String type) {
        if (type.equals("DiagramTitleBlock")) {
            return FILTER_DIAGRAM_TITLE_BLOCK;
        }
        if (type.equals("ElementTitleBlock")) {
            return FILTER_ELEMENT_TITLE_BLOCK;
        }
        return "";
    }
}

