/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.helpers;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DModelElement;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.polarsys.capella.core.diagram.helpers.DAnnotationHelper;

public class FilterHelper {
    public static boolean isDesactivatedOnce(String filterId, DRepresentationDescriptor descriptor) {
        DAnnotation annotation;
        if (descriptor != null && (annotation = DAnnotationHelper.getAnnotation((String)"https://www.polarsys.org/capella/dannotation/DesactivatedFilters", (DModelElement)descriptor, (boolean)false)) != null) {
            return annotation.getDetails().containsKey((Object)filterId);
        }
        return false;
    }

    public static void monitorDesactivation(List<String> filters, DRepresentationDescriptor descriptor) {
        DDiagram diagram;
        if (descriptor != null && (diagram = (DDiagram)descriptor.getRepresentation()) != null) {
            Collection definedFilters = diagram.getDescription().getFilters().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
            Collection activatedFilters = diagram.getActivatedFilters().stream().map(IdentifiedElement::getName).collect(Collectors.toSet());
            Collection monitoredDesactivatedFilters = filters.stream().filter(f -> definedFilters.contains(f) && !activatedFilters.contains(f)).collect(Collectors.toList());
            if (!monitoredDesactivatedFilters.isEmpty()) {
                DAnnotation annotation = DAnnotationHelper.getAnnotation((String)"https://www.polarsys.org/capella/dannotation/DesactivatedFilters", (DModelElement)descriptor, (boolean)true);
                for (String filterId : monitoredDesactivatedFilters) {
                    if (annotation.getDetails().containsKey((Object)filterId)) continue;
                    annotation.getDetails().put((Object)filterId, (Object)Boolean.TRUE.toString());
                }
            }
        }
    }
}

