/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.queries.QueryExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class GetABShowHideActor
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        Component component = (Component)input;
        ArrayList<BlockArchitecture> architectures = new ArrayList<BlockArchitecture>();
        BlockArchitecture currentArchBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
        List<BlockArchitecture> archBlocksFromLibraries = this.getCorrespondingBlockArchitectureFromLibraries(currentArchBlock);
        architectures.addAll(archBlocksFromLibraries);
        ArrayList<Object> actors = new ArrayList<Object>();
        for (BlockArchitecture architecture : architectures) {
            actors.addAll(ComponentPkgExt.getAllActors((ComponentPkg)BlockArchitectureExt.getContext((BlockArchitecture)architecture)));
        }
        return actors;
    }

    private List<BlockArchitecture> getCorrespondingBlockArchitectureFromLibraries(BlockArchitecture currentArchBlock) {
        ArrayList<BlockArchitecture> res = new ArrayList<BlockArchitecture>();
        IModel currentProject = ILibraryManager.INSTANCE.getModel((EObject)CapellaQueries.getInstance().getRootQueries().getProject((ExtensibleElement)currentArchBlock));
        Collection libraries = LibraryManagerExt.getActivesReferences((IModel)currentProject);
        for (IModel library : libraries) {
            Project libraryProject = ((CapellaModel)library).getProject(TransactionHelper.getEditingDomain((EObject)currentArchBlock));
            if (libraryProject == null) continue;
            SystemEngineering systemEngineering = QueryExt.getSystemEngineeringFrom((Project)libraryProject);
            if (currentArchBlock instanceof OperationalAnalysis) {
                for (BlockArchitecture blockArchitecture : systemEngineering.getContainedOperationalAnalysis()) {
                    res.add(blockArchitecture);
                }
                continue;
            }
            if (currentArchBlock instanceof SystemAnalysis) {
                for (BlockArchitecture blockArchitecture : systemEngineering.getContainedSystemAnalysis()) {
                    res.add(blockArchitecture);
                }
                continue;
            }
            if (currentArchBlock instanceof LogicalArchitecture) {
                for (BlockArchitecture blockArchitecture : systemEngineering.getContainedLogicalArchitectures()) {
                    res.add(blockArchitecture);
                }
                continue;
            }
            if (currentArchBlock instanceof PhysicalArchitecture) {
                for (BlockArchitecture blockArchitecture : systemEngineering.getContainedPhysicalArchitectures()) {
                    res.add(blockArchitecture);
                }
                continue;
            }
            if (!(currentArchBlock instanceof EPBSArchitecture)) continue;
            for (BlockArchitecture blockArchitecture : systemEngineering.getContainedEPBSArchitectures()) {
                res.add(blockArchitecture);
            }
        }
        return res;
    }
}

