/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideABComponent
extends AbstractShowHide {
    public static final String SOURCE_PARTS = "sourceParts";
    public static final String TARGET_PARTS = "targetParts";
    boolean containsNodeDeployment = true;
    boolean containsBehavioralDeployment = true;

    public ShowHideABComponent(DDiagramContents content_p) {
        super(content_p);
        DiagramElementMapping mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABDeployedElement(this.getContent().getDDiagram()));
        this.containsNodeDeployment = StreamSupport.stream(this.getContent().getDiagramElements(mapping).spliterator(), false).anyMatch(x -> this.getNature(x.getTarget()) == PhysicalComponentNature.NODE);
        this.containsBehavioralDeployment = StreamSupport.stream(this.getContent().getDiagramElements(mapping).spliterator(), false).anyMatch(x -> this.getNature(x.getTarget()) == PhysicalComponentNature.BEHAVIOR);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        EObject targetContainer;
        Entity entity;
        Collection parts;
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        AbstractCollection result = new ArrayList<Object>();
        BlockArchitecture blockArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)semantic_p);
        Component systemComponent = blockArchitecture.getSystem();
        if (lastContext.getValue() instanceof Entity && (parts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)(entity = (Entity)lastContext.getValue()))).size() > 0 && (targetContainer = EcoreUtil2.getFirstContainer((EObject)((EObject)parts.iterator().next()), (EClass)CsPackage.Literals.COMPONENT)) instanceof Entity) {
            result.add(targetContainer);
            if (systemComponent != null) {
                result.remove(systemComponent);
            }
        }
        if (lastContext.getValue() instanceof Part) {
            Part part = (Part)lastContext.getValue();
            HashSet result3 = new HashSet();
            if (this.containsNodeDeployment || this.containsBehavioralDeployment) {
                result3.addAll((Collection)ModelCache.getCache(PartExt::getDeployingElements, (Object)part));
            }
            HashSet result2 = new HashSet();
            EObject targetContainer2 = EcoreUtil2.getFirstContainer((EObject)part, (EClass)CsPackage.Literals.COMPONENT);
            if (targetContainer2 instanceof Component) {
                result2.addAll(ComponentExt.getRepresentingParts((Component)((Component)targetContainer2)));
            }
            if (systemComponent != null) {
                result2.removeAll((Collection<?>)systemComponent.getRepresentingParts());
            }
            result.addAll(result2);
            result.addAll(result3);
            if (lastContext.getAncestor() != null) {
                HashSet<EObject> resul3 = new HashSet<EObject>();
                for (EObject eObject : result) {
                    if (!this.getContent().containsView(eObject)) continue;
                    resul3.add(eObject);
                }
                result = resul3;
            }
        }
        value.putAll("container", result);
        return value;
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        if (originCouple_p.getValue() instanceof Part || originCouple_p.getValue() instanceof Entity) {
            DiagramElementMapping mapping;
            if (originCouple_p.getAncestor() != null) {
                for (AbstractShowHide.ContextItemView view : originCouple_p.getAncestor().getElement().getViews()) {
                    if (view.getViews().get("views").size() <= 0) continue;
                    return false;
                }
            }
            if ((mapping = this.getMapping(originCouple_p.getValue(), context_p, relatedViews_p)) == null) {
                return false;
            }
            for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                Iterator iterator = view.getViews().get("views").iterator();
                while (iterator.hasNext()) {
                    DSemanticDecorator dView = (DSemanticDecorator)iterator.next();
                    if (!(dView instanceof DDiagramElement) || mapping.equals(((DDiagramElement)dView).getDiagramElementMapping())) continue;
                    return false;
                }
            }
            if (originCouple_p.getAncestor() != null) {
                for (AbstractShowHide.ContextItemView view : originCouple_p.getViews()) {
                    if (view.getViews().get("initial").size() <= 0) continue;
                    return false;
                }
            }
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    protected boolean bypassRelatedElements(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        if (originCouple_p.getAncestor() != null && (originCouple_p.getValue() instanceof Part && originCouple_p.getAncestor().getElement().getValue() instanceof Part ? !((List)ModelCache.getCache(PartExt::getDeployingElements, (Object)((Part)originCouple_p.getAncestor().getElement().getValue()))).contains(originCouple_p.getValue()) : originCouple_p.getValue() instanceof Entity && originCouple_p.getAncestor().getElement().getValue() instanceof Entity)) {
            return true;
        }
        return super.bypassRelatedElements(originCouple_p, context_p);
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic, AbstractShowHide.DiagramContext context, HashMapSet<String, DSemanticDecorator> relatedViews) {
        DiagramElementMapping mapping = super.getMapping(semantic, context, relatedViews);
        if (semantic instanceof Entity) {
            mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABComponent(semantic, this.getContent().getDDiagram()));
        } else if (semantic instanceof Part) {
            Object targetViews;
            Part part = (Part)semantic;
            List deployingElements = (List)ModelCache.getCache(PartExt::getDeployingElements, (Object)part);
            PhysicalComponentNature nature = this.getNature((EObject)part);
            if ((this.containsBehavioralDeployment && nature == PhysicalComponentNature.BEHAVIOR || this.containsNodeDeployment && nature == PhysicalComponentNature.NODE) && !deployingElements.isEmpty() && !(targetViews = relatedViews.get("container")).isEmpty() && deployingElements.contains(((DSemanticDecorator)targetViews.iterator().next()).getTarget())) {
                return this.getContent().getMapping(MappingConstantsHelper.getMappingABDeployedElement(this.getContent().getDDiagram()));
            }
            mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingABComponent(semantic, this.getContent().getDDiagram()));
        }
        return mapping;
    }

    protected PhysicalComponentNature getNature(EObject object) {
        EObject type = CsServices.getService().getComponentType(object);
        PhysicalComponentNature nature = null;
        if (type instanceof PhysicalComponent) {
            nature = ((PhysicalComponent)type).getNature();
        }
        return nature;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (semantic_p instanceof Part || semantic_p instanceof Entity) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        return semantic instanceof Part || semantic instanceof Entity;
    }
}

