/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.toolkit.decomposition;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionComponent;
import org.polarsys.capella.core.ui.toolkit.decomposition.DecompositionUtil;

public class DecompositionTreeCellModifier
implements ICellModifier {
    private TreeViewer _treeViewer;
    private boolean _enabled;

    public DecompositionTreeCellModifier(TreeViewer treeViewer_p) {
        this._treeViewer = treeViewer_p;
        this._enabled = false;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled_p) {
        this._enabled = enabled_p;
    }

    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    public void setTreeViewer(TreeViewer treeViewer_p) {
        this._treeViewer = treeViewer_p;
    }

    public boolean canModify(Object element_p, String property_p) {
        return this.isEnabled();
    }

    public Object getValue(Object element_p, String property_p) {
        return ((ITreeSelection)this._treeViewer.getSelection()).getFirstElement().toString();
    }

    public void modify(Object element_p, String property_p, Object value_p) {
        if (element_p instanceof TreeItem) {
            TreeItem item = (TreeItem)element_p;
            DecompositionComponent comp = (DecompositionComponent)item.getData();
            String newName = value_p.toString();
            if (DecompositionUtil.isValidName(newName, comp.getParentDecomposition())) {
                comp.setName(newName);
                item.setText(newName);
                this._treeViewer.update((Object)comp, null);
                this._treeViewer.refresh(true);
            }
            Event event = new Event();
            event.item = item;
            event.data = "rename";
            this._treeViewer.getTree().notifyListeners(3, event);
        }
    }
}

