/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.provider.ILibraryProviderListener;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ModelIdentifier;
import org.polarsys.capella.core.libraries.provider.AbstractCapellaProvider;
import org.polarsys.capella.core.libraries.provider.LibrarySAXXMIHandler;
import org.polarsys.capella.core.libraries.utils.IFileRequestor;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.xml.sax.helpers.DefaultHandler;

public class CapellaWorkspaceProvider
extends AbstractCapellaProvider
implements IResourceChangeListener,
IResourceDeltaVisitor {
    protected final TransactionalEditingDomain workspaceDomain = CapellaWorkspaceProvider.createEditingDomain();
    protected Collection<IModelIdentifier> _modelIds = null;
    protected final Map<IModelIdentifier, IModel> _models = new HashMap<IModelIdentifier, IModel>();

    public static TransactionalEditingDomain createEditingDomain() {
        ExecutionManager manager = ExecutionManagerRegistry.getInstance().addNewManager();
        TransactionalEditingDomain domain = manager.getEditingDomain();
        domain.setID(CapellaWorkspaceProvider.getWorkspaceEditingDomainID());
        domain.getResourceSet().setResourceFactoryRegistry((Resource.Factory.Registry)new ResourceFactoryRegistryImpl(){

            protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
                return new Resource.Factory(){

                    public Resource createResource(URI resourceUri) {
                        return new XMIResourceImpl(resourceUri){

                            protected XMLHelper createXMLHelper() {
                                return new XMLHelperImpl();
                            }

                            protected XMLLoad createXMLLoad() {
                                return new XMILoadImpl(this.createXMLHelper()){

                                    protected DefaultHandler makeDefaultHandler() {
                                        return new LibrarySAXXMIHandler(this.resource, this.helper, this.options);
                                    }
                                };
                            }
                        };
                    }
                };
            }
        });
        return domain;
    }

    public CapellaWorkspaceProvider() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this);
    }

    public Collection<IModelIdentifier> getAvailableModels() {
        if (this._modelIds == null) {
            this._modelIds = new ArrayList<IModelIdentifier>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    for (IModelIdentifier identifier : this.getModels(project)) {
                        if (this._modelIds == null) continue;
                        this._modelIds.add(identifier);
                    }
                }
                ++n2;
            }
        }
        return this._modelIds;
    }

    public Collection<IModelIdentifier> getAvailableModels(TransactionalEditingDomain domain) {
        if (this.isLocalProject(domain)) {
            return this.getAvailableModels();
        }
        return Collections.EMPTY_LIST;
    }

    public IModel getModelDefinition(IModelIdentifier identifier, TransactionalEditingDomain domain) {
        IModel model;
        Resource resource;
        if (!(identifier instanceof ModelIdentifier)) {
            return null;
        }
        URI modelURI = ((ModelIdentifier)identifier).getUri();
        if (!this.isHandled(modelURI)) {
            return null;
        }
        if (domain != null && (resource = this.getResource(domain, modelURI, false)) != null && resource.getErrors().isEmpty()) {
            return this.createModel((ModelIdentifier)identifier, domain);
        }
        if (!this._models.containsKey(identifier) && (resource = this.getResource(this.workspaceDomain, modelURI, true)) != null && resource.getErrors().isEmpty() && (model = this.createModel((ModelIdentifier)identifier, this.workspaceDomain)) != null) {
            this._models.put(identifier, model);
        }
        return this._models.get(identifier);
    }

    protected Collection<IModelIdentifier> getModels(IProject project) {
        if (!project.isOpen()) {
            return Collections.emptyList();
        }
        List<IFile> files = new IFileRequestor().search((IContainer)project, "capella", false);
        ArrayList<IModelIdentifier> models = new ArrayList<IModelIdentifier>(files.size());
        for (IFile mmFile : files) {
            models.addAll(this.getIdentifiers(mmFile));
        }
        return models;
    }

    protected Collection<IModelIdentifier> getIdentifiers(IFile mmFile) {
        URI uri = EcoreUtil2.getURI((IFile)mmFile);
        Resource resource = this.getResource(this.workspaceDomain, uri, true);
        ModelIdentifier identifier = this.createModelIdentifier(resource);
        if (identifier == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createModelIdentifier(resource));
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (CoreException coreException) {
            this.clear(delta);
        }
    }

    protected boolean clear(IResourceDelta delta) {
        this._modelIds = null;
        this._models.clear();
        this.workspaceDomain.getResourceSet().getResources().clear();
        this.notifyListeners(new ILibraryProviderListener.LibraryProviderEvent());
        return true;
    }

    public boolean visit(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                if ("capella".equals(resource.getFileExtension())) {
                    this.clear(delta);
                }
                return false;
            }
        }
        return false;
    }

    public IModelIdentifier getModelIdentifier(URI semanticUri) {
        Resource resource;
        if (this.isHandled(semanticUri) && (resource = this.getResource(this.workspaceDomain, semanticUri, true)) != null && resource.getErrors().isEmpty() && CapellaResourceHelper.isCapellaResource((URI)semanticUri)) {
            return CapellaModel.createModelIdentifier(resource);
        }
        return null;
    }

    public boolean isWorkspaceDomain(TransactionalEditingDomain domain) {
        return CapellaWorkspaceProvider.getWorkspaceEditingDomainID().equals(domain.getID());
    }

    private static String getWorkspaceEditingDomainID() {
        return CapellaWorkspaceProvider.class.getCanonicalName();
    }

    @Override
    protected boolean isHandled(URI uri) {
        return (uri.isPlatformResource() || uri.isPlatformPlugin()) && CapellaResourceHelper.isCapellaResource((URI)uri);
    }
}

