/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.polarsys.capella.common.ui.toolkit.widgets.MdeFilteredList;

public abstract class AbstractMdeElementListSelectionDialog
extends SelectionStatusDialog {
    private ILabelProvider _renderer;
    private boolean _ignoreCase = true;
    private boolean _isMultipleSelection = false;
    private boolean _matchEmptyString = true;
    private boolean _allowDuplicates = true;
    private Label _message;
    protected MdeFilteredList _filteredList;
    private Text _filterText;
    private ISelectionStatusValidator _validator;
    private String _filter = null;
    private String _emptyListMessage = "";
    private String _emptySelectionMessage = "";
    private int _width = 60;
    private int _height = 18;
    private Object[] _selection = new Object[0];

    protected AbstractMdeElementListSelectionDialog(Shell parent, ILabelProvider renderer) {
        super(parent);
        this._renderer = renderer;
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this._ignoreCase = ignoreCase;
    }

    public boolean isCaseIgnored() {
        return this._ignoreCase;
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        this._matchEmptyString = matchEmptyString;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this._isMultipleSelection = multipleSelection;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public void setSize(int width, int height) {
        this._width = width;
        this._height = height;
    }

    public void setEmptyListMessage(String message) {
        this._emptyListMessage = message;
    }

    public void setEmptySelectionMessage(String message) {
        this._emptySelectionMessage = message;
    }

    public void setValidator(ISelectionStatusValidator validator) {
        this._validator = validator;
    }

    protected void setListElements(Object[] elements) {
        Assert.isNotNull((Object)((Object)this._filteredList));
        this._filteredList.setElements(elements);
    }

    public void setFilter(String filter) {
        if (this._filterText == null) {
            this._filter = filter;
        } else {
            this._filterText.setText(filter);
        }
    }

    public String getFilter() {
        if (this._filteredList == null) {
            return this._filter;
        }
        return this._filteredList.getFilter();
    }

    protected int[] getSelectionIndices() {
        Assert.isNotNull((Object)((Object)this._filteredList));
        return this._filteredList.getSelectionIndices();
    }

    protected int getSelectionIndex() {
        Assert.isNotNull((Object)((Object)this._filteredList));
        return this._filteredList.getSelectionIndex();
    }

    protected void setSelection(Object[] selection) {
        Assert.isNotNull((Object)((Object)this._filteredList));
        this._filteredList.setSelection(selection);
    }

    protected Object[] getSelectedElements() {
        Assert.isNotNull((Object)((Object)this._filteredList));
        return this._filteredList.getSelection();
    }

    public Object[] getFoldedElements(int index) {
        Assert.isNotNull((Object)((Object)this._filteredList));
        return this._filteredList.getFoldedElements(index);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = super.createMessageArea(composite);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        this._message = label;
        return label;
    }

    protected void handleSelectionChanged() {
        this.validateCurrentSelection();
    }

    protected boolean validateCurrentSelection() {
        Assert.isNotNull((Object)((Object)this._filteredList));
        Object[] elements = this.getSelectedElements();
        Object status = elements.length > 0 ? (this._validator != null ? this._validator.validate(elements) : new Status(0, "org.eclipse.ui", 0, "", null)) : (this._filteredList.isEmpty() ? new Status(4, "org.eclipse.ui", 4, this._emptyListMessage, null) : new Status(4, "org.eclipse.ui", 4, this._emptySelectionMessage, null));
        this.updateStatus((IStatus)status);
        return status.isOK();
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected MdeFilteredList createFilteredList(Composite parent) {
        int flags = 0xB00 | (this._isMultipleSelection ? 2 : 4);
        MdeFilteredList list = new MdeFilteredList(parent, flags, this._renderer, this._ignoreCase, this._allowDuplicates, this._matchEmptyString);
        GridData data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(this._width);
        data.heightHint = this.convertHeightInCharsToPixels(this._height);
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        list.setLayoutData(data);
        list.setFont(parent.getFont());
        list.setFilter(this._filter == null ? "" : this._filter);
        list.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                AbstractMdeElementListSelectionDialog.this.handleDefaultSelected();
            }

            public void widgetSelected(SelectionEvent event) {
                AbstractMdeElementListSelectionDialog.this.handleWidgetSelected();
            }
        });
        this._filteredList = list;
        return list;
    }

    private void handleWidgetSelected() {
        Object[] newSelection = this._filteredList.getSelection();
        if (newSelection.length != this._selection.length) {
            this._selection = newSelection;
            this.handleSelectionChanged();
        } else {
            int i = 0;
            while (i != newSelection.length) {
                if (!newSelection[i].equals(this._selection[i])) {
                    this._selection = newSelection;
                    this.handleSelectionChanged();
                    break;
                }
                ++i;
            }
        }
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this._filter == null ? "" : this._filter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                AbstractMdeElementListSelectionDialog.this._filteredList.setFilter(AbstractMdeElementListSelectionDialog.this._filterText.getText());
            }
        };
        text.addListener(24, listener);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    AbstractMdeElementListSelectionDialog.this._filteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
        this._filterText = text;
        return text;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    private void access$superCreate() {
        super.create();
    }

    public void create() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractMdeElementListSelectionDialog.this.access$superCreate();
                Assert.isNotNull((Object)((Object)AbstractMdeElementListSelectionDialog.this._filteredList));
                if (AbstractMdeElementListSelectionDialog.this._filteredList.isEmpty()) {
                    AbstractMdeElementListSelectionDialog.this.handleEmptyList();
                } else {
                    AbstractMdeElementListSelectionDialog.this.validateCurrentSelection();
                    AbstractMdeElementListSelectionDialog.this._filterText.selectAll();
                    AbstractMdeElementListSelectionDialog.this._filterText.setFocus();
                }
            }
        });
    }

    protected void handleEmptyList() {
        this._message.setEnabled(false);
        this._filterText.setEnabled(false);
        this._filteredList.setEnabled(false);
        this.updateOkState();
    }

    protected void updateOkState() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.getSelectedElements().length != 0);
        }
    }
}

