/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.impl.AbstractBridgeTraceExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingCause;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRuleIdentifier;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.QueryExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.util.TraceLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.AbstractLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.CollectionsUtil;

public class MappingExecution
extends AbstractBridgeTraceExecution
implements IMappingExecution.Editable {
    protected final Map<Object, Map<IRule<?, ?, ?>, PendingDefinition>> _content = new LinkedHashMap();
    protected final Map<IRuleIdentifier<?, ?, ?>, IRule<?, ?, ?>> _ruleMap = new HashMap();
    private boolean _isTolerantToDuplicates = true;
    private Object _targetDataSet;

    public MappingExecution(IBridgeTrace.Editable trace_p, Logger logger_p) {
        super(trace_p, logger_p);
    }

    public Object get(ICause<?> cause_p) {
        Object result = null;
        if (cause_p instanceof IMappingCause) {
            IMappingCause cause = (IMappingCause)cause_p;
            IRule rule = cause.getRule();
            Object traceSource = rule.traceSource(cause.getSource());
            result = this.get(traceSource, rule);
        }
        return result;
    }

    @Override
    public <TRS, T> T get(TRS source_p, IRule<?, TRS, T> rule_p) {
        return this.get(source_p, (IRuleIdentifier)rule_p.getID());
    }

    @Override
    public <TRS, T> T get(TRS source_p, IRuleIdentifier<?, TRS, T> ruleID_p) {
        PendingDefinition pendingDef;
        Map<IRule<?, ?, ?>, PendingDefinition> ruleToTarget;
        Object result = null;
        IRule<?, ?, ?> rule = this._ruleMap.get(ruleID_p);
        if (rule != null && (ruleToTarget = this._content.get(source_p)) != null && (pendingDef = ruleToTarget.get(rule)) != null) {
            result = pendingDef.getTarget();
        }
        return (T)result;
    }

    @Override
    public List<Object> getAll(Object source_p) {
        List<Object> result = Collections.emptyList();
        Map<IRule<?, ?, ?>, PendingDefinition> ruleToDef = this._content.get(source_p);
        if (ruleToDef != null) {
            result = new ArrayList<Object>(ruleToDef.size());
            for (PendingDefinition pendingDef : ruleToDef.values()) {
                result.add(pendingDef.getTarget());
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public <T> List<T> getAll(Object source_p, Class<T> type_p) {
        List result = Collections.emptyList();
        Map<IRule<?, ?, ?>, PendingDefinition> ruleToDef = this._content.get(source_p);
        if (ruleToDef != null) {
            result = new ArrayList();
            for (PendingDefinition pendingDef : ruleToDef.values()) {
                result.addAll(CollectionsUtil.flattenFindAll((Object)pendingDef.getTarget(), type_p));
            }
        }
        return result;
    }

    @Override
    public <T> T getOne(Object source_p, Class<T> type_p) {
        Map<IRule<?, ?, ?>, PendingDefinition> ruleToDef = this._content.get(source_p);
        if (ruleToDef != null) {
            for (PendingDefinition pendingDef : ruleToDef.values()) {
                Object result = CollectionsUtil.flattenFindOne((Object)pendingDef.getTarget(), type_p);
                if (result == null) continue;
                return (T)result;
            }
        }
        return null;
    }

    public Map<IRule<?, ?, ?>, PendingDefinition> getPendingDefinitions(Object source_p) {
        return this._content.get(source_p);
    }

    public Set<Object> getPendingSources() {
        return this._content.keySet();
    }

    @Override
    public <S> Collection<S> getRuleInputs(IRule<S, ?, ?> rule_p, IQueryExecution context_p) {
        Collection<S> result = this.getRuleInputs((IRuleIdentifier)rule_p.getID(), context_p);
        return result;
    }

    @Override
    public <S> Collection<S> getRuleInputs(IRuleIdentifier<S, ?, ?> ruleID_p, IQueryExecution context_p) {
        LinkedList<Object> result = new LinkedList<Object>();
        IRule<?, ?, ?> rule = this._ruleMap.get(ruleID_p);
        if (rule != null) {
            QueryExecution context = context_p instanceof QueryExecution ? (QueryExecution)context_p : null;
            for (Map.Entry<Object, Map<IRule<?, ?, ?>, PendingDefinition>> sourceEntry : this._content.entrySet()) {
                PendingDefinition pendingDef = sourceEntry.getValue().get(rule);
                if (pendingDef == null || context != null && !context.isAncestorOrEquals(pendingDef.getQueryExecution())) continue;
                Object source = pendingDef.getQueryExecution().getLast();
                result.add(source);
            }
        }
        return result;
    }

    public boolean isRegistered(ICause<?> cause_p) {
        return this.get(cause_p) != null;
    }

    public boolean isTolerantToDuplicates() {
        return this._isTolerantToDuplicates;
    }

    public void put(ICause<?> cause_p, Object target_p) {
        if (cause_p instanceof IMappingCause) {
            PendingDefinition squatter;
            IMappingCause cause = (IMappingCause)cause_p;
            IRule rule = cause.getRule();
            this._ruleMap.put((IRuleIdentifier)rule.getID(), rule);
            Object source = cause.getSource();
            Map<IRule<?, ?, ?>, PendingDefinition> ruleToTarget = this._content.get(source);
            if (ruleToTarget == null) {
                ruleToTarget = new LinkedHashMap();
                Object traceSource = rule.traceSource(source);
                this._content.put(traceSource, ruleToTarget);
            }
            if ((squatter = ruleToTarget.put(rule, new PendingDefinition(cause.getQueryExecution(), target_p))) != null && !this.isTolerantToDuplicates()) {
                throw new IllegalArgumentException(String.format("A pending definition is already registered for rule [%1$s] on source [%2$s]: [%3$s] replaced by [%4$s].", rule, source, squatter, target_p));
            }
        }
    }

    public void setTolerantToDuplicates(boolean tolerant_p) {
        this._isTolerantToDuplicates = tolerant_p;
    }

    @Override
    public <TD> TD getTargetDataSet() {
        return (TD)this._targetDataSet;
    }

    @Override
    public void putInTrace(ICause<?> cause_p, Object target_p) {
        super.putInTrace(cause_p, target_p);
    }

    protected AbstractLoggingMessage createTraceLoggingMessage(Object target_p, ICause<?> cause_p) {
        return new TraceLoggingMessage(target_p, cause_p);
    }

    public void setTargetDataSet(Object targetDataSet_p) {
        this._targetDataSet = targetDataSet_p;
    }

    public static class PendingDefinition {
        private IQueryExecution _context;
        private Object _target;

        protected PendingDefinition(IQueryExecution context_p, Object target_p) {
            if (context_p == null || target_p == null) {
                throw new IllegalArgumentException("Null value in pending definition");
            }
            this._context = context_p;
            this._target = target_p;
        }

        public boolean equals(Object other_p) {
            boolean result = false;
            if (other_p instanceof PendingDefinition) {
                PendingDefinition peer = (PendingDefinition)other_p;
                result = this.getQueryExecution().equals(peer.getQueryExecution()) && this.getTarget().equals(peer.getTarget());
            }
            return result;
        }

        public IQueryExecution getQueryExecution() {
            return this._context;
        }

        public Object getTarget() {
            return this._target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getQueryExecution().hashCode();
            result = 31 * result + this.getTarget().hashCode();
            return result;
        }
    }
}

