/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;

public class FileReporter
implements PatternExecutionReporter {
    public void executionFinished(String output, PatternContext context) {
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
        String fileNameString = (String)context.getValue("fileName");
        String filePathString = (String)context.getValue("filePath");
        String generationPath = (String)context.getValue("generationPath");
        if (fileNameString == null || filePathString == null || generationPath == null) {
            return;
        }
        IPath dirPath = new Path(generationPath).append(filePathString);
        IPath filePath = dirPath.append(fileNameString);
        try {
            if (generationPath.startsWith("platform:/resource/")) {
                this.handleWorkspaceFile(outputWithCallBack, filePath);
            } else {
                this.handleFile(outputWithCallBack, filePath);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate file " + filePath, e);
        }
    }

    protected void handleFile(String outputWithCallBack, IPath filePath) throws IOException {
        File fileFile = filePath.toFile();
        if (FileHelper.hasContent((File)fileFile, (String)outputWithCallBack)) {
            return;
        }
        if (!fileFile.getParentFile().exists()) {
            fileFile.getParentFile().mkdirs();
        }
        FileWriter fileWriter = new FileWriter(fileFile);
        fileWriter.write(outputWithCallBack);
        fileWriter.close();
    }

    protected void handleWorkspaceFile(String outputWithCallBack, IPath filePath) throws CoreException {
        String projectName = filePath.segment(1);
        IPath projectRelativePath = filePath.removeFirstSegments(2).setDevice(null);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile file = project.getFile(projectRelativePath);
        if (FileHelper.hasContent((File)file.getRawLocation().toFile(), (String)outputWithCallBack)) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (!project.exists()) {
            project.create((IProgressMonitor)monitor);
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)monitor);
        }
        int i = projectRelativePath.segmentCount() - 1;
        while (i >= 1) {
            IFolder folder = project.getFolder(projectRelativePath.removeLastSegments(i));
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)monitor);
            }
            --i;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputWithCallBack.getBytes());
        if (!file.exists()) {
            file.create((InputStream)inputStream, true, (IProgressMonitor)monitor);
        } else {
            file.setContents((InputStream)inputStream, true, true, (IProgressMonitor)monitor);
        }
    }
}

