/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.migration.contribution;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.core.data.migration.AbstractMigrationRunnable;
import org.polarsys.capella.core.data.migration.context.MigrationContext;
import org.polarsys.capella.core.data.migration.contributor.AbstractMigrationContributor;

public class PatternCatalogDeletionContributor
extends AbstractMigrationContributor {
    @Override
    public String getKind() {
        return "MIGRATION_KIND__PATTERN";
    }

    @Override
    public boolean isValidResource(IResource member) {
        return "patterns".equals(member.getFileExtension());
    }

    @Override
    public AbstractMigrationRunnable getRunnable(final IFile file) {
        return new AbstractMigrationRunnable(file){

            @Override
            public IStatus run(MigrationContext context, boolean checkVersion) {
                try {
                    IContainer parent = file.getParent();
                    file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    if (parent instanceof IFolder && parent.members().length == 0) {
                        parent.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (CoreException e) {
                    return new Status(4, "org.polarsys.capella.core.data.migration", e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }
}

