/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public abstract class PropertyPropagator {
    public List<Collection<EObject>> applyPropertiesOn(List<? extends EObject> literals, Collection<EObject> selectedObjects, boolean semanticElementPropagation, boolean technicalElementPropagation, boolean propagateToRepresentations, boolean useFilterStatus, String filterStatus, boolean mustCleanReview, boolean mustPropagateStatus) {
        HashSet<EObject> tgts = new HashSet<EObject>();
        for (EObject obj : selectedObjects) {
            if (tgts.contains(obj)) continue;
            this.handleFilterStatus(semanticElementPropagation, technicalElementPropagation, propagateToRepresentations, useFilterStatus, filterStatus, tgts, obj);
            if (obj instanceof DRepresentationDescriptor) continue;
            TreeIterator it = obj.eAllContents();
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                this.handleFilterStatus(semanticElementPropagation, technicalElementPropagation, propagateToRepresentations, useFilterStatus, filterStatus, tgts, current);
            }
        }
        if (propagateToRepresentations) {
            Collection<DRepresentationDescriptor> representationsTargeted = RepresentationHelper.getAllRepresentationDescriptorsTargetedBy(selectedObjects);
            for (DRepresentationDescriptor descriptor : representationsTargeted) {
                if (useFilterStatus) {
                    if (!this.mustBeFiltered(filterStatus, (EObject)descriptor)) continue;
                    tgts.add((EObject)descriptor);
                    continue;
                }
                tgts.add((EObject)descriptor);
            }
        }
        HashSet<EObject> tagChangedElements = new HashSet<EObject>();
        HashSet<EObject> reviewChangedElements = new HashSet<EObject>();
        for (EObject eobj : tgts) {
            boolean result = false;
            if (mustPropagateStatus && (result = this.tagElement(literals, eobj))) {
                tagChangedElements.add(eobj);
            }
            if (!mustCleanReview || !(result = this.cleanReview(eobj))) continue;
            reviewChangedElements.add(eobj);
        }
        ArrayList<Collection<EObject>> colOut = new ArrayList<Collection<EObject>>();
        colOut.add(tagChangedElements);
        colOut.add(reviewChangedElements);
        return colOut;
    }

    protected void handleFilterStatus(boolean semanticElementPropagation, boolean technicalElementPropagation, boolean propagateToRepresentations, boolean useFilterStatus, String filterStatus, Collection<EObject> tgts, EObject current) {
        if (useFilterStatus) {
            if (this.mustBeFiltered(filterStatus, current)) {
                this.handlePropagation(semanticElementPropagation, technicalElementPropagation, propagateToRepresentations, tgts, current);
            }
        } else {
            this.handlePropagation(semanticElementPropagation, technicalElementPropagation, propagateToRepresentations, tgts, current);
        }
    }

    protected void handlePropagation(boolean semanticElementPropagation, boolean technicalElementPropagation, boolean propagateToRepresentations, Collection<EObject> tgts, EObject obj) {
        if (this.isTaggableElement(obj)) {
            if (obj instanceof DRepresentationDescriptor) {
                if (propagateToRepresentations) {
                    tgts.add(obj);
                }
            } else if (semanticElementPropagation) {
                tgts.add(obj);
            }
        } else if (technicalElementPropagation) {
            tgts.add(obj);
        }
    }

    protected boolean mustBeFiltered(String filterStatus, EObject obj) {
        return filterStatus == null && this.getElementTag(obj) == null || filterStatus != null && filterStatus.equals(this.getElementTag(obj));
    }

    public boolean isTaggableElement(EObject element) {
        return this.isDirectElement(element) || this.isWithSpecializedElement(element);
    }

    protected boolean tagElement(List<? extends EObject> literals, EObject eObject) {
        boolean result = true;
        for (EObject eObject2 : literals) {
            if (eObject2 == null || eObject2 instanceof EnumerationPropertyLiteral) {
                result &= this.tagElement((EnumerationPropertyLiteral)eObject2, eObject);
                continue;
            }
            result &= false;
        }
        return result;
    }

    protected Collection<EClass> getDirectTypes() {
        HashSet<EClass> directTypes = new HashSet<EClass>();
        directTypes.add(FaPackage.Literals.COMPONENT_EXCHANGE);
        directTypes.add(FaPackage.Literals.FUNCTIONAL_EXCHANGE);
        directTypes.add(InteractionPackage.Literals.ABSTRACT_FRAGMENT);
        directTypes.add(CsPackage.Literals.PHYSICAL_LINK);
        return directTypes;
    }

    protected Collection<EClass> getWithSpecializationType() {
        HashSet<EClass> withSpecializationTypes = new HashSet<EClass>();
        withSpecializationTypes.add(CapellacorePackage.Literals.CONSTRAINT);
        withSpecializationTypes.add(CapellacommonPackage.Literals.STATE_MACHINE);
        withSpecializationTypes.add(CapellacorePackage.Literals.STRUCTURE);
        withSpecializationTypes.add(FaPackage.Literals.ABSTRACT_FUNCTION);
        withSpecializationTypes.add(CsPackage.Literals.PART);
        withSpecializationTypes.add(CsPackage.Literals.COMPONENT);
        withSpecializationTypes.add(FaPackage.Literals.FUNCTIONAL_CHAIN);
        withSpecializationTypes.add(FaPackage.Literals.EXCHANGE_CATEGORY);
        withSpecializationTypes.add(InteractionPackage.Literals.ABSTRACT_CAPABILITY);
        withSpecializationTypes.add(InteractionPackage.Literals.SCENARIO);
        withSpecializationTypes.add(CtxPackage.Literals.MISSION);
        withSpecializationTypes.add(OaPackage.Literals.ENTITY);
        withSpecializationTypes.add(OaPackage.Literals.ROLE);
        withSpecializationTypes.add(CsPackage.Literals.PHYSICAL_PATH);
        withSpecializationTypes.add(CapellacorePackage.Literals.GENERAL_CLASS);
        withSpecializationTypes.add(InformationPackage.Literals.COLLECTION);
        withSpecializationTypes.add(InformationPackage.Literals.EXCHANGE_ITEM);
        withSpecializationTypes.add(DatatypePackage.Literals.DATA_TYPE);
        withSpecializationTypes.add(InformationPackage.Literals.UNIT);
        withSpecializationTypes.add(CapellacommonPackage.Literals.REGION);
        return withSpecializationTypes;
    }

    protected abstract boolean isTagged(EObject var1);

    protected abstract boolean isTaggedRepresentation(EObject var1);

    protected abstract boolean tagElement(EnumerationPropertyLiteral var1, EObject var2);

    protected abstract String getKeyword();

    protected abstract boolean cleanReview(EObject var1);

    protected abstract String getElementTag(EObject var1);

    protected boolean isDirectElement(EObject eObject) {
        if (eObject != null) {
            EClass eclass = eObject.eClass();
            for (EClass current : this.getDirectTypes()) {
                if (current != eclass) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isWithSpecializedElement(EObject eObject) {
        if (eObject != null) {
            EClass eclass = eObject.eClass();
            for (EClass current : this.getWithSpecializationType()) {
                if (!current.isSuperTypeOf(eclass)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnumerationPropertyTypeDefinedForProject(EObject eObject) {
        return CapellaProjectHelper.getEnumerationPropertyType(eObject, this.getKeyword()) != null;
    }

    public List<EObject> getTaggedObjects(EObject root) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Session session = SessionManager.INSTANCE.getSession(root);
        if (root != null) {
            if (this.isTagged(root)) {
                result.add(root);
            }
            TreeIterator it = root.eAllContents();
            EObject current = null;
            for (DRepresentationDescriptor representationDesc : DialectManager.INSTANCE.getRepresentationDescriptors(root, session)) {
                if (!this.isTaggedRepresentation((EObject)representationDesc)) continue;
                result.add((EObject)representationDesc);
            }
            while (it.hasNext()) {
                current = (EObject)it.next();
                if (this.isTagged(current)) {
                    result.add(current);
                }
                for (DRepresentationDescriptor representationDesc : DialectManager.INSTANCE.getRepresentationDescriptors(current, session)) {
                    if (!this.isTaggedRepresentation((EObject)representationDesc)) continue;
                    result.add((EObject)representationDesc);
                }
            }
        }
        return result;
    }
}

