/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.sirius.analysis.constants;

/**
 * Centralizes constants about drag and drop tools.
 */
public interface IDNDToolNameConstants {

  //
  // Drag and Drop diagram Tools
  //

  String TOOL_DND_MISSIONS_FROM_EXPLORER = "D&D Missions From Project Explorer";
  String TOOL_DND_CAPABILITIES_FROM_EXPLORER = "D&D Capabilities From Project Explorer";
  String TOOL_DND_COMPONENT = "Component from Diagram";
  String TOOL_DND_CONSTRAINT_FROM_EXPLORER = "D&D Constraint From Project Explorer";
  String TOOL_DND_CONSTRAINTS_FROM_EXPLORER = "D&D Constraints From Project Explorer";
  String TOOL_DND_ACTORS_FROM_EXPLORER = "D&D Actors From Project Explorer";
  String TOOL_DND_ENTITIES_FROM_EXPLORER = "D&D Entities From Project Explorer";
  String TOOL_DND_OPERATIONAL_CAPABILITIES_FROM_EXPLORER = "D&D Operational Capabilities From Project Explorer";
  String TOOL_SEQ_DND_COMPONENT = "Drop Component";
  String TOOL_XDFB_DND_FUNCTIONPORT = "DnD DF FunctionPort";
  String TOOL_XDFB_DND_ABSTRACTFUNCTION = "DnD DF AbstractFunction";
  String TOOL_XDFB_DND_FUNCTION_FROM_EXPLORER = "D&D Function From Project Explorer";
  String TOOL_XAB_DND_ABSTRACTFUNCTION_ALLOCATION = "DnD AB AbstractFunction Allocation"; // done
  String TOOL_XAB_DND_COMPONENTPORT = "DnD AB ComponentPort";
  String TOOL_XAB_DND_FUNCTIONPORT = "DnD AB FunctionPort";
  String TOOL_XAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER = "D&D Function Allocation From Project Explorer";
  String TOOL_XAB_DND_PHYSICALPORT = "D&D PhysicalPort";
  String TOOL_XAB_DND_COMPONENTS_FROM_EXPLORER = "D&D Components From Project Explorer"; // done
  String TOOL_XAB_DND_COMPONENT = "DnD AB Component";

  // CC
  String TOOL_CC_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CC_DND_MISSIONS_FROM_EXPLORER = TOOL_DND_MISSIONS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CC_DND_CAPABILITIES_FROM_EXPLORER = TOOL_DND_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CC_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$

  // CRI
  String TOOL_CRI_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // CDB
  String TOOL_CDB_DND_DATATYPE_FROM_EXPLORER = "D&D DataType From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_BOOLEANTYPE_FROM_EXPLORER = "D&D BooleanType From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_CLASS_FROM_EXPLORER = "D&D Class From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_COLLECTION_FROM_EXPLORER = "D&D Collection From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_ENUMERATION_FROM_EXPLORER = "D&D Enumeration From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CDB_DND_DATAPKG_FROM_EXPLORER = "D&D DataPkg From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_UNIT_FROM_EXPLORER = "D&D Unit from Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_CLASS_INTO_DATAPKG = "Class Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_COLLECTION_INTO_DATAPKG = "Collection Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_DATATYPE_INTO_DATAPKG = "DataType Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_DATAPKG_INTO_DATAPKG = "DataPkg Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_DATAVALUE_FROM_EXPLORER = "D&D DataValue From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_DATAVALUE_INTO_DATAPKG = "DataValue Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_DATAVALUE_INTO_CLASS = "DataValue Into Class"; //$NON-NLS-1$
  String TOOL_CDB_DND_UNIT_INTO_DATAPKG = "Unit Into DataPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_INTERFACE_FROM_EXPLORER = "D&D Interface From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_EXCHANGEITEM_FROM_EXPLORER = "D&D ExchangeItem From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_INTERFACEPKG_FROM_EXPLORER = "D&D InterfacePkg From Project Explorer"; //$NON-NLS-1$
  String TOOL_CDB_DND_INTERFACE_INTO_INTERFACEPKG = "Interface Into InterfacePkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_EXCHANGEITEM_INTO_EXCHANGEITEMPKG = "AbstractExchangeItem Into AbstractExchangeItemPkg"; //$NON-NLS-1$
  String TOOL_CDB_DND_INTERFACEPKG_INTO_INTERFACEPKG = "InterfacePkg Into InterfacePkg"; //$NON-NLS-1$

  // IDB
  String TOOL_IDB_DND_COMPONENTPORT_FROM_EXPLORER = "ComponentPort from Model"; //$NON-NLS-1$
  String TOOL_IDB_DND_COMPONENTPORT = "ComponentPort from Diagram"; //$NON-NLS-1$
  String TOOL_IDB_DND_COMPONENT_FROM_EXPLORER = "Component from Model"; // $NON-NLS-1$
  String TOOL_IDB_DND_COMPONENT = TOOL_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER = "Allocation ExchangeItem from Model"; //$NON-NLS-1$
  String TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION = "Allocation ExchangeItem from Diagram"; //$NON-NLS-1$
  String TOOL_IDB_DND_INTERFACEDROP_FROM_EXPLORER = "InterfaceDrop from Model"; //$NON-NLS-1$
  String TOOL_IDB_DND_INTERFACEDROP = "InterfaceDrop from Diagram"; //$NON-NLS-1$
  String TOOL_IDB_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // CDI
  String TOOL_CDI_DND_COMPONENTPORT_FROM_EXPLORER = TOOL_IDB_DND_COMPONENTPORT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CDI_DND_COMPONENTPORT = TOOL_IDB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_CDI_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER = TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CDI_DND_EXCHANGEITEM_ALLOCATION = TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION; // $NON-NLS-1$
  String TOOL_CDI_DND_INTERFACEDROP_FROM_EXPLORER = TOOL_IDB_DND_INTERFACEDROP_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CDI_DND_INTERFACEDROP = TOOL_IDB_DND_INTERFACEDROP; // $NON-NLS-1$
  String TOOL_CDI_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // CEI
  String TOOL_CEI_DND_COMPONENTPORT_FROM_EXPLORER = TOOL_IDB_DND_COMPONENTPORT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CEI_DND_COMPONENTPORT = TOOL_IDB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_CEI_DND_COMPONENT_FROM_EXPLORER = TOOL_IDB_DND_COMPONENT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CEI_DND_COMPONENT = TOOL_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_CEI_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER = TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$

  String TOOL_CEI_DND_INTERFACEDROP_FROM_EXPLORER = TOOL_IDB_DND_INTERFACEDROP_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CEI_DND_INTERFACEDROP = TOOL_IDB_DND_INTERFACEDROP; // $NON-NLS-1$
  String TOOL_CEI_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // CII
  String TOOL_CII_DND_COMPONENTPORT_FROM_EXPLORER = TOOL_IDB_DND_COMPONENTPORT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CII_DND_COMPONENTPORT = TOOL_IDB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_CII_DND_COMPONENT_FROM_EXPLORER = TOOL_IDB_DND_COMPONENT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CII_DND_COMPONENT = TOOL_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_CII_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER = TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CII_DND_EXCHANGEITEM_ALLOCATION = TOOL_IDB_DND_EXCHANGEITEM_ALLOCATION; // $NON-NLS-1$
  String TOOL_CII_DND_INTERFACEDROP_FROM_EXPLORER = TOOL_IDB_DND_INTERFACEDROP_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CII_DND_INTERFACEDROP = TOOL_IDB_DND_INTERFACEDROP; // $NON-NLS-1$
  String TOOL_CII_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // CIBD
  String TOOL_CIBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // CM
  String TOOL_CM_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CM_DND_MISSIONS_FROM_EXPLORER = TOOL_DND_MISSIONS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CM_DND_CAPABILITIES_FROM_EXPLORER = TOOL_DND_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CM_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$

  // COC
  String TOOL_COC_DND_ENTITIES_FROM_EXPLORER = TOOL_DND_ENTITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_COC_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_COC_DND_OPERATIONAL_CAPABILITIES_FROM_EXPLORER = TOOL_DND_OPERATIONAL_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$

  // CRB
  String TOOL_CRB_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CRB_DND_COMPONENT_FROM_EXPLORER = "Component from Model"; // $NON-NLS-1$
  String TOOL_CRB_DND_CAPABILITIES_FROM_EXPLORER = TOOL_DND_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_CRB_DND_COMPONENT = TOOL_DND_COMPONENT; // $NON-NLS-1$

  // CSA
  String TOOL_CSA_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // EAB
  String TOOL_EAB_DND_CONFIGURATIONITEM_FROM_EXPLORER = "D&D Components From Project Explorer"; //$NON-NLS-1$
  String TOOL_EAB_DND_PHYSICAL_ARTIFACTS = "DnD AB Physical Artifacts"; //$NON-NLS-1$
  String TOOL_EAB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // ES
  String TOOL_ES_DND_COMPONENT = TOOL_SEQ_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_ES_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // FCD
  String TOOL_FCD_DND_FUNCTION = "Dnd Function"; //$NON-NLS-1$
  String TOOL_FCD_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // FS
  String TOOL_FS_DND_COMPONENT = TOOL_SEQ_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_FS_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // ID
  String TOOL_ID_DND_EXCHANGEITEM_ALLOCATION_FROM_EXPLORER = "Allocation ExchangeItem from Model"; //$NON-NLS-1$

  // IS
  String TOOL_IS_DND_COMPONENT = TOOL_SEQ_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_IS_DND_CONSTRAINT_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$

  // LAB
  String TOOL_LAB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_LAB_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_LAB_DND_COMPONENTS_FROM_EXPLORER = TOOL_XAB_DND_COMPONENTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_LAB_DND_ABSTRACTFUNCTION_ALLOCATION = TOOL_XAB_DND_ABSTRACTFUNCTION_ALLOCATION; // $NON-NLS-1$
  String TOOL_LAB_DND_COMPONENTPORT = TOOL_XAB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_LAB_DND_FUNCTIONPORT = TOOL_XAB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_LAB_DND_COMPONENT = TOOL_XAB_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_LAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER = TOOL_XAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_LAB_DND_PHYSICALPORT = TOOL_XAB_DND_PHYSICALPORT; // $NON-NLS-1$

  // LDFB
  String TOOL_LDFB_DND_FUNCTIONPORT = TOOL_XDFB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_LDFB_DND_ABSTRACTFUNCTION = TOOL_XDFB_DND_ABSTRACTFUNCTION; // $NON-NLS-1$
  String TOOL_LDFB_DND_FUNCTION_FROM_EXPLORER = TOOL_XDFB_DND_FUNCTION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_LDFB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // LCBD
  String TOOL_LCBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // LFBD
  String TOOL_LFBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // MB
  String TOOL_MB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MB_DND_MISSIONS_FROM_EXPLORER = TOOL_DND_MISSIONS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MB_DND_CAPABILITIES_FROM_EXPLORER = TOOL_DND_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MB_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$

  // MCB
  String TOOL_MCB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MCB_DND_MISSIONS_FROM_EXPLORER = TOOL_DND_MISSIONS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MCB_DND_CAPABILITIES_FROM_EXPLORER = TOOL_DND_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MCB_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$

  // M&S
  String TOOL_MS_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINT_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_MS_DND_MODESTATE_FROM_EXPLORER = "D&D ModeState From Project Explorer"; //$NON-NLS-1$
  String TOOL_MS_DND_MODESTATE_FROM_DIAGRAM = "D&D ModeState from Diagram"; //$NON-NLS-1$

  // OAB
  String TOOL_OAB_DND_ABSTRACTFUNCTION_ALLOCATION = TOOL_XAB_DND_ABSTRACTFUNCTION_ALLOCATION; // $NON-NLS-1$
  String TOOL_OAB_CHANGE_ROLE_ALLOCATION = "change role allocation"; //$NON-NLS-1$
  String TOOL_OAB_DND_ENTITY = "DnD Entitiy"; //$NON-NLS-1$
  String TOOL_OAB_DND_ENTITIES_FROM_EXPLORER = TOOL_DND_ENTITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_OAB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_OAB_DND_ROLES_FROM_EXPLORER = "D&D Roles From Project Explorer"; //$NON-NLS-1$
  String TOOL_OAB_DND_OPERATIONALACTIVITIES_FROM_EXPLORER = "D&D OperationalActivities From Project Explorer"; //$NON-NLS-1$
  String TOOL_OAB_DND_OPERATIONALACTIVITIES_FROM_EXPLORER_TO_ROLE = "D&D OperationalActivities From Project Explorer To Role"; //$NON-NLS-1$

  // OABD
  String TOOL_OABD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // OAIB
  String TOOL_OAIB_DND_ABSTRACTFUNCTION = TOOL_XDFB_DND_ABSTRACTFUNCTION; // $NON-NLS-1$
  String TOOL_OAIB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_OAIB_DND_OPERATIONALACTIVITY_FROM_EXPLORER = "D&D OperationalActivity From Project Explorer"; //$NON-NLS-1$

  // OAS
  String TOOL_OAS_DND_COMPONENT = TOOL_SEQ_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_OAS_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // OCB
  String TOOL_OCB_DND_ENTITIES_FROM_EXPLORER = TOOL_DND_ENTITIES_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_OCB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_OCB_DND_OPERATIONAL_CAPABILITIES_FROM_EXPLORER = TOOL_DND_OPERATIONAL_CAPABILITIES_FROM_EXPLORER; // $NON-NLS-1$

  // OEBD
  String TOOL_OEBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // OES
  String TOOL_OES_DND_COMPONENT = TOOL_SEQ_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_OES_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // OPD
  String TOOL_OPD_DND_FUNCTION = "Dnd Function"; //$NON-NLS-1$
  String TOOL_OPD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // ORB
  String TOOL_ORB_CHANGE_ALLOCATION = "change allocation"; //$NON-NLS-1$
  String TOOL_ORB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_ORB_DND_ROLE_FOM_EXPLORER = "D&D Role From Project Explorer"; //$NON-NLS-1$
  String TOOL_ORB_DND_OPERATIONALACTIVITIES_FROM_EXPLORER = "D&D OperationalActivities From Project Explorer"; //$NON-NLS-1$

  // PAB
  String TOOL_PAB_DND_COMPONENTPORT = TOOL_XAB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_PAB_DND_PHYSICALPORT = TOOL_XAB_DND_PHYSICALPORT; // $NON-NLS-1$
  String TOOL_PAB_DND_COMPONENT = TOOL_XAB_DND_COMPONENT; // $NON-NLS-1$
  String TOOL_PAB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_PAB_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_PAB_DND_COMPONENTS_FROM_EXPLORER = TOOL_XAB_DND_COMPONENTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_PAB_DND_DEPLOYMENT = "DnD AB Deployment"; //$NON-NLS-1$
  String TOOL_PAB_DND_ABSTRACTFUNCTION_ALLOCATION = TOOL_XAB_DND_ABSTRACTFUNCTION_ALLOCATION; // $NON-NLS-1$
  String TOOL_PAB_DND_FUNCTIONPORT = TOOL_XAB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_PAB_DND_ABSTRACTFUNCTION_ALLOCATION_FROM_EXPLORER = TOOL_XAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$

  // PCBD
  String TOOL_PCBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // PD
  String TOOL_PD_DND_INTERFACEPKG_FROM_EXPLORER = "Allocate InterfacePkg from Model"; //$NON-NLS-1$

  // PDFB
  String TOOL_PDFB_DND_FUNCTIONPORT = TOOL_XDFB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_PDFB_DND_ABSTRACTFUNCTION = TOOL_XDFB_DND_ABSTRACTFUNCTION; // $NON-NLS-1$
  String TOOL_PDFB_DND_FUNCTION_FROM_EXPLORER = TOOL_XDFB_DND_FUNCTION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_PDFB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // PFBD
  String TOOL_PFBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // SAB
  String TOOL_SAB_DND_ABSTRACTFUNCTION_ALLOCATION = TOOL_XAB_DND_ABSTRACTFUNCTION_ALLOCATION; // $NON-NLS-1$
  String TOOL_SAB_DND_COMPONENTPORT = TOOL_XAB_DND_COMPONENTPORT; // $NON-NLS-1$
  String TOOL_SAB_DND_FUNCTIONPORT = TOOL_XAB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_SAB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_SAB_DND_ACTORS_FROM_EXPLORER = TOOL_DND_ACTORS_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_SAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER = TOOL_XAB_DND_FUNCTION_ALLOCATION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_SAB_DND_PHYSICALPORT = TOOL_XAB_DND_PHYSICALPORT; // $NON-NLS-1$

  // SDFB
  String TOOL_SDFB_DND_FUNCTIONPORT = TOOL_XDFB_DND_FUNCTIONPORT; // $NON-NLS-1$
  String TOOL_SDFB_DND_ABSTRACTFUNCTION = TOOL_XDFB_DND_ABSTRACTFUNCTION; // $NON-NLS-1$
  String TOOL_SDFB_DND_FUNCTION_FROM_EXPLORER = TOOL_XDFB_DND_FUNCTION_FROM_EXPLORER; // $NON-NLS-1$
  String TOOL_SDFB_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

  // SFBD
  String TOOL_SFBD_DND_CONSTRAINTS_FROM_EXPLORER = TOOL_DND_CONSTRAINTS_FROM_EXPLORER; // $NON-NLS-1$

}
