/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class ApplicationInstanceRunningTracker {
    public static final long TIMEOUT = 300000L;
    public static final long WAIT_TIME = 1000L;
    private final CloudFoundryServer cloudServer;
    private final String appName;
    private final long timeout;

    public ApplicationInstanceRunningTracker(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        this.appName = appModule.getDeployedApplicationName();
        this.timeout = 300000L;
    }

    public int track(IProgressMonitor monitor) throws CoreException {
        long currentTime = System.currentTimeMillis();
        long totalTime = currentTime + this.timeout;
        CloudFoundryApplicationModule appModule = this.cloudServer.getBehaviour().updateModuleWithAllCloudInfo(this.appName, monitor);
        this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_STARTING_TRACKING, (Object)this.appName), appModule);
        int state = appModule.getState();
        while (state != 2 && state != 4 && currentTime < totalTime) {
            appModule = this.cloudServer.getBehaviour().updateModuleWithAllCloudInfo(this.appName, monitor);
            if (appModule == null || appModule.getApplication() == null) {
                this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_NOT_EXISTS, (Object)this.appName), appModule);
                return 0;
            }
            if (monitor != null && monitor.isCanceled()) {
                this.printlnToConsole(NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_CHECK_CANCELED, (Object)this.appName), appModule);
                return 0;
            }
            state = appModule.getState();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            currentTime = System.currentTimeMillis();
        }
        String runningStateMessage = state == 2 ? NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_RUNNING, (Object)this.appName) : NLS.bind((String)Messages.ApplicationInstanceStartingTracker_APPLICATION_IS_NOT_RUNNING, (Object)this.appName);
        this.printlnToConsole(runningStateMessage, appModule);
        return state;
    }

    protected void printlnToConsole(String message, CloudFoundryApplicationModule appModule) throws CoreException {
        message = String.valueOf(message) + '\n';
        CloudFoundryPlugin.getCallback().printToConsole(this.cloudServer, appModule, message, false, false);
    }

    protected ApplicationStats getStats(IProgressMonitor monitor) throws CoreException {
        return this.cloudServer.getBehaviour().getApplicationStats(this.appName, monitor);
    }
}

