/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.debug.CloudFoundryProperties;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.DeleteServicesAction;
import org.eclipse.cft.server.ui.internal.actions.RefreshEditorAction;
import org.eclipse.cft.server.ui.internal.actions.RemapToProjectEditorAction;
import org.eclipse.cft.server.ui.internal.actions.ServiceToApplicationsBindingAction;
import org.eclipse.cft.server.ui.internal.actions.UnmapProjectEditorAction;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryApplicationsEditorPage;
import org.eclipse.cft.server.ui.internal.editor.CloudFoundryViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewerConfigurator;
import org.eclipse.cft.server.ui.internal.editor.ServiceViewerSorter;
import org.eclipse.cft.server.ui.internal.editor.ServicesTreeLabelProvider;
import org.eclipse.cft.server.ui.internal.editor.TreeContentProvider;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryServiceWizard;
import org.eclipse.cft.server.ui.internal.wizards.CloudRoutesWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.ServerLabelProvider;
import org.eclipse.wst.server.ui.internal.view.servers.RemoveModuleAction;
import org.eclipse.wst.server.ui.internal.view.servers.ServersViewDropAdapter;
import org.eclipse.wst.server.ui.internal.wizard.ModifyModulesWizard;

public class ApplicationMasterPart
extends SectionPart {
    private TableViewer applicationsViewer;
    private final CloudFoundryServer cloudServer;
    private IModule currentModule;
    private final CloudFoundryApplicationsEditorPage editorPage;
    private TableViewer servicesViewer;
    private FormToolkit toolkit;
    private boolean provideServices;
    private Section servicesSection;

    public ApplicationMasterPart(CloudFoundryApplicationsEditorPage editorPage, IManagedForm managedForm, Composite parent, CloudFoundryServer cloudServer) {
        super(parent, managedForm.getToolkit(), 386);
        this.editorPage = editorPage;
        this.cloudServer = cloudServer;
        this.toolkit = managedForm.getToolkit();
        this.provideServices = CloudFoundryBrandingExtensionPoint.getProvideServices((String)editorPage.getServer().getServerType().getId());
    }

    public void createContents() {
        this.createApplicationsSection();
        if (this.provideServices) {
            this.createServicesSection();
        }
        this.createRoutesDomainsSection();
    }

    public TableViewer getApplicationsViewer() {
        return this.applicationsViewer;
    }

    public IModule getCurrentModule() {
        return this.currentModule;
    }

    private void updateSections() {
        if (this.provideServices) {
            List<CFServiceInstance> services = this.editorPage.getServices();
            this.servicesViewer.setInput((Object)(services != null ? services.toArray() : null));
            if (this.servicesSection != null && !this.servicesSection.isExpanded()) {
                this.servicesSection.setExpanded(true);
            }
        }
    }

    public void refreshUI() {
        IStatus status = this.cloudServer.refreshCloudModules();
        this.applicationsViewer.setInput((Object)this.cloudServer.getServerOriginal().getModules());
        this.updateSections();
        if (this.editorPage != null && !this.editorPage.isDisposed()) {
            if (!status.isOK()) {
                this.editorPage.setErrorMessage(status.getMessage());
            } else {
                this.editorPage.setErrorMessage(null);
            }
        }
    }

    private void createApplicationsSection() {
        Section section = this.getSection();
        section.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        section.setText(Messages.COMMONTXT_APPLICATIONS);
        section.setDescription(Messages.ApplicationMasterPart_TEXT_APP_DESCRIP);
        section.setExpanded(true);
        Composite client = this.toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)client);
        section.setClient((Control)client);
        Composite headerComposite = this.toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.createControl(headerComposite);
        this.applicationsViewer = new TableViewer(this.toolkit.createTable(client, 0));
        this.applicationsViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.applicationsViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider(){

            public Image getImage(Object element) {
                Image image = super.getImage(element);
                if (element instanceof IModule) {
                    IModule module = (IModule)element;
                    CloudFoundryApplicationModule appModule = ApplicationMasterPart.this.editorPage.getCloudServer().getExistingCloudModule(module);
                    if (appModule != null && appModule.getStatus() != null && !appModule.getStatus().isOK()) {
                        if (appModule.getStatus().getSeverity() == 4) {
                            return CloudFoundryImages.getImage((ImageDescriptor)new DecorationOverlayIcon(image, CloudFoundryImages.OVERLAY_ERROR, 2));
                        }
                        if (appModule.getStatus().getSeverity() == 2) {
                            return CloudFoundryImages.getImage((ImageDescriptor)new DecorationOverlayIcon(image, CloudFoundryImages.OVERLAY_WARNING, 2));
                        }
                    }
                }
                return image;
            }

            public String getText(Object element) {
                String moduleName = super.getText(element);
                if (element instanceof IModule) {
                    String cfAppName;
                    IModule module = (IModule)element;
                    CloudFoundryApplicationModule appModule = ApplicationMasterPart.this.cloudServer.getExistingCloudModule((IModule)element);
                    if (appModule != null && (cfAppName = appModule.getDeployedApplicationName()) != null) {
                        moduleName = moduleName != null && !cfAppName.equals(moduleName) && CloudFoundryProperties.isModuleProjectAccessible.testProperty(new IModule[]{module}, ApplicationMasterPart.this.cloudServer) ? String.valueOf(cfAppName) + " (" + moduleName + ")" : cfAppName;
                    }
                }
                return moduleName;
            }
        });
        this.applicationsViewer.setInput((Object)new CloudApplication[0]);
        this.applicationsViewer.setSorter((ViewerSorter)new CloudFoundryViewerSorter());
        this.applicationsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IModule module = (IModule)selection.getFirstElement();
                if (ApplicationMasterPart.this.currentModule != module) {
                    ApplicationMasterPart.this.currentModule = module;
                    ApplicationMasterPart.this.getManagedForm().fireSelectionChanged((IFormPart)ApplicationMasterPart.this, (ISelection)selection);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).hint(250, -1).applyTo(this.applicationsViewer.getControl());
        int ops = 21;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        ApplicationViewersDropAdapter listener = new ApplicationViewersDropAdapter((Viewer)this.applicationsViewer);
        this.applicationsViewer.addDropSupport(ops, transfers, (DropTargetListener)listener);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationMasterPart.this.fillApplicationsContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.applicationsViewer.getControl());
        this.applicationsViewer.getControl().setMenu(menu);
        this.editorPage.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.applicationsViewer);
        Action addRemoveApplicationAction = new Action(Messages.ApplicationMasterPart_TEXT_ADD_REMOVE, ImageResource.getImageDescriptor((String)"IMG_ETOOL_MODIFY_MODULES")){

            public void run() {
                ModifyModulesWizard wizard = new ModifyModulesWizard(ApplicationMasterPart.this.cloudServer.getServerOriginal());
                WizardDialog dialog = new WizardDialog(ApplicationMasterPart.this.getSection().getShell(), (IWizard)wizard);
                dialog.open();
            }
        };
        toolBarManager.add((IAction)addRemoveApplicationAction);
        toolBarManager.add((IAction)RefreshEditorAction.getRefreshAction(this.editorPage, null));
        toolBarManager.update(true);
        section.setTextClient((Control)headerComposite);
        this.getManagedForm().getToolkit().paintBordersFor(client);
    }

    private void createRoutesDomainsSection() {
        Section routeSection = this.toolkit.createSection(this.getSection().getParent(), 258);
        routeSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)routeSection);
        routeSection.setText(Messages.ApplicationMasterPart_TEXT_ROUTES);
        routeSection.setExpanded(true);
        routeSection.clientVerticalSpacing = 0;
        Composite client = this.toolkit.createComposite((Composite)routeSection);
        client.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)client);
        routeSection.setClient((Control)client);
        Button button = this.toolkit.createButton(client, Messages.ApplicationMasterPart_TEXT_REMOVE_BUTTON, 8);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIJob uiJob = new UIJob(Messages.ApplicationMasterPart_JOB_REMOVE_ROUTE){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        CloudRoutesWizard wizard = new CloudRoutesWizard(ApplicationMasterPart.this.cloudServer);
                        WizardDialog dialog = new WizardDialog(ApplicationMasterPart.this.editorPage.getEditorSite().getShell(), (IWizard)wizard);
                        dialog.open();
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setSystem(true);
                uiJob.setPriority(10);
                uiJob.schedule();
            }
        });
    }

    private void createServicesSection() {
        this.servicesSection = this.toolkit.createSection(this.getSection().getParent(), 386);
        this.servicesSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.servicesSection);
        this.servicesSection.setText(Messages.COMMONTXT_SERVICES);
        this.servicesSection.setExpanded(true);
        this.servicesSection.setDescription(Messages.ApplicationMasterPart_TEXT_SERVICES_DESCRIP);
        Composite client = this.toolkit.createComposite((Composite)this.servicesSection);
        client.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)client);
        this.servicesSection.setClient((Control)client);
        Composite headerComposite = this.toolkit.createComposite((Composite)this.servicesSection, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.createControl(headerComposite);
        this.servicesViewer = new TableViewer(this.toolkit.createTable(client, 2));
        new ServiceViewerConfigurator().configureViewer(this.servicesViewer);
        this.servicesViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.servicesViewer.setLabelProvider((IBaseLabelProvider)new ServicesTreeLabelProvider(this.servicesViewer));
        this.servicesViewer.setSorter((ViewerSorter)new ServiceViewerSorter(this.servicesViewer));
        this.servicesViewer.setInput((Object)new CFServiceInstance[0]);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.servicesViewer.getControl());
        Action addServiceAction = new Action(Messages.COMMONTXT_ADD_SERVICE, CloudFoundryImages.NEW_SERVICE){

            public void run() {
                CloudFoundryServiceWizard wizard = new CloudFoundryServiceWizard(ApplicationMasterPart.this.cloudServer);
                WizardDialog dialog = new WizardDialog(ApplicationMasterPart.this.getSection().getShell(), (IWizard)wizard);
                wizard.setParent(dialog);
                dialog.setPageSize(900, 600);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        };
        toolBarManager.add((IAction)addServiceAction);
        toolBarManager.update(true);
        this.servicesSection.setTextClient((Control)headerComposite);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ApplicationMasterPart.this.fillServicesContextMenu(manager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.servicesViewer.getControl());
        this.servicesViewer.getControl().setMenu(menu);
        this.editorPage.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.servicesViewer);
        int ops = 1;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ApplicationMasterPart.this.servicesViewer.getSelection();
                event.data = selection.getFirstElement();
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
            }

            public void dragStart(DragSourceEvent event) {
                if (event.detail == 0 || event.detail == 16) {
                    event.detail = 1;
                }
                this.dragSetData(event);
            }
        };
        this.servicesViewer.addDragSupport(ops, transfers, (DragSourceListener)listener);
        this.getManagedForm().getToolkit().paintBordersFor(client);
    }

    private void fillServicesContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.servicesViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        manager.add((IAction)new DeleteServicesAction(selection, this.cloudServer.getBehaviour(), this.editorPage));
        if (selection.size() == 1) {
            manager.add((IAction)new ServiceToApplicationsBindingAction(selection, this.cloudServer.getBehaviour(), this.editorPage));
        }
    }

    private void fillApplicationsContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.applicationsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IModule module = (IModule)selection.getFirstElement();
        if (module != null) {
            manager.add((IAction)new RemoveModuleAction(this.getSection().getShell(), this.editorPage.getServer().getOriginal(), module));
            IProject project = module.getProject();
            if (project != null && project.isAccessible()) {
                manager.add((IAction)new UnmapProjectEditorAction(this.editorPage, module));
            } else if (project == null) {
                manager.add((IAction)new RemapToProjectEditorAction(this.editorPage, module));
            }
        }
    }

    private class ApplicationViewersDropAdapter
    extends ServersViewDropAdapter {
        public ApplicationViewersDropAdapter(Viewer viewer) {
            super(viewer);
        }

        protected Object getCurrentTarget() {
            return ApplicationMasterPart.this.editorPage.getServer().getOriginal();
        }

        protected Object determineTarget(DropTargetEvent event) {
            return ApplicationMasterPart.this.editorPage.getServer();
        }

        public boolean performDrop(final Object data) {
            UIJob job = new UIJob("Deploying application"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (data instanceof IStructuredSelection) {
                        CloudFoundryServer cloudServer;
                        Object modObj = ((IStructuredSelection)data).getFirstElement();
                        IProject prj = null;
                        if (modObj instanceof IProject) {
                            prj = (IProject)modObj;
                        } else if (modObj instanceof IJavaProject) {
                            prj = ((IJavaProject)modObj).getProject();
                        }
                        if (prj != null && (cloudServer = (CloudFoundryServer)ApplicationMasterPart.this.editorPage.getServer().getOriginal().loadAdapter(CloudFoundryServer.class, monitor)) != null) {
                            final String moduleName = prj.getName();
                            if (cloudServer.getBehaviour().existCloudApplicationModule(moduleName)) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openError((Shell)ApplicationMasterPart.this.editorPage.getSite().getShell(), (String)Messages.ApplicationMasterPart_ERROR_DEPLOY_FAIL_TITLE, (String)NLS.bind((String)Messages.ApplicationMasterPart_ERROR_DEPLOY_FAIL_BODY, (Object)moduleName));
                                    }
                                });
                                return Status.CANCEL_STATUS;
                            }
                            ApplicationViewersDropAdapter.super.performDrop(data);
                            Job job = new Job("Deploying application"){

                                protected IStatus run(IProgressMonitor monitor) {
                                    return cloudServer.getBehaviour().publishAdd(moduleName, monitor);
                                }
                            };
                            job.setPriority(10);
                            job.schedule();
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            job.schedule();
            return true;
        }
    }
}

