/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.jrebel;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.wst.server.core.IModule;
import org.osgi.framework.Bundle;

public class JRebelIntegrationUtility {
    public static boolean isJRebelEnabled(IModule module) {
        IProject project;
        IProject iProject = project = module != null ? module.getProject() : null;
        return project != null && project.isAccessible() && (JRebelIntegrationUtility.hasNature(project, "org.zeroturnaround.eclipse.remoting.remotingNature") || JRebelIntegrationUtility.hasNature(project, "org.zeroturnaround.eclipse.remotingNature")) && JRebelIntegrationUtility.hasNature(project, "org.zeroturnaround.eclipse.jrebelNature");
    }

    public static boolean hasNature(IProject project, String nature) {
        try {
            return project.hasNature(nature);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return false;
        }
    }

    public static void setAutoGeneratedXMLDisabledProperty(IProject project) throws CoreException {
        project.setPersistentProperty(new QualifiedName("org.zeroturnaround.eclipse.jrebel", "autoGenerateRebelXml"), "false");
    }

    public static Bundle getJRebelBundle() {
        Bundle bundle = null;
        try {
            bundle = Platform.getBundle((String)"org.zeroturnaround.eclipse.remoting");
            if (bundle == null) {
                bundle = Platform.getBundle((String)"org.zeroturnaround.eclipse");
            }
        }
        catch (Throwable e) {
            CloudFoundryPlugin.logError(e);
        }
        return bundle;
    }

    public static boolean isJRebelIDEInstalled() {
        return JRebelIntegrationUtility.getJRebelBundle() != null;
    }

    public static boolean isRemotingProject(Object remoteProjectObj) {
        return remoteProjectObj != null && (remoteProjectObj.getClass().getName().equals("org.zeroturnaround.eclipse.jrebel.remoting.RemotingProject") || remoteProjectObj.getClass().getName().equals("org.zeroturnaround.eclipse.jrebel.RemotingProject"));
    }

    public static Class<?> getRebelRemotingProvider(Bundle bundle) {
        Class providerClass = null;
        try {
            providerClass = bundle.loadClass("org.zeroturnaround.eclipse.jrebel.remoting.RebelRemotingProvider");
        }
        catch (Throwable throwable) {}
        if (providerClass == null) {
            try {
                providerClass = bundle.loadClass("org.zeroturnaround.eclipse.jrebel.RebelRemotingProvider");
            }
            catch (Throwable throwable) {}
        }
        if (providerClass == null) {
            CloudFoundryPlugin.logError("Unable to find a JRebel Remoting Provider. This version of CFT may not be compatible with the installed version of JRebel IDE.");
        }
        return providerClass;
    }
}

