/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CFCloudCredentials;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.V1CloudCredentials;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;

public class CloudServerUtil {
    private CloudServerUtil() {
    }

    public static List<CloudFoundryServer> getCloudServers() {
        IServer[] servers = ServerCore.getServers();
        HashSet<CloudFoundryServer> matchedServers = new HashSet<CloudFoundryServer>();
        if (servers != null) {
            IServer[] iServerArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                CloudFoundryServer cfServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
                if (cfServer != null) {
                    matchedServers.add(cfServer);
                }
                ++n2;
            }
        }
        return new ArrayList<CloudFoundryServer>(matchedServers);
    }

    public static CloudFoundryServer getCloudServer(String serverID) {
        IServer[] servers = ServerCore.getServers();
        if (servers == null) {
            return null;
        }
        CloudFoundryServer cfServer = null;
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            cfServer = (CloudFoundryServer)((Object)server.loadAdapter(CloudFoundryServer.class, null));
            if (cfServer != null && cfServer.getServerId().equals(serverID)) break;
            ++n2;
        }
        return cfServer;
    }

    public static CloudFoundryServer getCloudServer(IServer server) throws CoreException {
        CloudFoundryServer cfServer = (CloudFoundryServer)((Object)server.getAdapter(CloudFoundryServer.class));
        if (cfServer == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.CloudServerUtil_NOT_CLOUD_SERVER_ERROR, (Object)server.getName(), (Object)server.getId()));
        }
        return cfServer;
    }

    public static boolean isCloudFoundryServer(IServer server) {
        if (server != null) {
            return CloudServerUtil.isCloudFoundryServerType(server.getServerType());
        }
        return false;
    }

    public static CloudFoundryApplicationModule getCloudModule(IModule module, IServer server) {
        if (module == null) {
            return null;
        }
        try {
            CloudFoundryServer cloudServer = CloudServerUtil.getCloudServer(server);
            CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
            return appModule;
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError(e);
            return null;
        }
    }

    public static CloudFoundryApplicationModule getExistingCloudModule(IModule module, IServer server) throws CoreException {
        CloudFoundryApplicationModule appMod = CloudServerUtil.getCloudModule(module, server);
        if (appMod == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.CloudServerUtil_NO_CLOUD_MODULE_FOUND, (Object)module.getName(), (Object)server.getId()));
        }
        return appMod;
    }

    public static boolean isCloudFoundryServerType(IServerType serverType) {
        if (serverType != null) {
            String serverId = serverType.getId();
            return CloudFoundryBrandingExtensionPoint.getServerTypeIds().contains(serverId);
        }
        return false;
    }

    public static CFCloudCredentials getCredentials(CloudFoundryServer cloudServer) throws CoreException {
        CloudCredentials v1Credentials = null;
        if (cloudServer.isSso()) {
            v1Credentials = CloudUtil.createSsoCredentials(cloudServer.getPasscode(), cloudServer.getToken());
        } else {
            String userName = cloudServer.getUsername();
            String password = cloudServer.getPassword();
            v1Credentials = new CloudCredentials(userName, password);
        }
        return new V1CloudCredentials(v1Credentials);
    }

    public static IProxyData getProxy(URL url) {
        IProxyService proxyService;
        if (url == null) {
            return null;
        }
        CloudFoundryPlugin plugin = CloudFoundryPlugin.getDefault();
        if (plugin != null && (proxyService = plugin.getProxyService()) != null) {
            IProxyData[] selectedProxies;
            block5: {
                try {
                    selectedProxies = proxyService.select(url.toURI());
                    if (selectedProxies != null && selectedProxies.length != 0) break block5;
                    return null;
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return selectedProxies[0];
        }
        return null;
    }
}

