/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.net.URI;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.ModuleCache;
import org.eclipse.cft.server.core.internal.ValueValidationUtil;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.WizardPartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationWizard;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryDeploymentWizardPage;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CloudFoundryApplicationWizardPage
extends PartsWizardPage {
    private Pattern VALID_CHARS = Pattern.compile("[A-Za-z\\$_0-9\\-]+");
    protected static final String DEFAULT_DESCRIPTION = Messages.CloudFoundryApplicationWizardPage_TEXT_SET_APP_DETAIL;
    private String appName;
    private String buildpack;
    private Text buildpackText;
    private String serverTypeId;
    protected final CloudFoundryServer server;
    protected final CloudFoundryApplicationModule module;
    protected String filePath;
    protected final ApplicationWizardDescriptor descriptor;

    public CloudFoundryApplicationWizardPage(CloudFoundryServer server, CloudFoundryDeploymentWizardPage deploymentPage, CloudFoundryApplicationModule module, ApplicationWizardDescriptor descriptor) {
        super(Messages.CloudFoundryApplicationWizardPage_TEXT_DEPLOY_WIZ, null, null);
        this.server = server;
        this.module = module;
        this.descriptor = descriptor;
        this.serverTypeId = module.getServerTypeId();
    }

    public CloudFoundryApplicationWizardPage(CloudFoundryServer server, CloudFoundryApplicationModule module, ApplicationWizardDescriptor descriptor) {
        super(Messages.CloudFoundryApplicationWizardPage_TEXT_DEPLOY_WIZ, null, null);
        this.server = server;
        this.module = module;
        this.descriptor = descriptor;
        this.serverTypeId = module.getServerTypeId();
    }

    protected void init() {
        this.appName = this.descriptor.getDeploymentInfo().getDeploymentName();
        this.buildpack = this.descriptor.getDeploymentInfo().getStaging() != null ? this.descriptor.getDeploymentInfo().getStaging().getBuildpackUrl() : null;
    }

    protected CloudFoundryApplicationWizard getApplicationWizard() {
        return (CloudFoundryApplicationWizard)this.getWizard();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.CloudFoundryApplicationWizardPage_TITLE_APP_DETAIL);
        this.setDescription(DEFAULT_DESCRIPTION);
        ImageDescriptor banner = CloudFoundryImages.getWizardBanner(this.serverTypeId);
        if (banner != null) {
            this.setImageDescriptor(banner);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    protected Composite createContents(Composite parent) {
        Composite composite = this.preCreateContents(parent);
        this.createManifestSection(composite);
        return composite;
    }

    protected Composite preCreateContents(Composite parent) {
        this.init();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        AppNamePart appPart = new AppNamePart();
        appPart.addPartChangeListener(this);
        ((UIPart)appPart).createPart(composite);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        nameLabel.setText(Messages.CloudFoundryApplicationWizardPage_LABEL_BUILDPACK);
        this.buildpackText = new Text(composite, 2048);
        if (this.buildpack != null) {
            this.buildpackText.setText(this.buildpack);
        }
        this.buildpackText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.buildpackText.setEditable(true);
        this.buildpackText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudFoundryApplicationWizardPage.this.buildpack = CloudFoundryApplicationWizardPage.this.buildpackText.getText().trim();
                CloudFoundryApplicationWizardPage.this.validateBuildPack();
            }
        });
        return composite;
    }

    protected void createManifestSection(Composite composite) {
        Label emptyLabel = new Label(composite, 0);
        emptyLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        final Button saveToManifest = new Button(composite, 32);
        saveToManifest.setText(Messages.CloudFoundryApplicationWizardPage_BUTTON_SAVE_MANIFEST);
        saveToManifest.setToolTipText(Messages.CloudFoundryApplicationWizardPage_TEXT_SAVE_MANIFEST_TOOLTIP);
        saveToManifest.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        saveToManifest.setSelection(false);
        saveToManifest.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudFoundryApplicationWizardPage.this.descriptor.persistDeploymentInfo(saveToManifest.getSelection());
            }
        });
    }

    protected void validateBuildPack() {
        IStatus status = Status.OK_STATUS;
        this.descriptor.setBuildpack(null);
        if (!ValueValidationUtil.isEmpty((String)this.buildpack)) {
            try {
                String host;
                URI uriObject = URI.create(this.buildpack);
                if (uriObject.isAbsolute() && ((host = uriObject.getHost()) == null || host.length() == 0)) {
                    status = CloudFoundryPlugin.getErrorStatus((String)Messages.COMMONTXT_ENTER_VALID_URL);
                }
                if (status.isOK()) {
                    this.descriptor.setBuildpack(this.buildpack);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                status = CloudFoundryPlugin.getErrorStatus((String)Messages.COMMONTXT_ENTER_VALID_URL);
            }
        }
        this.handleChange(new PartChangeEvent(this.buildpack, status, CloudUIEvent.BUILD_PACK_URL));
    }

    protected IStatus getUpdateNameStatus() {
        IStatus status = Status.OK_STATUS;
        if (ValueValidationUtil.isEmpty((String)this.appName)) {
            status = CloudFoundryPlugin.getStatus((String)Messages.CloudFoundryApplicationWizardPage_ERROR_MISSING_APPNAME, (int)4);
        } else {
            Matcher matcher = this.VALID_CHARS.matcher(this.appName);
            if (!matcher.matches()) {
                status = CloudFoundryPlugin.getErrorStatus((String)Messages.CloudFoundryApplicationWizardPage_ERROR_INVALID_CHAR);
            } else {
                ModuleCache moduleCache = CloudFoundryPlugin.getModuleCache();
                ModuleCache.ServerData data = moduleCache.getData(this.server.getServerOriginal());
                Collection applications = data.getExistingCloudModules();
                boolean duplicate = false;
                for (CloudFoundryApplicationModule application : applications) {
                    if (application == this.module || !application.getDeployedApplicationName().equals(this.appName)) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) {
                    status = CloudFoundryPlugin.getErrorStatus((String)Messages.CloudFoundryApplicationWizardPage_ERROR_NAME_CONFLICT);
                }
            }
        }
        return status;
    }

    protected class AppNamePart
    extends UIPart {
        private Text nameText;

        protected AppNamePart() {
        }

        @Override
        public Control createPart(Composite parent) {
            Label nameLabel = new Label(parent, 0);
            nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            nameLabel.setText(Messages.COMMONTXT_NAME_WITH_COLON);
            this.nameText = new Text(parent, 2048);
            this.nameText.setLayoutData((Object)new GridData(4, 4, true, false));
            this.nameText.setEditable(true);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CloudFoundryApplicationWizardPage.this.appName = AppNamePart.this.nameText.getText();
                    ((AppNamePart)AppNamePart.this).CloudFoundryApplicationWizardPage.this.descriptor.getDeploymentInfo().setDeploymentName(CloudFoundryApplicationWizardPage.this.appName);
                    boolean updateButtons = true;
                    AppNamePart.this.notifyChange(new WizardPartChangeEvent((Object)CloudFoundryApplicationWizardPage.this.appName, CloudFoundryApplicationWizardPage.this.getUpdateNameStatus(), CloudUIEvent.APP_NAME_CHANGE_EVENT, updateButtons));
                }
            });
            if (CloudFoundryApplicationWizardPage.this.appName != null) {
                this.nameText.setText(CloudFoundryApplicationWizardPage.this.appName);
            }
            return parent;
        }
    }
}

