/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.ArrayList;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.AbsoluteOrder;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.tribes.group.interceptors.TcpPingInterceptor;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class StaticMembershipInterceptor
extends ChannelInterceptorBase {
    private static final Log log = LogFactory.getLog(StaticMembershipInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(StaticMembershipInterceptor.class.getPackage().getName());
    protected final ArrayList<Member> members = new ArrayList();
    protected Member localMember = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStaticMember(Member member) {
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            if (!this.members.contains(member)) {
                this.members.add(member);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStaticMember(Member member) {
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            if (this.members.contains(member)) {
                this.members.remove(member);
            }
        }
    }

    public void setLocalMember(Member member) {
        this.localMember = member;
    }

    @Override
    public boolean hasMembers() {
        return super.hasMembers() || this.members.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Member[] getMembers() {
        if (this.members.size() == 0) {
            return super.getMembers();
        }
        ArrayList<Member> arrayList = this.members;
        synchronized (arrayList) {
            int i;
            Member[] others = super.getMembers();
            Member[] result = new Member[this.members.size() + others.length];
            for (i = 0; i < others.length; ++i) {
                result[i] = others[i];
            }
            for (i = 0; i < this.members.size(); ++i) {
                result[i + others.length] = this.members.get(i);
            }
            AbsoluteOrder.absoluteOrder(result);
            return result;
        }
    }

    @Override
    public Member getMember(Member mbr) {
        if (this.members.contains(mbr)) {
            return this.members.get(this.members.indexOf(mbr));
        }
        return super.getMember(mbr);
    }

    @Override
    public Member getLocalMember(boolean incAlive) {
        if (this.localMember != null) {
            return this.localMember;
        }
        return super.getLocalMember(incAlive);
    }

    @Override
    public void start(int svc) throws ChannelException {
        if ((1 & svc) == 1) {
            super.start(1);
        }
        if ((2 & svc) == 2) {
            super.start(2);
        }
        final Member[] mbrs = this.members.toArray(new Member[this.members.size()]);
        final StaticMembershipInterceptor base = this;
        Thread t = new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < mbrs.length; ++i) {
                    base.memberAdded(mbrs[i]);
                }
            }
        };
        t.start();
        super.start(svc & 0xFFFFFFFE & 0xFFFFFFFD);
        TcpFailureDetector failureDetector = null;
        TcpPingInterceptor pingInterceptor = null;
        for (ChannelInterceptor prev = this.getPrevious(); prev != null; prev = prev.getPrevious()) {
            if (prev instanceof TcpFailureDetector) {
                failureDetector = (TcpFailureDetector)prev;
            }
            if (!(prev instanceof TcpPingInterceptor)) continue;
            pingInterceptor = (TcpPingInterceptor)prev;
        }
        if (failureDetector == null) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.no.failureDetector"));
        }
        if (pingInterceptor == null) {
            log.warn((Object)sm.getString("staticMembershipInterceptor.no.pingInterceptor"));
        }
    }
}

