/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=root

/**
 * Localized names for the "mn" locale.
 */
public class LocalizedNamesImpl_mn extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "VI",
        "UM",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "US",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AE",
        "AR",
        "AM",
        "AW",
        "AC",
        "AF",
        "MO",
        "HK",
        "BS",
        "NP",
        "BD",
        "BB",
        "EH",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BG",
        "BO",
        "BA",
        "BW",
        "BR",
        "VG",
        "IO",
        "BN",
        "BV",
        "BF",
        "BI",
        "BT",
        "DO",
        "CZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GG",
        "GI",
        "NL",
        "HN",
        "GR",
        "GD",
        "GL",
        "GU",
        "GE",
        "DK",
        "DJ",
        "DG",
        "DM",
        "EU",
        "EG",
        "JE",
        "ZM",
        "ZW",
        "CX",
        "IL",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "GB",
        "YE",
        "JO",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "BQ",
        "QA",
        "KE",
        "CY",
        "KI",
        "CP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "KW",
        "CW",
        "KG",
        "CK",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MR",
        "MU",
        "MG",
        "YT",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "FM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MM",
        "IM",
        "NA",
        "NR",
        "NE",
        "NG",
        "NI",
        "NU",
        "QO",
        "NO",
        "NF",
        "OM",
        "RU",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PT",
        "PR",
        "RE",
        "RW",
        "RO",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SC",
        "SN",
        "BL",
        "KN",
        "LC",
        "MF",
        "SH",
        "RS",
        "EA",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "SB",
        "SO",
        "SD",
        "SR",
        "SL",
        "VC",
        "PM",
        "TJ",
        "TW",
        "TH",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TR",
        "TC",
        "TM",
        "CF",
        "UG",
        "UZ",
        "UA",
        "HU",
        "WF",
        "UY",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "MP",
        "KP",
        "HR",
        "HM",
        "CN",
        "TD",
        "CL",
        "SE",
        "CH",
        "NZ",
        "NC",
        "LK",
        "EC",
        "GQ",
        "SV",
        "IN",
        "ER",
        "EE",
        "ET",
        "JM",
        "JP",
        "ZA",
        "GS",
        "KR",
        "SS",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Дэлхий");
    namesMap.put("002", "Африк");
    namesMap.put("003", "Хойд Америк");
    namesMap.put("005", "Өмнөд Америк");
    namesMap.put("009", "Номхон далайн орнууд");
    namesMap.put("011", "Баруун Африк");
    namesMap.put("013", "Төв Америк");
    namesMap.put("014", "Зүүн Африк");
    namesMap.put("015", "Хойд Африк");
    namesMap.put("017", "Төв Африк");
    namesMap.put("018", "Өмнөд Африк");
    namesMap.put("019", "Америк");
    namesMap.put("021", "Хойд Америк тив");
    namesMap.put("029", "Карибын");
    namesMap.put("030", "Зүүн Ази");
    namesMap.put("034", "Өмнөд Ази");
    namesMap.put("035", "Зүүн Өмнөд Ази");
    namesMap.put("039", "Өмнөд Европ");
    namesMap.put("053", "Австралиази");
    namesMap.put("054", "Меланези");
    namesMap.put("057", "Микронезийн бүс");
    namesMap.put("061", "Полинез");
    namesMap.put("142", "Ази");
    namesMap.put("143", "Төв Ази");
    namesMap.put("145", "Баруун Ази");
    namesMap.put("150", "Европ");
    namesMap.put("151", "Зүүн Европ");
    namesMap.put("154", "Хойд Европ");
    namesMap.put("155", "Баруун Европ");
    namesMap.put("419", "Латин Америк");
    namesMap.put("AC", "Аскенсион Арал");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "Арабын Нэгдсэн Эмират");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа ба Барбуда");
    namesMap.put("AI", "Ангила");
    namesMap.put("AL", "Албани");
    namesMap.put("AM", "Армен");
    namesMap.put("AO", "Ангол");
    namesMap.put("AQ", "Антарктик");
    namesMap.put("AR", "Аргентин");
    namesMap.put("AS", "Америкийн Самоа");
    namesMap.put("AT", "Австри");
    namesMap.put("AU", "Австрали");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландын Арлууд");
    namesMap.put("AZ", "Азербайжан");
    namesMap.put("BA", "Босни Херцеговин");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белги");
    namesMap.put("BF", "Буркина фасо");
    namesMap.put("BG", "Болгар");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сент Бартельми");
    namesMap.put("BM", "Бермуд");
    namesMap.put("BN", "Бруней");
    namesMap.put("BO", "Боливи");
    namesMap.put("BQ", "Карибын Нидерланд");
    namesMap.put("BR", "Бразил");
    namesMap.put("BS", "Багам");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Буветын Арлууд");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларус");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канад");
    namesMap.put("CC", "Кокос (Кийлинг) Арлууд");
    namesMap.put("CD", "Конго-Киншаса");
    namesMap.put("CF", "Төв Африкийн Бүгд Найрамдах Улс");
    namesMap.put("CG", "Конго Браззавиль");
    namesMap.put("CH", "Швейцари");
    namesMap.put("CI", "Кот д'Ивуар");
    namesMap.put("CK", "Күүкийн Арлууд");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Хятад");
    namesMap.put("CO", "Колумб");
    namesMap.put("CP", "Клиппертон Арал");
    namesMap.put("CR", "Коста Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Капе Верде");
    namesMap.put("CW", "Куракао");
    namesMap.put("CX", "Зул Сарын Арал");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Бүгд Найрамдах Чех Улс");
    namesMap.put("DE", "Герман");
    namesMap.put("DG", "Диего Гарсиа");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дани");
    namesMap.put("DM", "Доминик");
    namesMap.put("DO", "Бүгд Найрамдах Доминикан");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута ба Мелилья");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстон");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Баруун Сахар");
    namesMap.put("ER", "Эритри");
    namesMap.put("ES", "Испани");
    namesMap.put("ET", "Этиоп");
    namesMap.put("EU", "Европын Холбоо");
    namesMap.put("FI", "Финланд");
    namesMap.put("FJ", "Фижи");
    namesMap.put("FK", "Фолькландын Арлууд");
    namesMap.put("FM", "Микронези");
    namesMap.put("FO", "Фароэ Арлууд");
    namesMap.put("FR", "Франц");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Их Британи");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Гүрж");
    namesMap.put("GF", "Францын Гайана");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренланд");
    namesMap.put("GM", "Гамби");
    namesMap.put("GN", "Гвиней");
    namesMap.put("GP", "Гваделуп");
    namesMap.put("GQ", "Экваторын Гвиней");
    namesMap.put("GR", "Грек");
    namesMap.put("GS", "Өмнөд Жоржиа ба Өмнөд Сэндвичийн Арлууд");
    namesMap.put("GT", "Гватемал");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвиней-Бисау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "БНХАУ-ын Тусгай захиргааны бүс Хонг Конг");
    namesMap.put("HM", "Хэрд болон Макдоналд Арлууд");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорват");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Унгар");
    namesMap.put("IC", "Канарын арлууд");
    namesMap.put("ID", "Индонези");
    namesMap.put("IE", "Ирланд");
    namesMap.put("IL", "Израиль");
    namesMap.put("IM", "Мэн Арал");
    namesMap.put("IN", "Энэтхэг");
    namesMap.put("IO", "Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэрүүд");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исланд");
    namesMap.put("IT", "Итали");
    namesMap.put("JE", "Жерси");
    namesMap.put("JM", "Ямайк");
    namesMap.put("JO", "Йордан");
    namesMap.put("JP", "Япон");
    namesMap.put("KE", "Кени");
    namesMap.put("KG", "Кыргызстан");
    namesMap.put("KH", "Камбож");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморос");
    namesMap.put("KN", "Сент-Киттс ба Невис");
    namesMap.put("KP", "Хойд Солонгос");
    namesMap.put("KR", "Өмнөд Солонгос");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Кайманы Арлууд");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент Люсиа");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либери");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латви");
    namesMap.put("LY", "Ливи");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдав");
    namesMap.put("ME", "Монтенегро");
    namesMap.put("MF", "Сент-Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршаллын Арлууд");
    namesMap.put("MK", "Македон");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мьянмар (Бурма)");
    namesMap.put("MN", "Монгол");
    namesMap.put("MO", "БНХАУ-ын Тусгай захиргааны бүс Макао");
    namesMap.put("MP", "Хойд Марианы Арлууд");
    namesMap.put("MQ", "Мартиник");
    namesMap.put("MR", "Мавритани");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Мавритус");
    namesMap.put("MV", "Мальдив");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексик");
    namesMap.put("MY", "Малайз");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намиби");
    namesMap.put("NC", "Шинэ Каледони");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Норфолк Арлууд");
    namesMap.put("NG", "Нигери");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Голланд");
    namesMap.put("NO", "Норвеги");
    namesMap.put("NP", "Балба");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуэ");
    namesMap.put("NZ", "Шинэ Зеланд");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панам");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Францын Полинез");
    namesMap.put("PG", "Папуа Шинэ Гвиней");
    namesMap.put("PH", "Филиппин");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польш");
    namesMap.put("PM", "Сэнт Пьер ба Микелон");
    namesMap.put("PN", "Питкэрн Арлууд");
    namesMap.put("PR", "Пуэрто Рико");
    namesMap.put("PS", "Палестины нутаг дэвсгэрүүд");
    namesMap.put("PT", "Португал");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Номхон далайг тойрсон улс орнууд");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Румын");
    namesMap.put("RS", "Серби");
    namesMap.put("RU", "Орос");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудын Араб");
    namesMap.put("SB", "Соломоны Арлууд");
    namesMap.put("SC", "Сейшел");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швед");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Сент Хелена");
    namesMap.put("SI", "Словени");
    namesMap.put("SJ", "Свалбард ба Ян Майен");
    namesMap.put("SK", "Словак");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Өмнөд Судан");
    namesMap.put("ST", "Сан-Томе ба Принсипи");
    namesMap.put("SV", "Эль Сальвадор");
    namesMap.put("SX", "Синт Мартен");
    namesMap.put("SY", "Сири");
    namesMap.put("SZ", "Свазиланд");
    namesMap.put("TA", "Тристан да Кунья");
    namesMap.put("TC", "Турк ба Кайкосын Арлууд");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Францын өмнөд газар нутаг");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тайланд");
    namesMap.put("TJ", "Тажикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Тимор-Лесте");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турк");
    namesMap.put("TT", "Тринидад ба Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайван");
    namesMap.put("TZ", "Танзани");
    namesMap.put("UA", "Украйн");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "АНУ-ын тойрсон арлууд");
    namesMap.put("US", "Америкийн Нэгдсэн Улс");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан хот улс");
    namesMap.put("VC", "Сэнт Винсэнт ба Гренадин");
    namesMap.put("VE", "Венесуэл");
    namesMap.put("VG", "Британийн Виржиний Арлууд");
    namesMap.put("VI", "АНУ-ын Виржиний Арлууд");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис ба Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майотте");
    namesMap.put("ZA", "Өмнөд Африк тив");
    namesMap.put("ZM", "Замби");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Тодорхойгүй");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Дэлхий",
        "002": "Африк",
        "003": "Хойд Америк",
        "005": "Өмнөд Америк",
        "009": "Номхон далайн орнууд",
        "011": "Баруун Африк",
        "013": "Төв Америк",
        "014": "Зүүн Африк",
        "015": "Хойд Африк",
        "017": "Төв Африк",
        "018": "Өмнөд Африк",
        "019": "Америк",
        "021": "Хойд Америк тив",
        "029": "Карибын",
        "030": "Зүүн Ази",
        "034": "Өмнөд Ази",
        "035": "Зүүн Өмнөд Ази",
        "039": "Өмнөд Европ",
        "053": "Австралиази",
        "054": "Меланези",
        "057": "Микронезийн бүс",
        "061": "Полинез",
        "142": "Ази",
        "143": "Төв Ази",
        "145": "Баруун Ази",
        "150": "Европ",
        "151": "Зүүн Европ",
        "154": "Хойд Европ",
        "155": "Баруун Европ",
        "419": "Латин Америк",
        "AC": "Аскенсион Арал",
        "AD": "Андорра",
        "AE": "Арабын Нэгдсэн Эмират",
        "AF": "Афганистан",
        "AG": "Антигуа ба Барбуда",
        "AI": "Ангила",
        "AL": "Албани",
        "AM": "Армен",
        "AO": "Ангол",
        "AQ": "Антарктик",
        "AR": "Аргентин",
        "AS": "Америкийн Самоа",
        "AT": "Австри",
        "AU": "Австрали",
        "AW": "Аруба",
        "AX": "Аландын Арлууд",
        "AZ": "Азербайжан",
        "BA": "Босни Херцеговин",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белги",
        "BF": "Буркина фасо",
        "BG": "Болгар",
        "BH": "Бахрейн",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сент Бартельми",
        "BM": "Бермуд",
        "BN": "Бруней",
        "BO": "Боливи",
        "BQ": "Карибын Нидерланд",
        "BR": "Бразил",
        "BS": "Багам",
        "BT": "Бутан",
        "BV": "Буветын Арлууд",
        "BW": "Ботсвана",
        "BY": "Беларус",
        "BZ": "Белиз",
        "CA": "Канад",
        "CC": "Кокос (Кийлинг) Арлууд",
        "CD": "Конго-Киншаса",
        "CF": "Төв Африкийн Бүгд Найрамдах Улс",
        "CG": "Конго Браззавиль",
        "CH": "Швейцари",
        "CI": "Кот д'Ивуар",
        "CK": "Күүкийн Арлууд",
        "CL": "Чили",
        "CM": "Камерун",
        "CN": "Хятад",
        "CO": "Колумб",
        "CP": "Клиппертон Арал",
        "CR": "Коста Рика",
        "CU": "Куба",
        "CV": "Капе Верде",
        "CW": "Куракао",
        "CX": "Зул Сарын Арал",
        "CY": "Кипр",
        "CZ": "Бүгд Найрамдах Чех Улс",
        "DE": "Герман",
        "DG": "Диего Гарсиа",
        "DJ": "Джибути",
        "DK": "Дани",
        "DM": "Доминик",
        "DO": "Бүгд Найрамдах Доминикан",
        "DZ": "Алжир",
        "EA": "Сеута ба Мелилья",
        "EC": "Эквадор",
        "EE": "Эстон",
        "EG": "Египет",
        "EH": "Баруун Сахар",
        "ER": "Эритри",
        "ES": "Испани",
        "ET": "Этиоп",
        "EU": "Европын Холбоо",
        "FI": "Финланд",
        "FJ": "Фижи",
        "FK": "Фолькландын Арлууд",
        "FM": "Микронези",
        "FO": "Фароэ Арлууд",
        "FR": "Франц",
        "GA": "Габон",
        "GB": "Их Британи",
        "GD": "Гренада",
        "GE": "Гүрж",
        "GF": "Францын Гайана",
        "GG": "Гернси",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренланд",
        "GM": "Гамби",
        "GN": "Гвиней",
        "GP": "Гваделуп",
        "GQ": "Экваторын Гвиней",
        "GR": "Грек",
        "GS": "Өмнөд Жоржиа ба Өмнөд Сэндвичийн Арлууд",
        "GT": "Гватемал",
        "GU": "Гуам",
        "GW": "Гвиней-Бисау",
        "GY": "Гайана",
        "HK": "БНХАУ-ын Тусгай захиргааны бүс Хонг Конг",
        "HM": "Хэрд болон Макдоналд Арлууд",
        "HN": "Гондурас",
        "HR": "Хорват",
        "HT": "Гаити",
        "HU": "Унгар",
        "IC": "Канарын арлууд",
        "ID": "Индонези",
        "IE": "Ирланд",
        "IL": "Израиль",
        "IM": "Мэн Арал",
        "IN": "Энэтхэг",
        "IO": "Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэрүүд",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исланд",
        "IT": "Итали",
        "JE": "Жерси",
        "JM": "Ямайк",
        "JO": "Йордан",
        "JP": "Япон",
        "KE": "Кени",
        "KG": "Кыргызстан",
        "KH": "Камбож",
        "KI": "Кирибати",
        "KM": "Коморос",
        "KN": "Сент-Киттс ба Невис",
        "KP": "Хойд Солонгос",
        "KR": "Өмнөд Солонгос",
        "KW": "Кувейт",
        "KY": "Кайманы Арлууд",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Ливан",
        "LC": "Сент Люсиа",
        "LI": "Лихтенштейн",
        "LK": "Шри Ланка",
        "LR": "Либери",
        "LS": "Лесото",
        "LT": "Литва",
        "LU": "Люксембург",
        "LV": "Латви",
        "LY": "Ливи",
        "MA": "Марокко",
        "MC": "Монако",
        "MD": "Молдав",
        "ME": "Монтенегро",
        "MF": "Сент-Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршаллын Арлууд",
        "MK": "Македон",
        "ML": "Мали",
        "MM": "Мьянмар (Бурма)",
        "MN": "Монгол",
        "MO": "БНХАУ-ын Тусгай захиргааны бүс Макао",
        "MP": "Хойд Марианы Арлууд",
        "MQ": "Мартиник",
        "MR": "Мавритани",
        "MS": "Монтсеррат",
        "MT": "Мальта",
        "MU": "Мавритус",
        "MV": "Мальдив",
        "MW": "Малави",
        "MX": "Мексик",
        "MY": "Малайз",
        "MZ": "Мозамбик",
        "NA": "Намиби",
        "NC": "Шинэ Каледони",
        "NE": "Нигер",
        "NF": "Норфолк Арлууд",
        "NG": "Нигери",
        "NI": "Никарагуа",
        "NL": "Голланд",
        "NO": "Норвеги",
        "NP": "Балба",
        "NR": "Науру",
        "NU": "Ниуэ",
        "NZ": "Шинэ Зеланд",
        "OM": "Оман",
        "PA": "Панам",
        "PE": "Перу",
        "PF": "Францын Полинез",
        "PG": "Папуа Шинэ Гвиней",
        "PH": "Филиппин",
        "PK": "Пакистан",
        "PL": "Польш",
        "PM": "Сэнт Пьер ба Микелон",
        "PN": "Питкэрн Арлууд",
        "PR": "Пуэрто Рико",
        "PS": "Палестины нутаг дэвсгэрүүд",
        "PT": "Португал",
        "PW": "Палау",
        "PY": "Парагвай",
        "QA": "Катар",
        "QO": "Номхон далайг тойрсон улс орнууд",
        "RE": "Реюньон",
        "RO": "Румын",
        "RS": "Серби",
        "RU": "Орос",
        "RW": "Руанда",
        "SA": "Саудын Араб",
        "SB": "Соломоны Арлууд",
        "SC": "Сейшел",
        "SD": "Судан",
        "SE": "Швед",
        "SG": "Сингапур",
        "SH": "Сент Хелена",
        "SI": "Словени",
        "SJ": "Свалбард ба Ян Майен",
        "SK": "Словак",
        "SL": "Сьерра-Леоне",
        "SM": "Сан-Марино",
        "SN": "Сенегал",
        "SO": "Сомали",
        "SR": "Суринам",
        "SS": "Өмнөд Судан",
        "ST": "Сан-Томе ба Принсипи",
        "SV": "Эль Сальвадор",
        "SX": "Синт Мартен",
        "SY": "Сири",
        "SZ": "Свазиланд",
        "TA": "Тристан да Кунья",
        "TC": "Турк ба Кайкосын Арлууд",
        "TD": "Чад",
        "TF": "Францын өмнөд газар нутаг",
        "TG": "Того",
        "TH": "Тайланд",
        "TJ": "Тажикистан",
        "TK": "Токелау",
        "TL": "Тимор-Лесте",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турк",
        "TT": "Тринидад ба Тобаго",
        "TV": "Тувалу",
        "TW": "Тайван",
        "TZ": "Танзани",
        "UA": "Украйн",
        "UG": "Уганда",
        "UM": "АНУ-ын тойрсон арлууд",
        "US": "Америкийн Нэгдсэн Улс",
        "UY": "Уругвай",
        "UZ": "Узбекистан",
        "VA": "Ватикан хот улс",
        "VC": "Сэнт Винсэнт ба Гренадин",
        "VE": "Венесуэл",
        "VG": "Британийн Виржиний Арлууд",
        "VI": "АНУ-ын Виржиний Арлууд",
        "VN": "Вьетнам",
        "VU": "Вануату",
        "WF": "Уоллис ба Футуна",
        "WS": "Самоа",
        "XK": "Косово",
        "YE": "Йемен",
        "YT": "Майотте",
        "ZA": "Өмнөд Африк тив",
        "ZM": "Замби",
        "ZW": "Зимбабве",
        "ZZ": "Тодорхойгүй"
    };
  }-*/;
}
