/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable;

import org.eclipse.collections.api.factory.stack.ImmutableStackFactory;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.impl.stack.immutable.ImmutableArrayStack;

public class ImmutableStackFactoryImpl
implements ImmutableStackFactory {
    public static final ImmutableStackFactory INSTANCE = new ImmutableStackFactoryImpl();

    @Override
    public <T> ImmutableStack<T> empty() {
        return ImmutableArrayStack.newStack();
    }

    @Override
    public <T> ImmutableStack<T> of() {
        return this.empty();
    }

    @Override
    public <T> ImmutableStack<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableStack<T> of(T element) {
        return this.with(element);
    }

    @Override
    public <T> ImmutableStack<T> with(T element) {
        return ImmutableArrayStack.newStackWith(element);
    }

    @Override
    public <T> ImmutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    @Override
    public <T> ImmutableStack<T> with(T ... elements) {
        return ImmutableArrayStack.newStackWith(elements);
    }

    @Override
    public <T> ImmutableStack<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableStack<T> withAll(Iterable<? extends T> items) {
        return ImmutableArrayStack.newStack(items);
    }

    @Override
    public <T> ImmutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    @Override
    public <T> ImmutableStack<T> withReversed(T ... elements) {
        return ImmutableArrayStack.newStackFromTopToBottom(elements);
    }

    @Override
    public <T> ImmutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    @Override
    public <T> ImmutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ImmutableArrayStack.newStackFromTopToBottom(items);
    }
}

