/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.AbstractPatternData;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.factories.IPatternOperationFactory;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractFilteredGraphicalUpdateOperation;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractHighlightAllPatternsInstancesPanelDialog;
import org.eclipse.emf.diffmerge.patterns.ui.util.PatternsInstancesUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HighlightAllPatternsInstancesPanelDialog
extends AbstractHighlightAllPatternsInstancesPanelDialog {
    protected Object _diagram;
    protected Object _color;
    protected boolean _highlightNodes;
    protected boolean _highlightEdges;
    protected boolean _highlightPorts;
    protected boolean _reuseStyleAtUpdate;
    private static final int BUTTON_WIDTH = 110;

    public HighlightAllPatternsInstancesPanelDialog(Set<IPatternInstance> instances_p, Object diagram_p, Shell parentShell_p, String dialogTitle_p, String dialogMessage_p) {
        super(parentShell_p, instances_p);
        this._diagram = diagram_p;
        this._color = this.instantiateColorObject(255, 0, 0);
        this._highlightNodes = true;
        this._highlightPorts = true;
        this._highlightEdges = true;
        this._reuseStyleAtUpdate = true;
    }

    protected abstract Object instantiateColorObject(int var1, int var2, int var3);

    protected abstract Object convertSWTRGBToColor(RGB var1);

    protected abstract RGB convertColorToSWTRGB(Object var1);

    protected abstract int colorRed(Object var1);

    protected abstract int colorGreen(Object var1);

    protected abstract int colorBlue(Object var1);

    @Override
    protected String getColumnText(IPatternInstance instance_p, int columnIndex_p) {
        if (columnIndex_p == 0) {
            if (instance_p.getPatternData() instanceof AbstractPatternData) {
                AbstractPatternData data = (AbstractPatternData)instance_p.getPatternData();
                return data.getId();
            }
        } else {
            if (columnIndex_p == 1) {
                return PatternsInstancesUIUtil.getInstanceAsText(instance_p);
            }
            if (columnIndex_p == 2) {
                return PatternsInstancesUIUtil.getPatternAsText(instance_p);
            }
        }
        return "";
    }

    @Override
    protected List<String> getColumnHeaders() {
        return Arrays.asList(Messages.HighlightAllPatternsInstances_DialogColumnHeaderInstance, Messages.HighlightAllPatternsInstances_DialogColumnHeaderInstance, Messages.HighlightAllPatternsInstances_DialogColumnHeaderPattern);
    }

    protected Composite createEmptyComposite(Composite parent_p, int columns_p) {
        Composite result = new Composite(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(columns_p, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        return result;
    }

    protected Button createPushButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        GridData data = new GridData(4, 4, false, false);
        data.widthHint = 110;
        result.setLayoutData((Object)data);
        return result;
    }

    private Button createHighlightButton(Composite parent_p) {
        Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Highlight);
        result.setEnabled(this._diagram != null);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                EditingDomain domain = null;
                List<IPatternInstance> selection = HighlightAllPatternsInstancesPanelDialog.this.getSelectedInstances();
                if (!selection.isEmpty()) {
                    EObject context = (EObject)selection.get(0).getScopeElement();
                    domain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain(context);
                }
                if (domain != null) {
                    CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)HighlightAllPatternsInstancesPanelDialog.this._operationFactory.instantiateHighlightOperation(HighlightAllPatternsInstancesPanelDialog.this._diagram, HighlightAllPatternsInstancesPanelDialog.this.getSelectedInstances(), new RGB(HighlightAllPatternsInstancesPanelDialog.this.colorRed(HighlightAllPatternsInstancesPanelDialog.this._color), HighlightAllPatternsInstancesPanelDialog.this.colorGreen(HighlightAllPatternsInstancesPanelDialog.this._color), HighlightAllPatternsInstancesPanelDialog.this.colorBlue(HighlightAllPatternsInstancesPanelDialog.this._color)), 3, HighlightAllPatternsInstancesPanelDialog.this._highlightEdges, HighlightAllPatternsInstancesPanelDialog.this._highlightNodes, HighlightAllPatternsInstancesPanelDialog.this._highlightPorts));
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
            }
        });
        return result;
    }

    private Button createResetHighlightButton(Composite parent_p) {
        Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Reset);
        result.setEnabled(this._diagram != null);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                List<IPatternInstance> instances = HighlightAllPatternsInstancesPanelDialog.this.getSelectedInstances();
                IModelEnvironment env = CorePatternsPlugin.getDefault().getModelEnvironment();
                if (env != null) {
                    env.execute((IModelOperation)HighlightAllPatternsInstancesPanelDialog.this.instantiateRestoreOperation(HighlightAllPatternsInstancesPanelDialog.this._diagram, instances));
                    List<IPatternInstance> instancesWithNoAvailableLayout = HighlightAllPatternsInstancesPanelDialog.this.getAllInstancesLayoutReuseNotPossible();
                    if (HighlightAllPatternsInstancesPanelDialog.this._reuseStyleAtUpdate) {
                        HashSet<String> patternsNames = new HashSet<String>();
                        String messageCatalogs = "";
                        if (instancesWithNoAvailableLayout.size() == instances.size()) {
                            messageCatalogs = Messages.HighlightAllPatternsInstances_NoInstanceLayoutAndStyleInformationAvailable;
                            messageCatalogs = String.valueOf(messageCatalogs) + "\n";
                        }
                        if (!instancesWithNoAvailableLayout.isEmpty()) {
                            messageCatalogs = String.valueOf(messageCatalogs) + Messages.HighlightAllPatternsInstances_ConsiderOpeningPatternCatalogs;
                            messageCatalogs = String.valueOf(messageCatalogs) + "\n";
                            for (IPatternInstance instance : instancesWithNoAvailableLayout) {
                                patternsNames.add(PatternsInstancesUIUtil.getPatternAsText(instance));
                            }
                            for (String str : patternsNames) {
                                messageCatalogs = String.valueOf(messageCatalogs) + str;
                                messageCatalogs = String.valueOf(messageCatalogs) + "\n";
                            }
                            MessageDialog.openInformation((Shell)HighlightAllPatternsInstancesPanelDialog.this.getShell(), (String)CorePatternsPlugin.getDefault().getLabel(), (String)messageCatalogs);
                        }
                        if (HighlightAllPatternsInstancesPanelDialog.this._reuseStyleAtUpdate && instancesWithNoAvailableLayout.size() != instances.size()) {
                            for (IPatternInstance instance : instances) {
                                AbstractFilteredGraphicalUpdateOperation lop = HighlightAllPatternsInstancesPanelDialog.this._operationFactory.instantiateLayoutReuseOperation(HighlightAllPatternsInstancesPanelDialog.this._diagram, instance, new Hashtable(), new Hashtable(), 0, 0, false, HighlightAllPatternsInstancesPanelDialog.this._reuseStyleAtUpdate, HighlightAllPatternsInstancesPanelDialog.this._diagram);
                                env.execute((IModelOperation)lop);
                            }
                        }
                    }
                }
            }
        });
        return result;
    }

    protected AbstractFilteredGraphicalUpdateOperation instantiateRestoreOperation(Object diagram_p, Collection<? extends IPatternInstance> instances_p) {
        IPatternOperationFactory factory = PatternCoreDiagramPlugin.getDefault().getOperationFactory();
        if (factory != null) {
            return factory.instantiateRestoreOperation(diagram_p, instances_p);
        }
        return null;
    }

    protected List<IPatternInstance> getAllInstancesLayoutReuseNotPossible() {
        ArrayList<IPatternInstance> result = new ArrayList<IPatternInstance>();
        List<IPatternInstance> selected = this.getSelectedInstances();
        for (IPatternInstance instance : selected) {
            if (this.isLayoutReusePossibleOn(instance)) continue;
            result.add(instance);
        }
        return result;
    }

    protected boolean isLayoutReusePossibleOn(IPatternInstance instance_p) {
        boolean result = false;
        if (instance_p.getPattern() instanceof TemplatePattern) {
            TemplatePattern pattern = (TemplatePattern)instance_p.getPattern();
            result = !pattern.getLayoutData().isEmpty();
        }
        return result;
    }

    protected List<IPatternInstance> getSelectedInstances() {
        IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
        return selection.toList();
    }

    private Button createHighlightRow(Composite parent_p) {
        Button highlightButton = this.createHighlightButton(parent_p);
        Composite composite = this.createEmptyComposite(parent_p, 6);
        ColorSelector colorButton = new ColorSelector(composite);
        colorButton.setColorValue(this.convertColorToSWTRGB(this._color));
        colorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (event_p.getNewValue() instanceof RGB) {
                    HighlightAllPatternsInstancesPanelDialog.this._color = HighlightAllPatternsInstancesPanelDialog.this.convertSWTRGBToColor((RGB)event_p.getNewValue());
                }
            }
        });
        final Button coverNodesButton = new Button(composite, 32);
        coverNodesButton.setText(Messages.InstancePanelDialog_Nodes);
        coverNodesButton.setSelection(this._highlightNodes);
        final Button coverPortsButton = new Button(composite, 32);
        coverPortsButton.setText(Messages.InstancePanelDialog_Ports);
        coverPortsButton.setSelection(this._highlightPorts);
        final Button coverEdgesButton = new Button(composite, 32);
        coverEdgesButton.setText(Messages.InstancePanelDialog_Edges);
        coverEdgesButton.setSelection(this._highlightEdges);
        Label separator = new Label(composite, 0);
        separator.setText("          ");
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
            }
        });
        coverNodesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                HighlightAllPatternsInstancesPanelDialog.this._highlightNodes = coverNodesButton.getSelection();
            }
        });
        coverPortsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                HighlightAllPatternsInstancesPanelDialog.this._highlightPorts = coverPortsButton.getSelection();
            }
        });
        coverEdgesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                HighlightAllPatternsInstancesPanelDialog.this._highlightEdges = coverEdgesButton.getSelection();
            }
        });
        return highlightButton;
    }

    @Override
    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        Control selectionControl = super.createCustomArea(result);
        Table selectionTable = null;
        if (selectionControl instanceof Table) {
            selectionTable = (Table)selectionControl;
            selectionTable.setVisible(false);
        }
        GridData dataMain = new GridData(4, 4, true, true);
        if (selectionTable != null) {
            selectionTable.setLayoutData((Object)dataMain);
            this.enhanceSelectionTable(selectionTable);
        }
        this.createButtonsArea(result);
        this.selectAll();
        return result;
    }

    private void createButtonsArea(Composite parent_p) {
        Group repGroup = new Group(parent_p, 0);
        repGroup.setText(Messages.InstancePanelDialog_Representation);
        repGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        repGroup.setLayout((Layout)new GridLayout(2, false));
        this.createHighlightRow((Composite)repGroup);
        this.createReuseStyleRow((Composite)repGroup);
    }

    private void enhanceSelectionTable(Table selectionTable_p) {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e_p) {
            }

            public void widgetDefaultSelected(SelectionEvent e_p) {
            }
        };
        selectionTable_p.addSelectionListener(listener);
    }

    @Override
    protected int getColumnWidth(int columnNb_p) {
        if (columnNb_p == 0) {
            return 0;
        }
        return 240;
    }

    private void createReuseStyleRow(Composite parent_p) {
        this.createResetHighlightButton(parent_p);
        this.createReuseStyleButton(parent_p);
    }

    private void createReuseStyleButton(Composite parent_p) {
        final Button reuseStyleButton = new Button(parent_p, 32);
        reuseStyleButton.setText(Messages.InstancePanelDialog_RestoreStyle);
        reuseStyleButton.setSelection(this._reuseStyleAtUpdate);
        reuseStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                HighlightAllPatternsInstancesPanelDialog.this._reuseStyleAtUpdate = reuseStyleButton.getSelection();
            }
        });
    }

    @Override
    protected Point getInitialSize() {
        Point result = super.getInitialSize();
        int sum = 0;
        int i = 0;
        while (i < this.getColumnsNumber()) {
            sum += this.getColumnWidth(i);
            ++i;
        }
        result.x = sum + 40;
        result.y = 250;
        return result;
    }
}

