/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.util.Collections;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.internal.wizards.ShareWizard;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalRepository;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.ui.controller.UIShareProjectController;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public final class ShareProjectHelper {
    private ShareProjectHelper() {
    }

    public static void share(InternalProject project, Shell shell) {
        ShareWizard rw = new ShareWizard();
        rw.init((ECPProvider)project.getProvider());
        WizardDialog wd = new WizardDialog(shell, (IWizard)rw);
        int result = wd.open();
        if (result == 0) {
            InternalRepository repository = (InternalRepository)rw.getSelectedRepository();
            project.undispose(repository);
            ESLocalProject localProject = EMFStoreProvider.INSTANCE.getProjectSpace(project);
            if (localProject.getUsersession() == null) {
                ESServerImpl server = (ESServerImpl)EMFStoreProvider.INSTANCE.getServerInfo(project.getRepository());
                ServerInfo serverInfo = (ServerInfo)server.toInternalAPI();
                RunESCommand.run((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ((ProjectSpace)((ESLocalProjectImpl)localProject).toInternalAPI()).setUsersession(serverInfo.getLastUsersession());
                        return null;
                    }
                });
            }
            new UIShareProjectController(shell, localProject).execute();
            project.notifyObjectsChanged(Collections.singleton(project), false);
            repository.notifyObjectsChanged(Collections.singleton(repository));
        }
    }
}

