/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;

class FocusableBrowserInformationControl
extends BrowserInformationControl {
    private static final LocationListener HYPER_LINK_LISTENER = new LocationListener(){

        public void changing(LocationEvent event) {
            if (!"about:blank".equals(event.location)) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                LSPEclipseUtils.open(event.location, page, null);
                event.doit = false;
            }
        }

        public void changed(LocationEvent event) {
        }
    };

    public FocusableBrowserInformationControl(Shell parent) {
        super(parent, "org.eclipse.jface.defaultfont", EditorsUI.getTooltipAffordanceString());
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        Browser b = (Browser)parent.getChildren()[0];
        b.addProgressListener(ProgressListener.completedAdapter(event -> {
            if (this.getInput() == null) {
                return;
            }
            Browser browser = (Browser)event.getSource();
            @Nullable Point constraints = this.getSizeConstraints();
            Point hint = this.computeSizeHint();
            this.setSize(hint.x, hint.y);
            browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"nowrap\"");
            Double width = 20.0 + (Double)browser.evaluate("return document.body.scrollWidth;");
            if (constraints != null && (double)constraints.x < width) {
                width = constraints.x;
            }
            this.setSize(width.intValue(), hint.y);
            browser.execute("document.getElementsByTagName(\"html\")[0].style.whiteSpace = \"normal\"");
            Double height = (Double)browser.evaluate("return document.body.scrollHeight;");
            if (constraints != null && (double)constraints.y < height) {
                height = constraints.y;
            }
            if (Platform.getPreferencesService().getBoolean("org.eclipse.ui.editors", "showTextHoverAffordance", true, null)) {
                FontData[] fontDatas = JFaceResources.getDialogFont().getFontData();
                height = (double)fontDatas[0].getHeight() + height;
            }
            this.setSize(width.intValue(), height.intValue());
        }));
        b.setJavascriptEnabled(true);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return parent -> {
            BrowserInformationControl res = new BrowserInformationControl(parent, "org.eclipse.jface.defaultfont", true);
            res.addLocationListener(HYPER_LINK_LISTENER);
            return res;
        };
    }
}

