/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session;

import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.auth.UsernameHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.net.ConnectionEndpointsIndicator;

public interface SessionContext
extends ConnectionEndpointsIndicator,
UsernameHolder,
PropertyResolver,
AttributeStore {
    public static final String DEFAULT_SSH_VERSION_PREFIX = "SSH-2.0-";
    public static final String FALLBACK_SSH_VERSION_PREFIX = "SSH-1.99-";
    public static final int MAX_VERSION_LINE_LENGTH = 256;

    public byte[] getSessionId();

    public String getClientVersion();

    public String getServerVersion();

    public boolean isAuthenticated();

    public static boolean isValidVersionPrefix(String version) {
        return GenericUtils.isNotEmpty(version) && (version.startsWith(DEFAULT_SSH_VERSION_PREFIX) || version.startsWith(FALLBACK_SSH_VERSION_PREFIX));
    }
}

