/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.commons.core.DateUtil;

public class RelativeBuildTimeLabelProvider
extends ColumnLabelProvider {
    public String getText(Object element) {
        IBuildPlan plan;
        if (element instanceof IBuildPlan && (plan = (IBuildPlan)element).getLastBuild() != null) {
            return this.getText(plan.getLastBuild());
        }
        if (element instanceof IBuild) {
            return this.getText((IBuild)element);
        }
        return "";
    }

    protected String getText(IBuild build) {
        long timestamp = build.getTimestamp();
        if (timestamp != 0L) {
            if (System.currentTimeMillis() - timestamp < 60000L) {
                return "< 1 min ago";
            }
            return DateUtil.getRelative((long)timestamp);
        }
        return null;
    }
}

