/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.internal.core.DebugCoreMessages;

public class OutputStreamMonitor
implements IFlushableStreamMonitor {
    private InputStream fStream;
    private ListenerList<IStreamListener> fListeners = new ListenerList();
    private boolean fBuffered = true;
    private StringBuilder fContents;
    private Thread fThread;
    private static final int BUFFER_SIZE = 8192;
    private boolean fKilled = false;
    private long lastSleep;
    private Charset fCharset;
    private final AtomicBoolean fDone;

    public OutputStreamMonitor(InputStream stream, Charset charset) {
        this.fStream = new BufferedInputStream(stream, 8192);
        this.fCharset = charset;
        this.fContents = new StringBuilder();
        this.fDone = new AtomicBoolean(false);
    }

    @Override
    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    protected void close() {
        if (this.fThread != null) {
            Thread thread = this.fThread;
            this.fThread = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.fListeners = new ListenerList();
        }
    }

    private void fireStreamAppended(String text) {
        this.getNotifier().notifyAppend(text);
    }

    @Override
    public synchronized String getContents() {
        return this.fContents.toString();
    }

    private void read() {
        try {
            this.internalRead();
        }
        finally {
            this.fDone.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void internalRead() {
        currentTime = this.lastSleep = System.currentTimeMillis();
        chars = new char[8192];
        read = 0;
        try {
            var5_4 = null;
            var6_7 = null;
            try {
                reader = this.fCharset == null ? new InputStreamReader(this.fStream) : new InputStreamReader(this.fStream, this.fCharset);
                try {
                    while (true) {
                        block28: {
                            try {
                                if (this.fKilled) {
                                    break;
                                }
                                read = reader.read(chars);
                                if (read <= 0) break block28;
                                text = new String(chars, 0, read);
                                var9_13 = this;
                                synchronized (var9_13) {
                                    if (this.isBuffered()) {
                                        this.fContents.append(text);
                                    }
                                    this.fireStreamAppended(text);
                                }
                            }
                            catch (IOException ioe) {
                                if (!this.fKilled) {
                                    DebugPlugin.log(ioe);
                                }
                                if (reader != null) {
                                    reader.close();
                                }
                                return;
                            }
                            catch (NullPointerException e) {
                                block29: {
                                    if (!this.fKilled && this.fThread != null) {
                                        DebugPlugin.log(e);
                                    }
                                    if (reader == null) break block29;
                                    reader.close();
                                }
                                return;
                            }
                        }
                        if ((currentTime = System.currentTimeMillis()) - this.lastSleep > 1000L) {
                            this.lastSleep = currentTime;
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException v1) {}
                        }
                        {
                            catch (Throwable var5_5) {
                                throw var5_5;
                            }
                        }
                        break;
                    }
                }
                finally {
                    if (read >= 0) ** continue;
                }
            }
            catch (Throwable var6_8) {
                if (var5_4 == null) {
                    var5_4 = var6_8;
                } else if (var5_4 != var6_8) {
                    var5_4.addSuppressed(var6_8);
                }
                throw var5_4;
            }
        }
        catch (IOException e) {
            DebugPlugin.log(e);
        }
    }

    protected void kill() {
        this.fKilled = true;
    }

    @Override
    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fDone.set(false);
            this.fThread = new Thread(this::read, DebugCoreMessages.OutputStreamMonitor_label);
            this.fThread.setDaemon(true);
            this.fThread.setPriority(1);
            this.fThread.start();
        }
    }

    @Override
    public synchronized void setBuffered(boolean buffer) {
        this.fBuffered = buffer;
    }

    @Override
    public synchronized void flushContents() {
        this.fContents.setLength(0);
    }

    @Override
    public synchronized boolean isBuffered() {
        return this.fBuffered;
    }

    private ContentNotifier getNotifier() {
        return new ContentNotifier();
    }

    public boolean isReadingDone() {
        return this.fDone.get();
    }

    class ContentNotifier
    implements ISafeRunnable {
        private IStreamListener fListener;
        private String fText;

        ContentNotifier() {
        }

        public void handleException(Throwable exception) {
            DebugPlugin.log(exception);
        }

        public void run() throws Exception {
            this.fListener.streamAppended(this.fText, OutputStreamMonitor.this);
        }

        public void notifyAppend(String text) {
            if (text == null) {
                return;
            }
            this.fText = text;
            Iterator iterator = OutputStreamMonitor.this.fListeners.iterator();
            while (iterator.hasNext()) {
                IStreamListener iStreamListener;
                this.fListener = iStreamListener = (IStreamListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.fListener = null;
            this.fText = null;
        }
    }
}

