/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dialogs;

import com.ibm.icu.text.BreakIterator;
import java.io.File;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.BoldStylerProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.StyledStringHighlighter;

public class FilteredPluginArtifactsSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.pde.ui.dialogs.FilteredPluginArtifactsSelectionDialog";
    private static final String S_EXTENSIONS = "showExtensions";
    private static final String S_EXTENSION_POINTS = "showExtensionPoints";
    private static final String S_EXPORTED_PACKAGES = "showExportedPackages";
    private static final String S_FEATURES = "showFeatures";
    private static final int TYPE_PLUGIN = 0;
    private static final int TYPE_EXTENSION = 1;
    private static final int TYPE_EXTENSION_POINT = 2;
    private static final int TYPE_EXPORTED_PACKAGE = 3;
    private static final int TYPE_FEATURE = 4;
    private Action extensionsAction = new ExtensionsAction();
    private Action extensionPointsAction = new ExtensionPointsAction();
    private Action exportedPackagesAction = new ExportedPackagesAction();
    private Action featuresAction = new FeaturesAction();
    private ExtensionsFilter extensionsFilter = new ExtensionsFilter();
    private ExtensionPointsFilter extensionPointsFilter = new ExtensionPointsFilter();
    private ExportedPackagesFilter exportedPackagesFilter = new ExportedPackagesFilter();
    private FeaturesFilter featuresFilter = new FeaturesFilter();
    private SearchLabelProvider searchLabelProvider = new SearchLabelProvider();
    private ILabelProvider detailsLabelProvider = new DetailedLabelProvider();

    public FilteredPluginArtifactsSelectionDialog(Shell shell) {
        super(shell, false);
        this.setTitle(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_title);
        this.setMessage(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_message);
        this.setSelectionHistory(new PluginSearchSelectionHistory());
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.setListLabelProvider((ILabelProvider)this.searchLabelProvider);
        this.setListSelectionLabelDecorator(this.searchLabelProvider);
        this.setDetailsLabelProvider(this.detailsLabelProvider);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.filtered_plugin_artifacts_dialog");
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new PluginSearchItemsFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        IFeatureModel model;
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        IPluginModelBase[] models = manager.getActiveModels(true);
        FeatureModelManager fManager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] fModels = fManager.getModels();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)PDEUIMessages.FilteredPluginArtifactsSelectionDialog_searching, (int)(models.length * 2 + fModels.length));
        IFeatureModel[] iFeatureModelArray = fModels;
        int n = fModels.length;
        int n2 = 0;
        while (n2 < n) {
            model = iFeatureModelArray[n2];
            contentProvider.add((Object)model, itemsFilter);
            subMonitor.worked(1);
            ++n2;
        }
        iFeatureModelArray = models;
        n = models.length;
        n2 = 0;
        while (n2 < n) {
            model = iFeatureModelArray[n2];
            IPluginExtensionPoint[] eps = model.getPluginBase().getExtensionPoints();
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int length = eps.length + extensions.length;
            SubMonitor subMonitor2 = subMonitor.split(1).setWorkRemaining(length);
            IPluginExtensionPoint[] iPluginExtensionPointArray = eps;
            int n3 = eps.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint ep = iPluginExtensionPointArray[n4];
                contentProvider.add((Object)ep, itemsFilter);
                subMonitor2.worked(1);
                ++n4;
            }
            iPluginExtensionPointArray = extensions;
            n3 = extensions.length;
            n4 = 0;
            while (n4 < n3) {
                IPluginExtensionPoint extension = iPluginExtensionPointArray[n4];
                contentProvider.add((Object)extension, itemsFilter);
                subMonitor2.worked(1);
                ++n4;
            }
            subMonitor2 = subMonitor.split(1);
            BundleDescription desc = model.getBundleDescription();
            if (desc != null) {
                ExportPackageDescription[] epds = desc.getExportPackages();
                subMonitor2.setWorkRemaining(epds.length);
                ExportPackageDescription[] exportPackageDescriptionArray = epds;
                int n5 = epds.length;
                int n6 = 0;
                while (n6 < n5) {
                    ExportPackageDescription epd = exportPackageDescriptionArray[n6];
                    int ee = (Integer)epd.getDirective("x-equinox-ee");
                    if (ee < 0) {
                        contentProvider.add((Object)epd, itemsFilter);
                    }
                    subMonitor2.worked(1);
                    ++n6;
                }
            }
            contentProvider.add((Object)model, itemsFilter);
            ++n2;
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    public String getElementName(Object item) {
        if (item instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)item;
            return model.getPluginBase().getId();
        }
        if (item instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint model = (IPluginExtensionPoint)item;
            return model.getFullId();
        }
        if (item instanceof IPluginExtension) {
            IPluginExtension model = (IPluginExtension)item;
            return model.getPoint();
        }
        if (item instanceof ExportPackageDescription) {
            ExportPackageDescription model = (ExportPackageDescription)item;
            return model.getName();
        }
        if (item instanceof IFeatureModel) {
            IFeatureModel model = (IFeatureModel)item;
            return model.getFeature().getId();
        }
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        return new PluginSearchComparator();
    }

    protected IStatus validateItem(Object item) {
        return new Status(0, "org.eclipse.pde.ui", 0, "", null);
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.extensionsAction);
        menuManager.add((IAction)this.extensionPointsAction);
        menuManager.add((IAction)this.exportedPackagesAction);
        menuManager.add((IAction)this.featuresAction);
    }

    protected void restoreDialog(IDialogSettings settings) {
        boolean state;
        super.restoreDialog(settings);
        if (settings.get(S_EXTENSIONS) != null) {
            state = settings.getBoolean(S_EXTENSIONS);
            this.extensionsAction.setChecked(state);
        }
        if (settings.get(S_EXTENSION_POINTS) != null) {
            state = settings.getBoolean(S_EXTENSION_POINTS);
            this.extensionPointsAction.setChecked(state);
        }
        if (settings.get(S_EXPORTED_PACKAGES) != null) {
            state = settings.getBoolean(S_EXPORTED_PACKAGES);
            this.exportedPackagesAction.setChecked(state);
        }
        if (settings.get(S_FEATURES) != null) {
            state = settings.getBoolean(S_FEATURES);
            this.featuresAction.setChecked(state);
        }
        this.addListFilter(this.extensionsFilter);
        this.addListFilter(this.extensionPointsFilter);
        this.addListFilter(this.exportedPackagesFilter);
        this.addListFilter(this.featuresFilter);
        this.applyFilter();
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
        settings.put(S_EXTENSIONS, this.extensionsAction.isChecked());
        settings.put(S_EXTENSION_POINTS, this.extensionPointsAction.isChecked());
        settings.put(S_EXPORTED_PACKAGES, this.exportedPackagesAction.isChecked());
        settings.put(S_FEATURES, this.featuresAction.isChecked());
    }

    public boolean close() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        return super.close();
    }

    private IPluginModelBase getModel(String id, String version) {
        IPluginModelBase[] models;
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        IPluginModelBase[] iPluginModelBaseArray = models = entry.getActiveModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (version.equals(model.getPluginBase().getVersion())) {
                return model;
            }
            ++n2;
        }
        return null;
    }

    private class DetailedLabelProvider
    extends LabelProvider {
        private DetailedLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)element;
                return this.getImage(model.getInstallLocation());
            }
            if (element instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint model = (IPluginExtensionPoint)element;
                return this.getImage(model.getModel().getInstallLocation());
            }
            if (element instanceof IPluginExtension) {
                IPluginExtension model = (IPluginExtension)element;
                return this.getImage(model.getModel().getInstallLocation());
            }
            if (element instanceof ExportPackageDescription) {
                ExportPackageDescription model = (ExportPackageDescription)element;
                String id = model.getSupplier().getName();
                String version = model.getSupplier().getVersion().toString();
                IPluginModelBase base = FilteredPluginArtifactsSelectionDialog.this.getModel(id, version);
                return this.getImage(base.getInstallLocation());
            }
            if (element instanceof IFeatureModel) {
                IFeatureModel model = (IFeatureModel)element;
                return this.getImage(model.getInstallLocation());
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)element;
                return model.getInstallLocation();
            }
            if (element instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint model = (IPluginExtensionPoint)element;
                return model.getModel().getInstallLocation();
            }
            if (element instanceof IPluginExtension) {
                IPluginExtension model = (IPluginExtension)element;
                return model.getModel().getInstallLocation();
            }
            if (element instanceof ExportPackageDescription) {
                ExportPackageDescription model = (ExportPackageDescription)element;
                String id = model.getSupplier().getName();
                String version = model.getSupplier().getVersion().toString();
                IPluginModelBase base = FilteredPluginArtifactsSelectionDialog.this.getModel(id, version);
                return base.getInstallLocation();
            }
            if (element instanceof IFeatureModel) {
                IFeatureModel model = (IFeatureModel)element;
                return model.getInstallLocation();
            }
            return null;
        }

        private Image getImage(String location) {
            if (new File(location).isFile()) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_obj.gif");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
    }

    private class ExportedPackagesAction
    extends Action {
        public ExportedPackagesAction() {
            super(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_showExportedPackages, 2);
            this.setChecked(true);
        }

        public void run() {
            FilteredPluginArtifactsSelectionDialog.this.exportedPackagesFilter.setEnabled(this.isChecked());
            FilteredPluginArtifactsSelectionDialog.this.scheduleRefresh();
        }
    }

    private class ExportedPackagesFilter
    extends ViewerFilter {
        private boolean enabled = true;

        private ExportedPackagesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enabled) {
                return true;
            }
            return !(element instanceof ExportPackageDescription);
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    private class ExtensionPointsAction
    extends Action {
        public ExtensionPointsAction() {
            super(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_showExtensionPoints, 2);
            this.setChecked(true);
        }

        public void run() {
            FilteredPluginArtifactsSelectionDialog.this.extensionPointsFilter.setEnabled(this.isChecked());
            FilteredPluginArtifactsSelectionDialog.this.scheduleRefresh();
        }
    }

    private class ExtensionPointsFilter
    extends ViewerFilter {
        private boolean enabled = true;

        private ExtensionPointsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enabled) {
                return true;
            }
            return !(element instanceof IPluginExtensionPoint);
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    private class ExtensionsAction
    extends Action {
        public ExtensionsAction() {
            super(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_showExtensions, 2);
            this.setChecked(true);
        }

        public void run() {
            FilteredPluginArtifactsSelectionDialog.this.extensionsFilter.setEnabled(this.isChecked());
            FilteredPluginArtifactsSelectionDialog.this.scheduleRefresh();
        }
    }

    private class ExtensionsFilter
    extends ViewerFilter {
        private boolean enabled = true;

        private ExtensionsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enabled) {
                return true;
            }
            return !(element instanceof IPluginExtension);
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    private class FeaturesAction
    extends Action {
        public FeaturesAction() {
            super(PDEUIMessages.FilteredPluginArtifactsSelectionDialog_showFeatures, 2);
            this.setChecked(true);
        }

        public void run() {
            FilteredPluginArtifactsSelectionDialog.this.featuresFilter.setEnabled(this.isChecked());
            FilteredPluginArtifactsSelectionDialog.this.scheduleRefresh();
        }
    }

    private class FeaturesFilter
    extends ViewerFilter {
        private boolean enabled = true;

        private FeaturesFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.enabled) {
                return true;
            }
            return !(element instanceof IFeatureModel);
        }

        public void setEnabled(boolean value) {
            this.enabled = value;
        }
    }

    private class PluginSearchComparator
    implements Comparator<Object> {
        private PluginSearchComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int id2;
            int id1 = this.getId(o1);
            if (id1 != (id2 = this.getId(o2))) {
                return id1 - id2;
            }
            return this.compareSimilarObjects(o1, o2);
        }

        private int getId(Object element) {
            if (element instanceof IPluginModelBase) {
                return 100;
            }
            if (element instanceof IPluginExtensionPoint) {
                return 200;
            }
            if (element instanceof IPluginExtension) {
                return 300;
            }
            if (element instanceof ExportPackageDescription) {
                return 400;
            }
            if (element instanceof IFeatureModel) {
                return 500;
            }
            return 0;
        }

        private int compareSimilarObjects(Object o1, Object o2) {
            if (o1 instanceof IPluginModelBase && o2 instanceof IPluginModelBase) {
                IPluginModelBase ipmb1 = (IPluginModelBase)o1;
                IPluginModelBase ipmb2 = (IPluginModelBase)o2;
                return this.comparePlugins(ipmb1.getPluginBase(), ipmb2.getPluginBase());
            }
            if (o1 instanceof IPluginExtensionPoint && o2 instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint ipep1 = (IPluginExtensionPoint)o1;
                IPluginExtensionPoint ipep2 = (IPluginExtensionPoint)o2;
                return this.compareExtensionPoints(ipep1, ipep2);
            }
            if (o1 instanceof IPluginExtension && o2 instanceof IPluginExtension) {
                IPluginExtension ipe1 = (IPluginExtension)o1;
                IPluginExtension ipe2 = (IPluginExtension)o2;
                int comparePointsResult = ipe1.getPoint().compareTo(ipe2.getPoint());
                if (comparePointsResult == 0) {
                    return this.comparePlugins(ipe1.getPluginBase(), ipe2.getPluginBase());
                }
                return comparePointsResult;
            }
            if (o1 instanceof ExportPackageDescription && o2 instanceof ExportPackageDescription) {
                ExportPackageDescription epd1 = (ExportPackageDescription)o1;
                ExportPackageDescription epd2 = (ExportPackageDescription)o2;
                int compareNamesResult = epd1.getName().compareTo(epd2.getName());
                if (compareNamesResult == 0) {
                    return this.compareBundleDescriptions(epd1.getSupplier(), epd2.getSupplier());
                }
                return compareNamesResult;
            }
            if (o1 instanceof IFeatureModel && o2 instanceof IFeatureModel) {
                IFeatureModel ifm1 = (IFeatureModel)o1;
                IFeatureModel ifm2 = (IFeatureModel)o2;
                return this.compareFeatures(ifm1, ifm2);
            }
            return 0;
        }

        private int comparePlugins(IPluginBase ipmb1, IPluginBase ipmb2) {
            return ipmb1.getId().compareTo(ipmb2.getId());
        }

        private int compareExtensionPoints(IPluginExtensionPoint ipep1, IPluginExtensionPoint ipep2) {
            return ipep1.getFullId().compareTo(ipep2.getFullId());
        }

        private int compareBundleDescriptions(BundleDescription bd1, BundleDescription bd2) {
            return bd1.getName().compareTo(bd2.getName());
        }

        private int compareFeatures(IFeatureModel ifm1, IFeatureModel ifm2) {
            return ifm1.getFeature().getId().compareTo(ifm2.getFeature().getId());
        }
    }

    private class PluginSearchItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public PluginSearchItemsFilter() {
            super((FilteredItemsSelectionDialog)FilteredPluginArtifactsSelectionDialog.this);
            String pattern = this.patternMatcher.getPattern();
            if (pattern.indexOf(42) != 0 && pattern.indexOf(63) != 0 && pattern.indexOf(46) != 0) {
                pattern = "*" + pattern;
                this.patternMatcher.setPattern(pattern);
            }
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            String id = null;
            if (item instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)item;
                id = model.getPluginBase().getId();
            } else if (item instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint model = (IPluginExtensionPoint)item;
                id = model.getFullId();
            } else if (item instanceof IPluginExtension) {
                IPluginExtension model = (IPluginExtension)item;
                id = model.getPoint();
            } else if (item instanceof ExportPackageDescription) {
                ExportPackageDescription model = (ExportPackageDescription)item;
                id = model.getName();
            } else if (item instanceof IFeatureModel) {
                IFeatureModel model = (IFeatureModel)item;
                id = model.getFeature().getId();
            }
            return this.matches(id) ? true : this.matchesSegments(id);
        }

        private boolean matchesSegments(String id) {
            BreakIterator iter = BreakIterator.getWordInstance();
            iter.setText(id);
            int i = iter.first();
            while (i != -1 && i < id.length()) {
                String word;
                int j = iter.following(i);
                if (j == -1) {
                    j = id.length();
                }
                if (Character.isLetterOrDigit(id.charAt(i)) && this.matches(word = id.substring(i, j))) {
                    return true;
                }
                i = j;
            }
            return false;
        }
    }

    private class PluginSearchSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private static final String M_ID = "id";
        private static final String M_PLUGIN_VERSION = "p_version";
        private static final String M_PLUGIN_ID = "p_id";
        private static final String M_TYPE = "type";

        private PluginSearchSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            Integer itype = memento.getInteger(M_TYPE);
            if (itype == null) {
                return null;
            }
            int type = itype;
            switch (type) {
                case 0: {
                    IPluginModelBase model = this.getModel(memento);
                    if (model == null) {
                        return null;
                    }
                    return model;
                }
                case 2: {
                    IPluginModelBase model = this.getModel(memento);
                    if (model == null) {
                        return null;
                    }
                    IPluginExtensionPoint[] points = model.getPluginBase().getExtensionPoints();
                    String epid = memento.getString(M_ID);
                    IPluginExtensionPoint[] iPluginExtensionPointArray = points;
                    int n = points.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginExtensionPoint point = iPluginExtensionPointArray[n2];
                        if (epid.equals(point.getFullId())) {
                            return point;
                        }
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    IPluginModelBase model = this.getModel(memento);
                    if (model == null) {
                        return null;
                    }
                    IPluginExtension[] extensions = model.getPluginBase().getExtensions();
                    String eid = memento.getString(M_ID);
                    IPluginExtension[] iPluginExtensionArray = extensions;
                    int n = extensions.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IPluginExtension extension = iPluginExtensionArray[n3];
                        if (eid.equals(extension.getPoint())) {
                            return extension;
                        }
                        ++n3;
                    }
                    break;
                }
                case 3: {
                    IPluginModelBase model = this.getModel(memento);
                    if (model == null) {
                        return null;
                    }
                    ExportPackageDescription[] descriptions = model.getBundleDescription().getExportPackages();
                    String pid = memento.getString(M_ID);
                    ExportPackageDescription[] exportPackageDescriptionArray = descriptions;
                    int n = descriptions.length;
                    int n4 = 0;
                    while (n4 < n) {
                        ExportPackageDescription desc = exportPackageDescriptionArray[n4];
                        if (pid.equals(desc.getName())) {
                            return desc;
                        }
                        ++n4;
                    }
                }
                case 4: {
                    IFeatureModel fModel = this.getFeatureModel(memento);
                    if (fModel == null) {
                        return null;
                    }
                    return fModel;
                }
            }
            return null;
        }

        protected IFeatureModel getFeatureModel(IMemento memento) {
            IFeatureModel[] models;
            String id = memento.getString(M_ID);
            String version = memento.getString(M_PLUGIN_VERSION);
            IFeatureModel[] iFeatureModelArray = models = PDECore.getDefault().getFeatureModelManager().getModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel model = iFeatureModelArray[n2];
                IFeature feature = model.getFeature();
                if (feature.getId().equals(id) && feature.getVersion().equals(version)) {
                    return model;
                }
                ++n2;
            }
            return null;
        }

        protected IPluginModelBase getModel(IMemento memento) {
            IPluginModelBase[] models;
            String id = memento.getString(M_PLUGIN_ID);
            String version = memento.getString(M_PLUGIN_VERSION);
            ModelEntry entry = PluginRegistry.findEntry((String)id);
            if (entry == null) {
                return null;
            }
            IPluginModelBase[] iPluginModelBaseArray = models = entry.getActiveModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (version.equals(model.getPluginBase().getVersion())) {
                    return model;
                }
                ++n2;
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)item;
                memento.putInteger(M_TYPE, 0);
                memento.putString(M_PLUGIN_ID, model.getPluginBase().getId());
                memento.putString(M_PLUGIN_VERSION, model.getPluginBase().getVersion());
            } else if (item instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint model = (IPluginExtensionPoint)item;
                memento.putInteger(M_TYPE, 2);
                memento.putString(M_ID, model.getFullId());
                memento.putString(M_PLUGIN_ID, model.getPluginBase().getId());
                memento.putString(M_PLUGIN_VERSION, model.getPluginBase().getVersion());
            } else if (item instanceof IPluginExtension) {
                IPluginExtension model = (IPluginExtension)item;
                memento.putInteger(M_TYPE, 1);
                memento.putString(M_ID, model.getPoint());
                memento.putString(M_PLUGIN_ID, model.getPluginBase().getId());
                memento.putString(M_PLUGIN_VERSION, model.getPluginBase().getVersion());
            } else if (item instanceof ExportPackageDescription) {
                ExportPackageDescription model = (ExportPackageDescription)item;
                memento.putInteger(M_TYPE, 3);
                memento.putString(M_ID, model.getName());
                memento.putString(M_PLUGIN_ID, model.getSupplier().getSymbolicName());
                memento.putString(M_PLUGIN_VERSION, model.getSupplier().getVersion().toString());
            } else if (item instanceof IFeatureModel) {
                IFeatureModel model = (IFeatureModel)item;
                memento.putInteger(M_TYPE, 4);
                memento.putString(M_ID, model.getFeature().getId());
                memento.putString(M_PLUGIN_VERSION, model.getFeature().getVersion());
            }
        }
    }

    private class SearchLabelProvider
    extends LabelProvider
    implements ILabelDecorator,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private BoldStylerProvider boldStylerProvider;
        private StyledStringHighlighter styledStringHighlighter = new StyledStringHighlighter();

        private SearchLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ExportPackageDescription) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public String getText(Object object) {
            if (object instanceof IPluginBase) {
                return ((IPluginBase)object).getId();
            }
            if (object instanceof IPluginImport) {
                IPluginImport dep = (IPluginImport)object;
                return String.valueOf(dep.getId()) + " - " + dep.getPluginBase().getId();
            }
            if (object instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)object;
                return String.valueOf(extension.getPoint()) + " - " + extension.getPluginBase().getId();
            }
            if (object instanceof IPluginExtensionPoint) {
                return ((IPluginExtensionPoint)object).getFullId();
            }
            if (object instanceof ExportPackageDescription) {
                ExportPackageDescription epd = (ExportPackageDescription)object;
                return String.valueOf(epd.getName()) + ' ' + '(' + epd.getVersion() + ')';
            }
            if (object instanceof IFeatureModel) {
                IFeatureModel fModel = (IFeatureModel)object;
                IFeature feature = fModel.getFeature();
                return String.valueOf(feature.getId()) + ' ' + '(' + feature.getVersion() + ')';
            }
            return PDEPlugin.getDefault().getLabelProvider().getText(object);
        }

        public Image decorateImage(Image image, Object element) {
            return null;
        }

        public String decorateText(String text, Object element) {
            if (element instanceof ExportPackageDescription) {
                ExportPackageDescription epd = (ExportPackageDescription)element;
                return text.concat(" - " + epd.getSupplier().getSymbolicName());
            }
            return text;
        }

        public StyledString getStyledText(Object element) {
            String text = this.getText(element);
            Text patternControl = (Text)FilteredPluginArtifactsSelectionDialog.this.getPatternControl();
            if (patternControl == null) {
                return new StyledString(text);
            }
            String pattern = patternControl.getText();
            return this.styledStringHighlighter.highlight(text, pattern, this.getBoldStylerProvider().getBoldStyler());
        }

        private BoldStylerProvider getBoldStylerProvider() {
            if (this.boldStylerProvider != null) {
                return this.boldStylerProvider;
            }
            this.boldStylerProvider = new BoldStylerProvider(FilteredPluginArtifactsSelectionDialog.this.getDialogArea().getFont());
            return this.boldStylerProvider;
        }

        public void dispose() {
            if (this.boldStylerProvider != null) {
                this.boldStylerProvider.dispose();
            }
            super.dispose();
        }
    }
}

