/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;

public class DocCommentScanner
extends Scanner {
    private int pos;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int col;
    private int unicodeConversionBp = 0;
    private char[] docCommentBuffer = new char[1024];
    private int docCommentCount;
    private String docComment = null;

    protected DocCommentScanner(Factory factory, CharBuffer charBuffer) {
        super(factory, charBuffer);
    }

    protected DocCommentScanner(Factory factory, char[] cArray, int n) {
        super(factory, cArray, n);
    }

    private void expandCommentBuffer() {
        char[] cArray = new char[this.docCommentBuffer.length * 2];
        System.arraycopy(this.docCommentBuffer, 0, cArray, 0, this.docCommentBuffer.length);
        this.docCommentBuffer = cArray;
    }

    private int digit(int n) {
        char c = this.ch;
        int n2 = Character.digit(c, n);
        if (n2 >= 0 && c > '\u007f') {
            this.ch = "0123456789abcdef".charAt(n2);
        }
        return n2;
    }

    private void convertUnicode() {
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            ++this.col;
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                    ++this.col;
                } while (this.ch == 'u');
                int n = this.bp + 3;
                if (n < this.buflen) {
                    int n2;
                    int n3 = n2 = this.digit(16);
                    while (this.bp < n && n2 >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        ++this.col;
                        n2 = this.digit(16);
                        n3 = (n3 << 4) + n2;
                    }
                    if (n2 >= 0) {
                        this.ch = (char)n3;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
            } else {
                --this.bp;
                this.ch = (char)92;
                --this.col;
            }
        }
    }

    private void scanChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        switch (this.ch) {
            case '\r': {
                this.col = 0;
                break;
            }
            case '\n': {
                if (this.bp != 0 && this.buf[this.bp - 1] == '\r') break;
                this.col = 0;
                break;
            }
            case '\t': {
                this.col = this.col / 8 * 8 + 8;
                break;
            }
            case '\\': {
                ++this.col;
                this.convertUnicode();
                break;
            }
            default: {
                ++this.col;
            }
        }
    }

    private void scanDocCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                if (this.docCommentCount == this.docCommentBuffer.length) {
                    this.expandCommentBuffer();
                }
                this.docCommentBuffer[this.docCommentCount++] = this.ch;
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    public void nextToken() {
        this.docComment = null;
        super.nextToken();
    }

    public String docComment() {
        return this.docComment;
    }

    protected void processComment(Scanner.CommentStyle commentStyle) {
        int n;
        if (commentStyle != Scanner.CommentStyle.JAVADOC) {
            return;
        }
        this.pos = this.pos();
        this.buf = this.getRawCharacters(this.pos, this.endPos());
        this.buflen = this.buf.length;
        this.bp = 0;
        this.col = 0;
        this.docCommentCount = 0;
        boolean bl = true;
        this.scanDocCommentChar();
        this.scanDocCommentChar();
        while (this.bp < this.buflen && this.ch == '*') {
            this.scanDocCommentChar();
        }
        if (this.bp < this.buflen && this.ch == '/') {
            this.docComment = "";
            return;
        }
        if (this.bp < this.buflen) {
            if (this.ch == '\n') {
                this.scanDocCommentChar();
                bl = false;
            } else if (this.ch == '\r') {
                this.scanDocCommentChar();
                if (this.ch == '\n') {
                    this.scanDocCommentChar();
                    bl = false;
                }
            }
        }
        block16: while (this.bp < this.buflen) {
            block17: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case ' ': {
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\t': {
                        this.col = (this.col - 1) / 8 * 8 + 8;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\f': {
                        this.col = 0;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                }
            }
            if (this.ch == '*') {
                do {
                    this.scanDocCommentChar();
                } while (this.ch == '*');
                if (this.ch == '/') {
                    break;
                }
            } else if (!bl) {
                for (n = 1; n < this.col; ++n) {
                    if (this.docCommentCount == this.docCommentBuffer.length) {
                        this.expandCommentBuffer();
                    }
                    this.docCommentBuffer[this.docCommentCount++] = 32;
                }
            }
            block20: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        this.scanDocCommentChar();
                        if (this.ch == '/') break block16;
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = 42;
                        continue block20;
                    }
                    case '\t': 
                    case ' ': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        continue block20;
                    }
                    case '\f': {
                        this.scanDocCommentChar();
                        break block20;
                    }
                    case '\r': {
                        this.scanDocCommentChar();
                        if (this.ch != '\n') {
                            if (this.docCommentCount == this.docCommentBuffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.docCommentBuffer[this.docCommentCount++] = 10;
                            break block20;
                        }
                    }
                    case '\n': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        break block20;
                    }
                    default: {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        continue block20;
                    }
                }
            }
            bl = false;
        }
        if (this.docCommentCount > 0) {
            block21: for (n = this.docCommentCount - 1; n > -1; --n) {
                switch (this.docCommentBuffer[n]) {
                    case '*': {
                        continue block21;
                    }
                }
            }
            this.docCommentCount = n + 1;
            this.docComment = new String(this.docCommentBuffer, 0, this.docCommentCount);
        } else {
            this.docComment = "";
        }
    }

    public Position.LineMap getLineMap() {
        char[] cArray = this.getRawCharacters();
        return Position.makeLineMap(cArray, cArray.length, true);
    }

    public static class Factory
    extends Scanner.Factory {
        public static void preRegister(final Context context) {
            context.put(scannerFactoryKey, new Context.Factory<Scanner.Factory>(){

                @Override
                public Factory make() {
                    return new Factory(context);
                }
            });
        }

        protected Factory(Context context) {
            super(context);
        }

        public Scanner newScanner(CharSequence charSequence) {
            if (charSequence instanceof CharBuffer) {
                return new DocCommentScanner(this, (CharBuffer)charSequence);
            }
            char[] cArray = ((Object)charSequence).toString().toCharArray();
            return this.newScanner(cArray, cArray.length);
        }

        public Scanner newScanner(char[] cArray, int n) {
            return new DocCommentScanner(this, cArray, n);
        }
    }
}

