/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx.perspective;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.command.CommandService;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.preferences.Value;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public class PerspectiveSwitcherNode
extends HBox {
    private final EPartService partService;
    private final GraphicsLoader loader;
    private final MPerspectiveStack stack;
    private static final String STYLESHEET_URL = PerspectiveSwitcherNode.class.getResource("default.css").toExternalForm();
    private final Value<List<String>> lastPerspectives;

    @Inject
    PerspectiveSwitcherNode(IEventBroker eventBroker, GraphicsLoader loader, MApplication application, MWindow window, MHandlerContainer handlerContainer, EPartService partService, EModelService modelService, CommandService commandService, @Preference(key="perspectiveOrder") Value<List<String>> lastPerspectives) {
        this.getStyleClass().add((Object)"perspective-switcher");
        this.lastPerspectives = lastPerspectives;
        this.loader = loader;
        this.partService = partService;
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this::handleSelectedElement);
        Button dialogbutton = new Button();
        dialogbutton.getStyleClass().add((Object)"dialog-opener");
        String commandId = handlerContainer.getHandlers().stream().filter(h -> h.getContributionURI().endsWith("org.eclipse.fx.ui.workbench.fx.perspective.SwitchPerspectiveDialogHandler")).findFirst().map(h -> h.getCommand().getElementId()).orElse(null);
        if (commandId == null) {
            commandId = window.getHandlers().stream().filter(h -> h.getContributionURI().endsWith("org.eclipse.fx.ui.workbench.fx.perspective.SwitchPerspectiveDialogHandler")).findFirst().map(h -> h.getCommand().getElementId()).orElse(null);
        }
        if (commandId == null) {
            commandId = application.getHandlers().stream().filter(h -> h.getContributionURI().endsWith("org.eclipse.fx.ui.workbench.fx.perspective.SwitchPerspectiveDialogHandler")).findFirst().map(h -> h.getCommand().getElementId()).orElse(null);
        }
        if (commandId != null) {
            String fCommandId = commandId;
            dialogbutton.setOnAction(e -> commandService.execute(fCommandId, Collections.emptyMap()));
            Separator separator = new Separator();
            separator.setOrientation(Orientation.VERTICAL);
            this.getChildren().addAll((Object[])new Node[]{dialogbutton, separator});
        }
        this.stack = window.getChildren().get(0) instanceof MPerspectiveStack ? (MPerspectiveStack)window.getChildren().get(0) : null;
        if (this.stack != null) {
            MPerspective tmp = (MPerspective)this.stack.getSelectedElement();
            if (tmp == null && !this.stack.getChildren().isEmpty()) {
                tmp = (MPerspective)this.stack.getChildren().get(0);
            }
            MPerspective selected = tmp;
            @Nullable List value = (List)lastPerspectives.getValue();
            if (value != null && !value.isEmpty()) {
                List buttonList = this.stack.getChildren().stream().filter(p -> p.isToBeRendered()).filter(p -> value.contains(p.getElementId())).map(p -> new PerspectiveButton(this, loader, (MPerspective)p, partService, p == selected)).collect(Collectors.toList());
                if (selected != null && !value.contains(selected.getElementId())) {
                    buttonList.add(new PerspectiveButton(this, loader, selected, partService, true));
                    this.publishNewPerspectiveList(selected.getElementId(), true);
                }
                this.getChildren().addAll(buttonList);
            } else if (selected != null) {
                this.getChildren().add((Object)new PerspectiveButton(this, loader, selected, partService, true));
                this.publishNewPerspectiveList(selected.getElementId(), true);
            }
        }
    }

    void publishNewPerspectiveList(String newPerspective, boolean add) {
        ArrayList<String> value = (ArrayList<String>)this.lastPerspectives.getValue();
        value = value == null ? new ArrayList<String>() : new ArrayList(value);
        if (add && !value.contains(newPerspective)) {
            value.add(newPerspective);
        } else {
            value.remove(newPerspective);
        }
        this.lastPerspectives.publish(value);
    }

    public String getUserAgentStylesheet() {
        return STYLESHEET_URL;
    }

    private void handleSelectedElement(Event event) {
        MPerspective p;
        if (event.getProperty("ChangedElement") == this.stack && (p = (MPerspective)event.getProperty("NewValue")) != null) {
            this.getChildren().stream().filter(n -> n instanceof PerspectiveButton).map(n -> (PerspectiveButton)((Object)n)).forEach(b -> b.setSelected(b.perspective == p));
            if (!this.getChildren().stream().filter(n -> n instanceof PerspectiveButton).map(n -> (PerspectiveButton)((Object)n)).filter(pe -> pe.perspective == p).findFirst().isPresent()) {
                this.getChildren().add((Object)new PerspectiveButton(this, this.loader, p, this.partService, true));
                this.publishNewPerspectiveList(p.getElementId(), true);
            }
        }
    }

    static class PerspectiveButton
    extends ToggleButton {
        final MPerspective perspective;

        public PerspectiveButton(PerspectiveSwitcherNode container, GraphicsLoader loader, MPerspective perspective, EPartService service, boolean toggled) {
            this.setSelected(toggled);
            this.getStyleClass().add((Object)"perspective-button");
            this.setText(perspective.getLocalizedLabel());
            if (perspective.getIconURI() != null) {
                URI uri = URI.createURI((String)perspective.getIconURI());
                this.setGraphic(loader.getGraphicsNode((org.eclipse.fx.core.URI)new EMFUri(uri)));
            }
            this.perspective = perspective;
            this.setOnAction(e -> service.switchPerspective(perspective));
            ContextMenu m = new ContextMenu();
            MenuItem item = new MenuItem("Remove");
            item.disableProperty().bind((ObservableValue)this.selectedProperty());
            item.setOnAction(e -> {
                container.getChildren().remove((Object)this);
                container.publishNewPerspectiveList(perspective.getElementId(), false);
            });
            m.getItems().add((Object)item);
            this.setContextMenu(m);
        }
    }
}

